/*
 * Decompiled with CFR 0.152.
 */
package ink.gfwl.jd.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import ink.gfwl.jd.base.BaseQueryParam;
import ink.gfwl.jd.common.ProductCheckExts;
import ink.gfwl.jd.common.ProductExts;
import ink.gfwl.jd.common.ProductPriceExts;
import ink.gfwl.jd.common.ProductStyleExts;
import ink.gfwl.jd.config.RequestURL;
import ink.gfwl.jd.model.order.params.OrderPrepareCheckParam;
import ink.gfwl.jd.model.product.ProductModel;
import ink.gfwl.jd.model.product.params.ProductCostParam;
import ink.gfwl.jd.model.product.result.ProductAreaLimitResult;
import ink.gfwl.jd.model.product.result.ProductCategoryResult;
import ink.gfwl.jd.model.product.result.ProductCheckResult;
import ink.gfwl.jd.model.product.result.ProductFreightResult;
import ink.gfwl.jd.model.product.result.ProductImageResult;
import ink.gfwl.jd.model.product.result.ProductMatterResult;
import ink.gfwl.jd.model.product.result.ProductMatterStyleResult;
import ink.gfwl.jd.model.product.result.ProductNumberResult;
import ink.gfwl.jd.model.product.result.ProductPriceResult;
import ink.gfwl.jd.model.product.result.ProductSkuPageResult;
import ink.gfwl.jd.model.product.result.ProductStateResult;
import ink.gfwl.jd.model.product.result.ProductStockResult;
import ink.gfwl.jd.util.HttpUtil;
import ink.gfwl.jd.util.StrUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProductService
extends RequestURL {
    @Resource
    private BaseQueryParam baseQueryParam;

    public ProductModel<List<ProductNumberResult>> queryProductNumber() {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/product/getPageNum", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<List<ProductNumberResult>>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<ProductSkuPageResult> queryProductGoods(Integer pageNum, Integer pageSize, long offset) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("pageNum", pageNum);
        params.put("pageSize", pageSize);
        params.put("offset", offset);
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/product/querySkuByPage", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<ProductSkuPageResult>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<ProductMatterResult> queryProductDetail(String sku) {
        return this.queryProductDetail(sku, null);
    }

    public ProductModel<ProductMatterResult> queryProductDetail(String sku, List<ProductExts> productExts) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("sku", sku);
        if (productExts != null) {
            params.put("queryExts", StrUtils.enumArrConvertStr(productExts));
        }
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/product/getDetail", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<ProductMatterResult>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<ProductMatterStyleResult> queryProductDetailStyle(String sku) {
        return this.queryProductDetailStyle(sku, null);
    }

    public ProductModel<ProductMatterStyleResult> queryProductDetailStyle(String sku, List<ProductStyleExts> styleExts) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("sku", sku);
        if (styleExts != null) {
            params.put("queryExts", StrUtils.enumArrConvertStr(styleExts));
        }
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/product/getDetailStyle", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<ProductMatterStyleResult>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<Map<Long, List<ProductImageResult>>> queryProductImage(String sku) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("sku", sku);
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/product/skuImage", params);
        System.out.println(rs);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<Map<Long, List<ProductImageResult>>>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<ProductStateResult> queryProductState(String sku) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("sku", sku);
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/product/skuImage", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<ProductStateResult>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<ProductCheckResult> queryProductCheck(String skuIds, List<ProductCheckExts> queryExts) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("skuIds", skuIds);
        if (queryExts != null) {
            params.put("queryExts", StrUtils.enumArrConvertStr(queryExts));
        }
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/product/check", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<ProductCheckResult>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<ProductAreaLimitResult> queryProductAreaLimit(String skuIds, String province, String city, String county, String town) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("skuIds", skuIds);
        params.put("province", province);
        params.put("city", city);
        params.put("county", county);
        params.put("town", town);
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/product/checkAreaLimit", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<ProductAreaLimitResult>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<ProductCategoryResult> queryProductCategory(String cid) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("cid", cid);
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/product/getCategory", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<ProductCategoryResult>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<List<ProductPriceResult>> queryProductPrice(String sku, List<ProductPriceExts> queryExts) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("sku", sku);
        if (queryExts != null) {
            params.put("queryExts", StrUtils.enumArrConvertStr(queryExts));
        }
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/price/getSellPrice", params);
        System.out.println(rs);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<List<ProductPriceResult>>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<ProductStockResult> queryProductStock(List<OrderPrepareCheckParam> skuNums, ProductCostParam area) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("skuNums", JSONObject.toJSONString(skuNums));
        params.put("area", area.getArea());
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/stock/getNewStockById", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<ProductStockResult>>(){}, (Feature[])new Feature[0]);
    }

    public ProductModel<ProductFreightResult> queryProductFreight(List<OrderPrepareCheckParam> sku, int province, int city, int county, int town, int paymentType) {
        return this.queryProductFreight(sku, province, city, county, town, paymentType, false);
    }

    public ProductModel<ProductFreightResult> queryProductFreight(List<OrderPrepareCheckParam> sku, int province, int city, int county, int town, int paymentType, boolean conFreight) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("sku", JSONObject.toJSONString(sku));
        params.put("province", province);
        params.put("city", city);
        params.put("county", county);
        params.put("town", town);
        params.put("paymentType", paymentType);
        if (conFreight) {
            params.put("queryExts", "conFreight");
        }
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/order/getFreight", params);
        return (ProductModel)JSONObject.parseObject((String)rs, (TypeReference)new TypeReference<ProductModel<ProductFreightResult>>(){}, (Feature[])new Feature[0]);
    }
}

