/*
 * Decompiled with CFR 0.152.
 */
package ink.gfwl.jd.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import ink.gfwl.jd.config.JdConfig;
import ink.gfwl.jd.config.RequestURL;
import ink.gfwl.jd.model.token.TokenModel;
import ink.gfwl.jd.util.HttpUtil;
import ink.gfwl.jd.util.MD5Util;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TokenUtils
extends RequestURL {
    @Resource
    private JdConfig jdConfig;
    @Resource(name="peakRedis")
    private RedisTemplate<String, TokenModel> redisTemplate;

    private Map<String, Object> getLoginInfo() {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        String grantType = "access_token";
        params.put("grant_type", grantType);
        params.put("username", this.jdConfig.getUsername());
        params.put("password", MD5Util.getMD5Str(this.jdConfig.getPassword()));
        String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
        String timestamp = new SimpleDateFormat(TIME_FORMAT).format(System.currentTimeMillis());
        params.put("timestamp", timestamp);
        params.put("client_id", this.jdConfig.getClientId());
        String sign = this.jdConfig.getClientSecret() + timestamp + this.jdConfig.getClientId() + this.jdConfig.getUsername() + MD5Util.getMD5Str(this.jdConfig.getPassword()) + grantType + this.jdConfig.getClientSecret();
        sign = Objects.requireNonNull(MD5Util.getMD5Str(sign)).toUpperCase();
        params.put("sign", sign);
        return params;
    }

    public TokenModel getToken() {
        TokenModel tokenModel = (TokenModel)this.redisTemplate.opsForValue().get((Object)"peak:jd:token");
        if (tokenModel == null) {
            String rs = HttpUtil.httpPost("https://bizapi.jd.com/oauth2/access_token", this.getLoginInfo());
            tokenModel = (TokenModel)JSONObject.toJavaObject((JSON)JSON.parseObject((String)rs), TokenModel.class);
            this.redisTemplate.opsForValue().set((Object)"peak:jd:token", (Object)tokenModel, (long)(tokenModel.getResult().getExpires_in() - 1000), TimeUnit.SECONDS);
        }
        return tokenModel;
    }

    public String getTokenStr() {
        return this.getToken().getResult().getAccess_token();
    }
}

