/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.openhtmltopdf.factory;

import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class AutoFont {
    private AutoFont() {
    }

    public static List<CSSFont> findFontsInDirectory(Path directory, List<String> validFileExtensions, boolean recurse, boolean followLinks) throws IOException {
        FontFileProcessor processor = new FontFileProcessor(validFileExtensions);
        int maxDepth = recurse ? Integer.MAX_VALUE : 1;
        EnumSet<FileVisitOption> options = followLinks ? EnumSet.of(FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
        Files.walkFileTree(directory, options, maxDepth, processor);
        return processor.getFontsAdded();
    }

    public static List<CSSFont> findFontsInDirectory(Path directory) throws IOException {
        return AutoFont.findFontsInDirectory(directory, Collections.singletonList("ttf"), true, true);
    }

    public static String toCSSEscapedFontFamily(List<CSSFont> fontsList) {
        return fontsList.stream().map(fnt -> '\'' + fnt.familyCssEscaped() + '\'').distinct().collect(Collectors.joining(", "));
    }

    public static void toBuilder(PdfRendererBuilder builder, List<CSSFont> fonts) {
        for (CSSFont font : fonts) {
            builder.useFont(font.path.toFile(), font.family, Integer.valueOf(font.weight), font.style, true);
        }
    }

    public static class FontFileProcessor
    extends SimpleFileVisitor<Path> {
        private final List<String> validFileExtensions;
        private final List<CSSFont> fontsAdded = new ArrayList<CSSFont>();

        public FontFileProcessor(List<String> validFileExtensions) {
            this.validFileExtensions = new ArrayList<String>(validFileExtensions);
        }

        public List<CSSFont> getFontsAdded() {
            return this.fontsAdded;
        }

        @Override
        public FileVisitResult visitFile(Path font, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile() && this.isValidFont(font)) {
                try {
                    Font f = Font.createFont(0, font.toFile());
                    String family = f.getFamily();
                    String name = f.getFontName(Locale.US).toLowerCase(Locale.US);
                    int weight = name.contains("bold") ? 700 : 400;
                    BaseRendererBuilder.FontStyle style = name.contains("italic") ? BaseRendererBuilder.FontStyle.ITALIC : BaseRendererBuilder.FontStyle.NORMAL;
                    CSSFont fnt = new CSSFont(font, family, weight, style);
                    this.onValidFont(fnt);
                    this.fontsAdded.add(fnt);
                }
                catch (FontFormatException ffe) {
                    this.onInvalidFont(font, ffe);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        protected void onValidFont(CSSFont font) {
            System.out.format("Adding font with path = '%s', name = '%s', weight = %d, style = %s%n", font.path, font.family, font.weight, font.style.name());
        }

        protected void onInvalidFont(Path font, FontFormatException ffe) {
            System.err.println("Ignoring font file with invalid font format: " + font);
            System.err.println("Exception details: ");
            ffe.printStackTrace();
        }

        protected boolean isValidFont(Path font) {
            return this.validFileExtensions.stream().anyMatch(ext -> font.toString().endsWith((String)ext));
        }
    }

    public static class CSSFont {
        public final Path path;
        public final String family;
        public final int weight;
        public final BaseRendererBuilder.FontStyle style;

        public CSSFont(Path path, String family, int weight, BaseRendererBuilder.FontStyle style) {
            this.path = path;
            this.family = family;
            this.weight = weight;
            this.style = style;
        }

        public String familyCssEscaped() {
            return this.family.replace("'", "\\'");
        }

        public int hashCode() {
            return Objects.hash(this.path, this.family, this.weight, this.style);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            CSSFont b = (CSSFont)other;
            return Objects.equals(this.path, b.path) && Objects.equals(this.family, b.family) && this.weight == b.weight && this.style == b.style;
        }
    }
}

