/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.openhtmltopdf.factory;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.support.ICUBidiReorderer;
import com.openhtmltopdf.bidi.support.ICUBidiSplitter;
import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FSDOMMutator;
import com.openhtmltopdf.extend.FSObjectDrawer;
import com.openhtmltopdf.extend.FSObjectDrawerFactory;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.impl.FSDefaultCacheStore;
import com.openhtmltopdf.latexsupport.LaTeXDOMMutator;
import com.openhtmltopdf.mathmlsupport.MathMLDrawer;
import com.openhtmltopdf.objects.jfreechart.JFreeChartBarDiagramObjectDrawer;
import com.openhtmltopdf.objects.jfreechart.JFreeChartPieDiagramObjectDrawer;
import com.openhtmltopdf.objects.zxing.ZXingObjectDrawer;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.render.DefaultObjectDrawerFactory;
import com.openhtmltopdf.svgsupport.BatikSVGDrawer;
import com.openhtmltopdf.util.XRLog;
import ink.rayin.htmladapter.openhtmltopdf.factory.OpenhttptopdfRenderBuilder;
import ink.rayin.tools.utils.ResourceUtil;
import ink.rayin.tools.utils.StringUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class OpenhttptopdfRendererObjectFactory
implements PooledObjectFactory<OpenhttptopdfRenderBuilder> {
    private static Logger logger = LoggerFactory.getLogger(OpenhttptopdfRendererObjectFactory.class);
    private HashMap<String, File> fontFileCache = new HashMap();
    private static HashMap<String, FSSupplier<InputStream>> fontFSSupplierCache = new HashMap();
    private static HashMap<String, byte[]> fontFileCacheIsb = new HashMap();
    private static LinkedHashSet<String> fontNames = new LinkedHashSet();
    private static OpenhttptopdfRendererObjectFactory factory = new OpenhttptopdfRendererObjectFactory();
    private static GenericObjectPool<OpenhttptopdfRenderBuilder> objectPool;
    private static int MinIdle;
    private static int MaxIdle;
    private static int MaxTotal;
    private static String cFontPathDirectory;
    private static long SoftMinEvictableIdleTimeMillis;

    private String readFontPSName(File font) throws IOException, FontFormatException {
        Font f = Font.createFont(0, font);
        return f.getPSName();
    }

    private String readFontName(File font) throws IOException, FontFormatException {
        Font f = Font.createFont(0, font);
        return f.getFontName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws Exception {
        Class<OpenhttptopdfRendererObjectFactory> clazz = OpenhttptopdfRendererObjectFactory.class;
        synchronized (OpenhttptopdfRendererObjectFactory.class) {
            try {
                factory.FontCache();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (FontFormatException e) {
                e.printStackTrace();
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxIdle(MaxIdle);
            poolConfig.setMaxTotal(MaxTotal);
            poolConfig.setMinIdle(MinIdle);
            poolConfig.setSoftMinEvictableIdleTimeMillis(SoftMinEvictableIdleTimeMillis);
            logger.debug("pool param:");
            logger.debug("MaxIdle:" + MaxIdle);
            logger.debug("MaxTotal:" + MaxTotal);
            logger.debug("MinIdle:" + MinIdle);
            objectPool = new GenericObjectPool((PooledObjectFactory)factory, poolConfig);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void init(String customizeFontPathDirectory) throws Exception {
        cFontPathDirectory = customizeFontPathDirectory;
        OpenhttptopdfRendererObjectFactory.init();
    }

    public static void init(int minIdle, int maxIdle, int maxTotal, String customizeFontPathDirectory) throws Exception {
        cFontPathDirectory = customizeFontPathDirectory;
        MinIdle = minIdle;
        MaxIdle = maxIdle;
        MaxTotal = maxTotal;
        OpenhttptopdfRendererObjectFactory.init();
    }

    public static OpenhttptopdfRenderBuilder getPdfRendererBuilderInstance() throws Exception {
        logger.debug("pollActiveNum:" + objectPool.getNumActive());
        return (OpenhttptopdfRenderBuilder)objectPool.borrowObject();
    }

    public static HashMap<String, File> getFontFileCache() throws Exception {
        return OpenhttptopdfRendererObjectFactory.factory.fontFileCache;
    }

    public static HashMap<String, FSSupplier<InputStream>> getFSSupplierCache() throws Exception {
        return fontFSSupplierCache;
    }

    public static void returnPdfBoxRenderer(OpenhttptopdfRenderBuilder openhtpdfRenderObject) throws Exception {
        if (openhtpdfRenderObject != null && openhtpdfRenderObject.isActive()) {
            objectPool.returnObject((Object)openhtpdfRenderObject);
        }
    }

    private void FontCache() throws IOException, FontFormatException {
        URL defaultFontUrl;
        Resource defaultFontResource;
        File cFontsFile;
        byte[] fontByte;
        File fontsLocalDir = null;
        Resource fontsResource = ResourceUtil.getResource((String)"fonts");
        File fontsFile = null;
        URL fontsUrl = null;
        try {
            if (fontsResource.getURL().toString().lastIndexOf(".jar") > 0) {
                fontsUrl = fontsResource.getURL();
            } else {
                fontsFile = fontsResource.getFile();
            }
        }
        catch (FileNotFoundException e) {
            logger.warn("No extend fonts and no load extend fonts resources!");
        }
        if (fontsFile != null && (fontsLocalDir = fontsFile) != null && fontsLocalDir.isDirectory()) {
            File f;
            ArrayList<File> flist = new ArrayList<File>();
            OpenhttptopdfRendererObjectFactory.dirAllFontFiles(fontsLocalDir, flist);
            for (int i = 0; i < flist.size() && (f = (File)flist.get(i)) != null && !f.isDirectory(); ++i) {
                logger.debug("add extend local font =>" + f.getAbsolutePath());
                byte[] fontByte2 = ResourceUtil.getResourceAsByte((String)f.getAbsolutePath()).toByteArray();
                final String fontFileName = f.getName().substring(0, f.getName().indexOf("."));
                fontFileCacheIsb.put(fontFileName, fontByte2);
                fontNames.add(fontFileName);
                fontFSSupplierCache.put(fontFileName, new FSSupplier<InputStream>(){

                    public InputStream supply() {
                        return new ByteArrayInputStream((byte[])fontFileCacheIsb.get(fontFileName));
                    }
                });
            }
        }
        JarURLConnection jarURLConnection = null;
        if (fontsUrl != null) {
            try {
                jarURLConnection = (JarURLConnection)fontsUrl.openConnection();
                if (jarURLConnection == null) {
                    logger.warn("No extend fonts and no load extend fonts resources!");
                    return;
                }
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> jarEntrys = jarFile.entries();
                while (jarEntrys.hasMoreElements()) {
                    JarEntry jarEntry = jarEntrys.nextElement();
                    String jarFileName = jarEntry.getName();
                    if (jarEntry.isDirectory() || ".afm;.pfm;.ttf;.otf;.ttc".indexOf(jarFileName.substring(jarFileName.lastIndexOf(".")).toLowerCase()) < 0) continue;
                    File jarfile = OpenhttptopdfRendererObjectFactory.inputStreamToFile(jarFile.getInputStream(jarEntry), jarFileName.substring(jarFileName.lastIndexOf("/"), jarFileName.lastIndexOf(".")), jarFileName.substring(jarFileName.lastIndexOf(".")));
                    String fontTmpPath = jarfile.getAbsolutePath();
                    logger.debug("extend jar font save to tmpdir => " + fontTmpPath);
                    fontByte = ResourceUtil.getResourceAsByte((String)jarfile.getAbsolutePath()).toByteArray();
                    final String fontName = this.readFontName(jarfile);
                    fontFileCacheIsb.put(fontName, fontByte);
                    fontNames.add(fontName);
                    fontFSSupplierCache.put(fontName, new FSSupplier<InputStream>(){

                        public InputStream supply() {
                            logger.debug("readFontName Requesting font");
                            return new ByteArrayInputStream((byte[])fontFileCacheIsb.get(fontName));
                        }
                    });
                    final String fontPSName = this.readFontPSName(jarfile);
                    fontFileCacheIsb.put(fontPSName, fontByte);
                    fontNames.add(fontPSName.replace(" ", ""));
                    fontFSSupplierCache.put(fontPSName, new FSSupplier<InputStream>(){

                        public InputStream supply() {
                            logger.debug("read font PSName Requesting font");
                            return new ByteArrayInputStream((byte[])fontFileCacheIsb.get(fontPSName));
                        }
                    });
                    jarfile.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        if (StringUtil.isNotBlank((CharSequence)cFontPathDirectory) && (cFontsFile = (defaultFontResource = ResourceUtil.getResource((String)cFontPathDirectory)).getFile()).isDirectory()) {
            File f;
            ArrayList<File> flist = new ArrayList<File>();
            OpenhttptopdfRendererObjectFactory.dirAllFontFiles(cFontsFile, flist);
            for (int i = 0; i < flist.size() && (f = (File)flist.get(i)) != null && !f.isDirectory(); ++i) {
                logger.debug("add extend local font =>" + f.getAbsolutePath());
                byte[] fontByte3 = ResourceUtil.getResourceAsByte((String)f.getAbsolutePath()).toByteArray();
                final String fontFileName = f.getName().substring(0, f.getName().indexOf("."));
                fontFileCacheIsb.put(fontFileName, fontByte3);
                fontNames.add(fontFileName);
                fontFSSupplierCache.put(fontFileName, new FSSupplier<InputStream>(){

                    public InputStream supply() {
                        return new ByteArrayInputStream((byte[])fontFileCacheIsb.get(fontFileName));
                    }
                });
            }
        }
        if ((defaultFontUrl = (defaultFontResource = ResourceUtil.getResource((String)"rayin_default_fonts")).getURL()).getPath().indexOf(".jar!") > 0) {
            try {
                jarURLConnection = (JarURLConnection)defaultFontUrl.openConnection();
                if (jarURLConnection == null) {
                    logger.warn("No default fonts and no load default fonts resources!");
                    return;
                }
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> jarEntrys = jarFile.entries();
                while (jarEntrys.hasMoreElements()) {
                    JarEntry jarEntry = jarEntrys.nextElement();
                    String jarFileName = jarEntry.getName();
                    if (jarEntry.isDirectory() || ".afm;.pfm;.ttf;.otf;.ttc".indexOf(jarFileName.substring(jarFileName.lastIndexOf(".")).toLowerCase()) < 0) continue;
                    File jarfile = OpenhttptopdfRendererObjectFactory.inputStreamToFile(jarFile.getInputStream(jarEntry), jarFileName.substring(jarFileName.lastIndexOf("/"), jarFileName.lastIndexOf(".")), jarFileName.substring(jarFileName.lastIndexOf(".")));
                    String fontTmpPath = jarfile.getAbsolutePath();
                    logger.debug("default font save to tmpdir => " + fontTmpPath);
                    byte[] fontByte4 = ResourceUtil.getResourceAsByte((String)jarfile.getAbsolutePath()).toByteArray();
                    final String fontName = this.readFontName(jarfile);
                    fontFileCacheIsb.put(fontName, fontByte4);
                    fontNames.add(fontName);
                    fontFSSupplierCache.put(fontName, new FSSupplier<InputStream>(){

                        public InputStream supply() {
                            logger.debug("read font name Requesting font");
                            return new ByteArrayInputStream((byte[])fontFileCacheIsb.get(fontName));
                        }
                    });
                    final String fontPSName = this.readFontPSName(jarfile);
                    fontFileCacheIsb.put(fontPSName, fontByte4);
                    fontNames.add(fontPSName.replace(" ", ""));
                    fontFSSupplierCache.put(fontPSName, new FSSupplier<InputStream>(){

                        public InputStream supply() {
                            logger.debug("read font PSName Requesting font");
                            return new ByteArrayInputStream((byte[])fontFileCacheIsb.get(fontPSName));
                        }
                    });
                    jarfile.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        } else {
            File cFontsFile2 = defaultFontResource.getFile();
            if (cFontsFile2.isDirectory()) {
                File f;
                ArrayList<File> flist = new ArrayList<File>();
                OpenhttptopdfRendererObjectFactory.dirAllFontFiles(cFontsFile2, flist);
                for (int i = 0; i < flist.size() && (f = (File)flist.get(i)) != null && !f.isDirectory(); ++i) {
                    logger.debug("add default local font =>" + f.getAbsolutePath());
                    fontByte = ResourceUtil.getResourceAsByte((String)f.getAbsolutePath()).toByteArray();
                    final String fontFileName = f.getName().substring(0, f.getName().indexOf("."));
                    fontFileCacheIsb.put(fontFileName, fontByte);
                    fontNames.add(fontFileName);
                    fontFSSupplierCache.put(fontFileName, new FSSupplier<InputStream>(){

                        public InputStream supply() {
                            return new ByteArrayInputStream((byte[])fontFileCacheIsb.get(fontFileName));
                        }
                    });
                }
            }
        }
        if (fontNames.size() != 0) {
            logger.info("added fonts info\uff1a");
            logger.info("ThreadId:" + Thread.currentThread().getId() + ",added fonts info\uff1a");
            fontNames.forEach(v -> logger.info(v));
        }
    }

    public static HashMap<String, byte[]> getFontCacheInfo() {
        return fontFileCacheIsb;
    }

    public static void appendFontIntoCache(HashMap<String, byte[]> fonts) {
        fonts.forEach((key, value) -> fontFSSupplierCache.put((String)key, new FSSupplier<InputStream>(){

            public InputStream supply() {
                return new ByteArrayInputStream(value);
            }
        }));
    }

    public static File inputStreamToFile(InputStream inputStream, String prefix, String suffix) throws IOException {
        File tmp = File.createTempFile(prefix, suffix);
        FileOutputStream os = new FileOutputStream(tmp);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
            ((OutputStream)os).write(buffer, 0, bytesRead);
        }
        inputStream.close();
        return tmp;
    }

    public static void dirAllFontFiles(File file, List<File> flist) {
        if (file != null && file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lower = name.toLowerCase();
                    return lower.endsWith(".ttf") || lower.endsWith(".ttc") || lower.endsWith(".otf");
                }
            })) {
                if (f.isFile()) {
                    flist.add(f);
                    continue;
                }
                OpenhttptopdfRendererObjectFactory.dirAllFontFiles(f, flist);
            }
        } else {
            flist.add(file);
        }
    }

    public PooledObject<OpenhttptopdfRenderBuilder> makeObject() throws IOException {
        String i = UUID.randomUUID().toString();
        logger.debug("make OpenhttptopdfRender object\uff1a" + i);
        FSDefaultCacheStore fsCacheEx = new FSDefaultCacheStore();
        OpenhttptopdfRenderBuilder openhttptopdfRenderBuilder = new OpenhttptopdfRenderBuilder();
        PdfRendererBuilder builder = new PdfRendererBuilder();
        builder.useUnicodeBidiSplitter((BidiSplitterFactory)new ICUBidiSplitter.ICUBidiSplitterFactory());
        builder.useUnicodeBidiReorderer((BidiReorderer)new ICUBidiReorderer());
        builder.defaultTextDirection(BaseRendererBuilder.TextDirection.LTR);
        builder.useSVGDrawer((SVGDrawer)new BatikSVGDrawer());
        builder.useMathMLDrawer((SVGDrawer)new MathMLDrawer());
        builder.addDOMMutator((FSDOMMutator)LaTeXDOMMutator.INSTANCE);
        builder.defaultTextDirection(BaseRendererBuilder.TextDirection.LTR);
        builder.useCacheStore(PdfRendererBuilder.CacheStore.PDF_FONT_METRICS, (FSCacheEx)fsCacheEx);
        fontFSSupplierCache.forEach((key, value) -> builder.useFont(value, key, Integer.valueOf(500), BaseRendererBuilder.FontStyle.NORMAL, true));
        builder.useFastMode();
        XRLog.setLoggingEnabled((boolean)false);
        DefaultObjectDrawerFactory factory = new DefaultObjectDrawerFactory();
        factory.registerDrawer("image/barcode", (FSObjectDrawer)new ZXingObjectDrawer());
        factory.registerDrawer("jfreechart/pie", (FSObjectDrawer)new JFreeChartPieDiagramObjectDrawer());
        factory.registerDrawer("jfreechart/bar", (FSObjectDrawer)new JFreeChartBarDiagramObjectDrawer());
        builder.useObjectDrawerFactory((FSObjectDrawerFactory)factory);
        openhttptopdfRenderBuilder.setPdfRendererBuilder(builder);
        return new DefaultPooledObject((Object)openhttptopdfRenderBuilder);
    }

    public void destroyObject(PooledObject<OpenhttptopdfRenderBuilder> pooledObject) throws Exception {
        ((OpenhttptopdfRenderBuilder)pooledObject.getObject()).setActive(false);
    }

    public boolean validateObject(PooledObject<OpenhttptopdfRenderBuilder> pooledObject) {
        return ((OpenhttptopdfRenderBuilder)pooledObject.getObject()).isActive();
    }

    public void activateObject(PooledObject<OpenhttptopdfRenderBuilder> pooledObject) throws Exception {
        ((OpenhttptopdfRenderBuilder)pooledObject.getObject()).setActive(true);
    }

    public void passivateObject(PooledObject<OpenhttptopdfRenderBuilder> pooledObject) throws Exception {
    }

    public static LinkedHashSet<String> getFontNames() {
        return fontNames;
    }

    static {
        MinIdle = 5;
        MaxIdle = 8;
        MaxTotal = 10;
        SoftMinEvictableIdleTimeMillis = 30000L;
    }
}

