/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.openhtmltopdf.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.zxing.WriterException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import ink.rayin.htmladapter.base.PdfGenerator;
import ink.rayin.htmladapter.base.model.tplconfig.MarkInfo;
import ink.rayin.htmladapter.base.model.tplconfig.PageNumDisplayPos;
import ink.rayin.htmladapter.base.model.tplconfig.RayinMeta;
import ink.rayin.htmladapter.base.model.tplconfig.TemplateConfig;
import ink.rayin.htmladapter.base.thymeleaf.ThymeleafHandler;
import ink.rayin.htmladapter.base.utils.JsonSchemaValidator;
import ink.rayin.htmladapter.base.utils.RayinException;
import ink.rayin.htmladapter.openhtmltopdf.factory.OpenhttptopdfRenderBuilder;
import ink.rayin.htmladapter.openhtmltopdf.factory.OpenhttptopdfRendererObjectFactory;
import ink.rayin.htmladapter.openhtmltopdf.utils.PdfBoxPositionFindByKey;
import ink.rayin.tools.utils.DisplayMeasureConvert;
import ink.rayin.tools.utils.EasyExcelUtils;
import ink.rayin.tools.utils.FileUtil;
import ink.rayin.tools.utils.ResourceUtil;
import ink.rayin.tools.utils.StringUtil;
import ink.rayin.tools.utils.UnicodeUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardSecurityHandler;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class PdfBoxGenerator
implements PdfGenerator {
    private static Logger logger = LoggerFactory.getLogger(PdfBoxGenerator.class);
    private ThymeleafHandler thymeleafHandler = ThymeleafHandler.getInstance();
    private final String jsonSchema = "tpl_schema.json";
    private static JsonNode jsonSchemaNode;
    Pattern pattern = Pattern.compile("\\d+");

    public PdfBoxGenerator() throws IOException {
        jsonSchemaNode = JsonSchemaValidator.getJsonNodeFromInputStream((InputStream)ResourceUtil.getResourceAsStream((String)"tpl_schema.json"));
        if (jsonSchemaNode == null) {
            new RayinException("json\u6821\u9a8c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    public void init() throws Exception {
        OpenhttptopdfRendererObjectFactory.init();
    }

    public void init(String customizeFontPathDirectory) throws Exception {
        OpenhttptopdfRendererObjectFactory.init(customizeFontPathDirectory);
    }

    public void init(int minIdle, int maxIdle, int maxTotal, String customizeFontPathDirectory) throws Exception {
        OpenhttptopdfRendererObjectFactory.init(minIdle, maxIdle, maxTotal, customizeFontPathDirectory);
    }

    public RayinMeta generatePdfFileByTplConfigFile(String templateLocation, JSONObject jsonData, String outputFilePath) throws Exception {
        return this.generatePdfFileByTplConfigStr(ResourceUtil.getResourceAsString((String)templateLocation, (Charset)StandardCharsets.UTF_8), jsonData, outputFilePath);
    }

    public RayinMeta generatePdfFileByTplConfigStr(String tplConfigStr, JSONObject jsonData, String outputFilePath) throws Exception {
        JsonNode tplConfigJsonDataNode = JsonSchemaValidator.getJsonNodeFromString((String)tplConfigStr);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String tplConfigJsonStr = tplConfigJsonDataNode.toString();
        RayinMeta fileInfo = this.generatePdfStreamByTplConfigStr(tplConfigJsonStr, jsonData, bos);
        TemplateConfig pagesConfig = (TemplateConfig)JSONObject.parseObject((String)tplConfigJsonStr, TemplateConfig.class);
        this.writePDFAttrs(bos, fileInfo, pagesConfig);
        File file = new File(outputFilePath);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        file.createNewFile();
        FileOutputStream fos = new FileOutputStream(outputFilePath);
        try {
            fos.write(bos.toByteArray());
            fos.flush();
            fos.close();
            bos.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("fos close error", (Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileInfo;
    }

    public RayinMeta generateEncryptPdfStreamByConfigStr(String tplConfigStr, JSONObject jsonData, ByteArrayOutputStream os, String password) throws Exception {
        RayinMeta fileInfo = this.generatePdfStreamByTplConfigStr(tplConfigStr, jsonData, os);
        TemplateConfig pagesConfig = (TemplateConfig)JSONObject.parseObject((String)tplConfigStr, TemplateConfig.class);
        if (StringUtil.isNotBlank((CharSequence)password)) {
            fileInfo.setSecretKey(password);
        }
        this.writePDFAttrs(os, fileInfo, pagesConfig);
        return fileInfo;
    }

    public RayinMeta generatePdfStreamByTplConfigStr(String tplConfigStr, JSONObject dataJson, ByteArrayOutputStream os) throws Exception {
        JsonNode tplConfigJsonDataNode = JsonSchemaValidator.getJsonNodeFromString((String)tplConfigStr);
        if (tplConfigJsonDataNode == null) {
            new RayinException("json\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        JsonSchemaValidator.validateJsonByFgeByJsonNode((JsonNode)tplConfigJsonDataNode, (JsonNode)jsonSchemaNode);
        TemplateConfig templateConfig = (TemplateConfig)JSONObject.parseObject((String)tplConfigStr, TemplateConfig.class);
        List pages = templateConfig.getElements();
        List templatePageNumDisplayPos = null;
        if (templateConfig.getPageNumDisplayPoss() != null && templateConfig.getPageNumDisplayPoss().size() > 0) {
            templatePageNumDisplayPos = templateConfig.getPageNumDisplayPoss();
        }
        ArrayList<ByteArrayOutputStream> out = new ArrayList<ByteArrayOutputStream>();
        ArrayList<ink.rayin.htmladapter.base.model.tplconfig.Element> pageProperties = new ArrayList<ink.rayin.htmladapter.base.model.tplconfig.Element>();
        for (ink.rayin.htmladapter.base.model.tplconfig.Element el : pages) {
            ByteArrayOutputStream tmp;
            block20: {
                try {
                    if (!StringUtil.isNotBlank((CharSequence)el.getElementAvaliableDataPath())) break block20;
                    JsonPath.read((Object)dataJson, (String)el.getElementAvaliableDataPath(), (Predicate[])new Predicate[0]);
                }
                catch (PathNotFoundException e) {
                    el.setPageNum(-1);
                    continue;
                }
            }
            if ((tmp = this.generatePdfSteamByHtmlFileAndData(templateConfig, el, dataJson, pageProperties)) == null) continue;
            out.add(tmp);
        }
        int pageNum = 1;
        int pageNumTotal = 0;
        int i = 0;
        String footerStr = "";
        for (ink.rayin.htmladapter.base.model.tplconfig.Element pp : pageProperties) {
            if (!pp.isPageNumIsCalculate()) continue;
            pageNumTotal += pp.getPageCount();
        }
        for (ink.rayin.htmladapter.base.model.tplconfig.Element pp : pageProperties) {
            if (pp != null) {
                if (pp.isPageNumIsFirstPage()) {
                    pageNum = 1;
                }
                if (pp.isPageNumIsCalculate()) {
                    if (pp.isPageNumIsDisplay()) {
                        PDPage content;
                        footerStr = "\u7b2c" + pageNum + "\u9875\uff0c\u5171" + pageNumTotal + "\u9875";
                        pp.setLogicPageNum(pageNum);
                        PDDocument doc = PDDocument.load((byte[])((ByteArrayOutputStream)out.get(i)).toByteArray());
                        int elPageNum = doc.getNumberOfPages();
                        for (int j = 0; j < elPageNum && (content = doc.getPage(j)) != null; ++j) {
                            float overContentHeight = content.getMediaBox().getHeight();
                            if (pp.getPageNumDisplayPoss() != null && pp.getPageNumDisplayPoss().size() > 0) {
                                for (PageNumDisplayPos pos : pp.getPageNumDisplayPoss()) {
                                    List<float[]> fl;
                                    String pageNumContent = footerStr;
                                    if (StringUtil.isNotBlank((CharSequence)pos.getContent())) {
                                        pageNumContent = pos.getContent().replace("${pageNum}", pageNum + "").replace("${pageNumTotal}", pageNumTotal + "");
                                    }
                                    PDPageContentStream contentStreamEl = new PDPageContentStream(doc, content, PDPageContentStream.AppendMode.PREPEND, false);
                                    contentStreamEl.beginText();
                                    contentStreamEl.newLineAtOffset(pos.getX() == 0.0f ? content.getMediaBox().getWidth() / 2.0f - 30.0f : pos.getX(), pos.getY() != 0.0f ? overContentHeight - pos.getY() : 20.0f);
                                    contentStreamEl.setFont((PDFont)PDType0Font.load((PDDocument)doc, (InputStream)((InputStream)OpenhttptopdfRendererObjectFactory.getFSSupplierCache().get(StringUtil.isNotBlank((CharSequence)pos.getFontFamily()) ? pos.getFontFamily() : "FangSong").supply())), pos.getFontSize() != 0 ? (float)pos.getFontSize() : 10.0f);
                                    contentStreamEl.showText(pageNumContent);
                                    contentStreamEl.endText();
                                    contentStreamEl.close();
                                    if (!StringUtil.isNotBlank((CharSequence)pos.getMark()) || (fl = PdfBoxPositionFindByKey.findKeywordPagePostions(((ByteArrayOutputStream)out.get(i)).toByteArray(), pos.getMark(), j)).size() <= 0) continue;
                                    PDPageContentStream contentStream = new PDPageContentStream(doc, content, PDPageContentStream.AppendMode.PREPEND, false);
                                    contentStream.beginText();
                                    for (float[] f : fl) {
                                        contentStream.newLineAtOffset(f[0], f[1]);
                                    }
                                    contentStream.setFont((PDFont)PDType0Font.load((PDDocument)doc, (InputStream)((InputStream)OpenhttptopdfRendererObjectFactory.getFSSupplierCache().get("FangSong").supply())), 10.0f);
                                    contentStream.showText(footerStr);
                                    contentStream.endText();
                                    contentStream.close();
                                }
                            } else {
                                PDPageContentStream contentStream = new PDPageContentStream(doc, content, PDPageContentStream.AppendMode.PREPEND, false);
                                contentStream.beginText();
                                contentStream.newLineAtOffset(content.getMediaBox().getWidth() / 2.0f - 30.0f, 20.0f);
                                contentStream.setFont((PDFont)PDType0Font.load((PDDocument)doc, (InputStream)((InputStream)OpenhttptopdfRendererObjectFactory.getFSSupplierCache().get("FangSong").supply())), 10.0f);
                                contentStream.showText(footerStr);
                                contentStream.endText();
                                contentStream.close();
                            }
                            footerStr = "\u7b2c" + ++pageNum + "\u9875\uff0c\u5171" + pageNumTotal + "\u9875";
                        }
                        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
                        doc.save((OutputStream)out2);
                        doc.close();
                        out.set(i, out2);
                    } else {
                        ++pageNum;
                    }
                }
            }
            ++i;
        }
        ArrayList<ink.rayin.htmladapter.base.model.tplconfig.Element> rp = new ArrayList<ink.rayin.htmladapter.base.model.tplconfig.Element>(50);
        ArrayList signInfo = new ArrayList(50);
        RayinMeta efi = this.writeTargetFile(os, this.mergePDF(out).toByteArray());
        int calPageNum = 1;
        for (ink.rayin.htmladapter.base.model.tplconfig.Element page : pages) {
            ink.rayin.htmladapter.base.model.tplconfig.Element pa = new ink.rayin.htmladapter.base.model.tplconfig.Element();
            pa.setPageCount(page.getPageCount());
            pa.setPageNum(calPageNum);
            pa.setLogicPageNum(page.getLogicPageNum());
            pa.setElementType(page.getElementType());
            pa.setAddBlankPage(page.isAddBlankPage());
            pa.setPageNumIsCalculate(page.isPageNumIsCalculate());
            pa.setPageNumIsDisplay(page.isPageNumIsDisplay());
            pa.setPageNumIsFirstPage(page.isPageNumIsFirstPage());
            if (page.getMarkKeys() != null && page.getMarkKeys().size() > 0) {
                page.getMarkKeys().forEach(s -> {
                    try {
                        List<float[]> fl = PdfBoxPositionFindByKey.findKeywordPagesPostions(os.toByteArray(), s.getKeyword());
                        fl.forEach(f -> {
                            MarkInfo mi = new MarkInfo();
                            mi.setKeyword(s.getKeyword());
                            mi.setPageNum((int)f[0]);
                            mi.setX(f[1]);
                            mi.setY(f[2]);
                            mi.setWidth(s.getWidth());
                            mi.setHeight(s.getHeight());
                            signInfo.add(mi);
                        });
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            rp.add(pa);
            calPageNum += page.getPageCount();
        }
        efi.setPagesInfo(rp);
        efi.setMarkInfos(signInfo);
        return efi;
    }

    public boolean generatePdfFileByHtmlAndData(String htmlLocation, JSONObject jsonObject, String outputFilePath) throws Exception {
        this.generatePdfFileByHtmlStr(ResourceUtil.getResourceAsString((String)htmlLocation, (Charset)StandardCharsets.UTF_8), jsonObject, outputFilePath);
        return true;
    }

    public ByteArrayOutputStream generatePdfSteamByHtmlStrAndData(String htmlStr, JSONObject jsonData) throws Exception {
        String htmlContent = this.htmlStrDataFilling(htmlStr, jsonData);
        return this.generatePdfStreamByHtmlStr(htmlContent);
    }

    private ByteArrayOutputStream generatePdfSteamByHtmlFileAndData(TemplateConfig pagesConfig, ink.rayin.htmladapter.base.model.tplconfig.Element config, JSONObject data, List<ink.rayin.htmladapter.base.model.tplconfig.Element> pp) throws Exception {
        String htmlContent = "";
        if (StringUtil.isNotBlank((CharSequence)config.getContent())) {
            htmlContent = this.htmlStrDataFilling(config.getContent(), data);
        }
        if (StringUtil.isNotBlank((CharSequence)config.getElementPath())) {
            htmlContent = this.htmlFileDataFilling(config.getElementPath(), data);
        }
        HashSet<MarkInfo> signature = new HashSet<MarkInfo>();
        ByteArrayOutputStream bo = this.generatePdfStreamByHtmlStr(htmlContent, signature);
        config.setMarkKeys(signature);
        if (bo == null) {
            return null;
        }
        PDDocument pdfDoc = PDDocument.load((byte[])bo.toByteArray());
        int pageNum = 0;
        if (bo != null) {
            pageNum = pdfDoc.getNumberOfPages();
            if (config.isAddBlankPage() && pageNum % 2 == 1) {
                ByteArrayOutputStream blankOS = StringUtil.isNotBlank((CharSequence)config.getBlankElementPath()) ? this.generatePdfSteamByHtmlFileAndData(config.getBlankElementPath(), data) : (StringUtil.isNotBlank((CharSequence)pagesConfig.getBlankElementPath()) ? this.generatePdfSteamByHtmlFileAndData(pagesConfig.getBlankElementPath(), data) : this.generatePdfSteamByHtmlStrAndData(ResourceUtil.getResourceAsString((String)"blank.html", (Charset)StandardCharsets.UTF_8), data));
                ArrayList<ByteArrayOutputStream> clByte = new ArrayList<ByteArrayOutputStream>();
                ByteArrayOutputStream blankByte = blankOS;
                clByte.add(bo);
                clByte.add(blankByte);
                bo = this.mergePDF(clByte);
                ++pageNum;
            }
            config.setPageCount(pageNum);
        }
        pp.add(config);
        pdfDoc.close();
        return bo;
    }

    public String htmlFileDataFilling(String htmlLocation, JSONObject data) throws IOException, WriterException {
        String htmlContent = "";
        htmlContent = this.thymeleafHandler.templateEngineProcessByPath(htmlLocation, data);
        return htmlContent;
    }

    public String htmlStrDataFilling(String htmlStr, JSONObject data) throws IOException, WriterException {
        String htmlContent = "";
        if (StringUtil.isBlank((CharSequence)htmlStr)) {
            return "";
        }
        htmlContent = this.thymeleafHandler.templateEngineProcessByString(htmlStr, data);
        return htmlContent;
    }

    public void generatePdfFileByHtmlStr(String htmlStr, String outputFile) throws Exception {
        File f = new File(outputFile);
        if (f != null && !f.getParentFile().exists()) {
            f.getParentFile().mkdir();
        }
        FileUtils.writeByteArrayToFile((File)new File(outputFile), (byte[])this.generatePdfStreamByHtmlStr(htmlStr).toByteArray());
    }

    public void generatePdfFileByHtmlStr(String htmlStr, JSONObject data, String outputFile) throws Exception {
        this.generatePdfFileByHtmlStr(this.htmlStrDataFilling(htmlStr, data), outputFile);
    }

    public ByteArrayOutputStream generatePdfStreamByHtmlStr(String htmlContent) throws Exception {
        return this.generatePdfStreamByHtmlStr(htmlContent, null);
    }

    private ByteArrayOutputStream generatePdfStreamByHtmlStr(String htmlContent, Set<MarkInfo> markKeys) throws Exception {
        ArrayList apendFiles = new ArrayList();
        Document htmlDoc = Jsoup.parse((String)htmlContent);
        Elements imgLinks = htmlDoc.getElementsByTag("img");
        for (Object link : imgLinks) {
            String src = link.attr("src");
            if (!StringUtil.isNotBlank((CharSequence)src) || !src.startsWith("/") && !src.startsWith("\\")) continue;
            link.attr("src", "file:" + src);
        }
        Elements objectLinks = htmlDoc.getElementsByTag("object");
        for (Element link : objectLinks) {
            String inner = link.text();
            String type = link.attr("type");
            String value = link.attr("value");
            String pages = link.attr("page");
            String style = link.attr("style");
            String[] styles = style.split(";");
            if (StringUtil.isNotBlank((CharSequence)type) && StringUtil.isNotBlank((CharSequence)value)) {
                float width = 0.0f;
                float height = 0.0f;
                switch (type) {
                    case "file/pdf": {
                        if (StringUtil.isBlank((CharSequence)value)) break;
                        Element p = link.parent();
                        link.remove();
                        Element pp = p.parent();
                        Element box = p;
                        if (StringUtil.isBlank((CharSequence)p.html().replaceAll("[\n &nbsp;]", ""))) {
                            p.remove();
                            box = pp;
                        }
                        ByteArrayOutputStream pdfOs = null;
                        try {
                            pdfOs = ResourceUtil.getResourceAsByte((String)value);
                        }
                        catch (FileNotFoundException fe) {
                            throw new RayinException("\u65e0\u6cd5\u627e\u5230\u6587\u4ef6\uff1a" + fe.getMessage());
                        }
                        PDDocument doc = PDDocument.load((byte[])pdfOs.toByteArray());
                        int elPageNum = doc.getNumberOfPages();
                        if (!(value.startsWith("http://") || value.startsWith("https://") || value.startsWith("file:"))) {
                            value = value.startsWith("/") || value.startsWith("\\") ? "file:" + value : "file:" + ResourceUtil.getResourceAbsolutePathByClassPath((String)value);
                        }
                        if (StringUtil.isNotBlank((CharSequence)pages)) {
                            String[] pageB;
                            String[] stringArray = pageB = pages.split(",");
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String k = stringArray[i];
                                box.append("<img width=\"100%\" src=\"" + value + "\" page=\"" + k + "\"/>\n");
                            }
                        } else {
                            for (int i = 1; i <= elPageNum; ++i) {
                                box.append("<img width=\"100%\" src=\"" + value + "\" page=\"" + i + "\"/>\n");
                            }
                        }
                        doc.close();
                        pdfOs.close();
                        break;
                    }
                    case "mark": {
                        if (markKeys != null) {
                            for (String st : styles) {
                                if (st.indexOf("width:") >= 0) {
                                    width = DisplayMeasureConvert.webMeasureToPDFPoint((String)st.toLowerCase().replace("width:", ""));
                                    continue;
                                }
                                if (st.indexOf("height:") < 0) continue;
                                height = DisplayMeasureConvert.webMeasureToPDFPoint((String)st.toLowerCase().replace("height:", ""));
                            }
                            MarkInfo markInfo = new MarkInfo();
                            markInfo.setKeyword(value);
                            markInfo.setWidth(width);
                            markInfo.setHeight(height);
                            markKeys.add(markInfo);
                        }
                        link.attr("style", StringUtil.isBlank((CharSequence)link.attr("style")) ? "" : "margin:" + width / 2.0f + "pt;color:white;display:inline;font-size:0.1px;border:0;" + link.attr("style") + ";");
                        link.append(value);
                    }
                }
            }
        }
        OpenhttptopdfRenderBuilder openhttptopdfRenderBuilder = null;
        PdfRendererBuilder pdfRendererBuilder = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            openhttptopdfRenderBuilder = OpenhttptopdfRendererObjectFactory.getPdfRendererBuilderInstance();
            pdfRendererBuilder = openhttptopdfRenderBuilder.getPdfRendererBuilder();
            try {
                W3CDom w3cDom = new W3CDom();
                org.w3c.dom.Document w3cDoc = w3cDom.fromJsoup(htmlDoc);
                pdfRendererBuilder.withW3cDocument(w3cDoc, "/");
                pdfRendererBuilder.toStream((OutputStream)out);
                pdfRendererBuilder.run();
            }
            catch (Exception e) {
                logger.error(htmlDoc.toString());
                throw e;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            OpenhttptopdfRendererObjectFactory.returnPdfBoxRenderer(openhttptopdfRenderBuilder);
        }
        PDDocument pdDoc = PDDocument.load((byte[])out.toByteArray());
        PDDocumentInformation pdInfo = pdDoc.getDocumentInformation();
        pdInfo.setProducer(UnicodeUtil.decode((String)"\\u0040\\u004d\\u0041\\u0044\\u0045\\u0020\\u0042\\u0059\\u0020\\u0052\\u0041\\u0059\\u0049\\u004e"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pdDoc.save((OutputStream)baos);
        pdDoc.close();
        return baos;
    }

    private static String toStringFromDoc(org.w3c.dom.Document document) {
        String result = null;
        if (document != null) {
            StringWriter strWtr = new StringWriter();
            StreamResult strResult = new StreamResult(strWtr);
            TransformerFactory tfac = TransformerFactory.newInstance();
            try {
                Transformer t = tfac.newTransformer();
                t.setOutputProperty("encoding", "UTF-8");
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("method", "xml");
                t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                t.transform(new DOMSource(document.getDocumentElement()), strResult);
            }
            catch (Exception e) {
                System.err.println("XML.toString(Document): " + e);
            }
            result = strResult.getWriter().toString();
            try {
                strWtr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private ByteArrayOutputStream mergePDF(List<ByteArrayOutputStream> pdfs) throws Exception {
        if (pdfs == null || pdfs.isEmpty()) {
            return null;
        }
        if (pdfs.size() == 1) {
            return pdfs.get(0);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrayList<ByteArrayInputStream> pdfIs = new ArrayList<ByteArrayInputStream>();
        for (ByteArrayOutputStream os : pdfs) {
            pdfIs.add(new ByteArrayInputStream(os.toByteArray()));
        }
        PDFMergerUtility mergePdf = new PDFMergerUtility();
        mergePdf.addSources(pdfIs);
        mergePdf.setDestinationStream((OutputStream)out);
        mergePdf.mergeDocuments(MemoryUsageSetting.setupMixed((long)1000000L));
        return out;
    }

    public RayinMeta writeTargetFileByByte(String targetFile, byte[] outByte) throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        RayinMeta fileInfo = this.writeTargetFile(out1, outByte);
        File file = new File(targetFile);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        file.createNewFile();
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            fos.write(out1.toByteArray());
            fos.flush();
            fos.close();
        }
        fileInfo.setFilePath(targetFile);
        return fileInfo;
    }

    private RayinMeta writeTargetFile(ByteArrayOutputStream os, byte[] outByte) throws Exception {
        PDDocument doc = PDDocument.load((byte[])outByte);
        doc.save((OutputStream)os);
        doc.close();
        RayinMeta rayinMetadata = new RayinMeta();
        int pages = doc.getNumberOfPages();
        rayinMetadata.setFileTotalPageCount(pages);
        return rayinMetadata;
    }

    private void writePDFAttrs(ByteArrayOutputStream os, RayinMeta epfileInfo, TemplateConfig pagesConfig) throws Exception {
        ByteArrayOutputStream osCopy = new ByteArrayOutputStream();
        IOUtils.write((byte[])os.toByteArray(), (OutputStream)osCopy);
        PDDocument doc = PDDocument.load((byte[])osCopy.toByteArray());
        PDDocumentInformation info = doc.getDocumentInformation();
        if (!pagesConfig.isEditable() || StringUtil.isNotBlank((CharSequence)pagesConfig.getPassword())) {
            AccessPermission permissions = new AccessPermission();
            permissions.setCanModify(pagesConfig.isEditable());
            permissions.setCanExtractContent(pagesConfig.isEditable());
            StandardProtectionPolicy standardProtectionPolicy = new StandardProtectionPolicy(pagesConfig.getPassword(), pagesConfig.getPassword(), permissions);
            StandardSecurityHandler securityHandler = new StandardSecurityHandler(standardProtectionPolicy);
            securityHandler.prepareDocumentForEncryption(doc);
            PDEncryption encryption = new PDEncryption();
            encryption.setSecurityHandler((SecurityHandler)securityHandler);
            doc.setEncryptionDictionary(encryption);
        }
        info.setAuthor(pagesConfig.getAuthor());
        info.setTitle(pagesConfig.getTitle());
        info.setSubject(pagesConfig.getSubject());
        info.setKeywords(pagesConfig.getKeywords());
        info.setProducer(UnicodeUtil.decode((String)"\\u0040\\u004d\\u0041\\u0044\\u0045\\u0020\\u0042\\u0059\\u0020\\u0052\\u0041\\u0059\\u0049\\u004e"));
        info.setCreator(pagesConfig.getCreator());
        Base64.Encoder encoder = Base64.getEncoder();
        logger.info(JSONObject.toJSONString((Object)epfileInfo));
        info.setCustomMetadataValue("PagesInfo", encoder.encodeToString(JSONObject.toJSONString((Object)epfileInfo).getBytes()));
        os.reset();
        doc.save((OutputStream)os);
        doc.close();
    }

    public HashMap<String, String> pdfAttrsRead(InputStream fis) throws IOException, ParserConfigurationException, SAXException {
        PDDocument document = PDDocument.load((InputStream)fis);
        PDDocumentInformation info = document.getDocumentInformation();
        HashMap<String, String> pdfMeta = new HashMap<String, String>();
        pdfMeta.put("Author", info.getAuthor());
        pdfMeta.put("Creator", info.getCreator());
        pdfMeta.put("Keywords", info.getKeywords());
        pdfMeta.put("Producer", info.getProducer());
        pdfMeta.put("Subject", info.getSubject());
        pdfMeta.put("Title", info.getTitle());
        pdfMeta.put("PagesInfo", info.getCustomMetadataValue("PagesInfo"));
        document.close();
        return pdfMeta;
    }

    public String pdfPageInfoRead(InputStream fis) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, String> pra = this.pdfAttrsRead(fis);
        Base64.Decoder decoder = Base64.getDecoder();
        String pagesInfo = pra.get("PagesInfo");
        if (pagesInfo == null) {
            return null;
        }
        return new String(decoder.decode(pagesInfo.toString()), "UTF-8");
    }

    public ByteArrayOutputStream generatePdfSteamByHtmlFileAndData(String templatePath, JSONObject jsonData) throws Exception {
        String htmlContent = this.htmlFileDataFilling(templatePath, jsonData);
        return this.generatePdfStreamByHtmlStr(htmlContent);
    }

    private String HTMLTrim(String html) {
        Document htmlDoc = Jsoup.parse((String)html);
        List ln = ((Element)htmlDoc.getElementsByTag("body").get(0)).childNodes();
        for (Node n : ln) {
            this.NodeTrim(n);
        }
        StringBuffer sb = new StringBuffer(html.length() + 1);
        for (Node n : ln) {
            sb.append(n);
        }
        return sb.toString();
    }

    private void NodeTrim(Node n) {
        if (n.childNodeSize() == 0) {
            if (n instanceof Element || n instanceof Comment) {
                return;
            }
            ((TextNode)n).text(n.toString().replaceAll("(\r|\n|\\s+)", ""));
        } else {
            for (Node nc : n.childNodes()) {
                this.NodeTrim(nc);
            }
        }
    }

    private String SubStringIgnoreHtml(String html, int beginIndex, int endIndex) {
        Document htmlDoc = Jsoup.parse((String)html);
        List ln = ((Element)htmlDoc.getElementsByTag("body").get(0)).childNodes();
        ArrayList<Node> bn = new ArrayList<Node>();
        int offset = 0;
        for (Node n : ln) {
            if (offset > endIndex || offset == -1) break;
            if ((offset = this.calText(n, offset, beginIndex, endIndex)) > beginIndex && offset != -1 && offset < endIndex) {
                bn.add(n);
            }
            if (offset != endIndex) continue;
            bn.add(n);
            break;
        }
        StringBuffer sb = new StringBuffer(endIndex - beginIndex + 1);
        for (Node n : bn) {
            sb.append(n);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        String html = "<br><br>html\u6587\u672c\u6d4b\u8bd5\u5e26\u6807\u7b7e\u7684\u503c\uff0c<b>\u4f5b\u6321\u6740\u4f5b</b><br>fdsf,f\u5bf9\u65b9\u8eab\u4efd\u7684<br><br><br>433ffdsfds";
        PdfBoxGenerator pbts = new PdfBoxGenerator();
        boolean offset = false;
        pbts.SubStringIgnoreHtml(html, 0, 5);
        pbts.SubStringIgnoreHtml(html, 5, 10);
        pbts.SubStringIgnoreHtml(html, 10, 50);
    }

    private int calText(Node n, int offset, int beginIndex, int endIndex) {
        if (n.childNodeSize() == 0) {
            if (n instanceof Element || n instanceof Comment) {
                return offset;
            }
            String tmp = n.toString().replaceAll("(\r|\n|\\s+)", "");
            int nodelen = tmp.length();
            if (offset + nodelen < beginIndex) {
                return offset += nodelen;
            }
            if (offset + nodelen == beginIndex) {
                return offset += nodelen;
            }
            if (offset + nodelen > beginIndex && offset + nodelen < endIndex) {
                if (offset < beginIndex && n instanceof TextNode) {
                    ((TextNode)n).text(tmp.substring(beginIndex - offset, nodelen));
                } else if (n instanceof TextNode) {
                    ((TextNode)n).text(tmp);
                }
                return offset += nodelen;
            }
            if (offset + nodelen >= endIndex && offset < endIndex) {
                if (offset == endIndex) {
                    return -1;
                }
                if (n instanceof TextNode) {
                    ((TextNode)n).text(tmp.substring(0, endIndex - offset));
                }
                offset = endIndex;
                return offset;
            }
        } else {
            List ln = n.childNodes();
            for (int i = 0; i < ln.size(); ++i) {
                if (offset != endIndex && offset != -1) {
                    offset = this.calText((Node)ln.get(i), offset, beginIndex, endIndex);
                }
                if (offset <= beginIndex && offset != -1) {
                    ((Node)ln.get(i)).remove();
                    --i;
                    continue;
                }
                if (offset != endIndex && offset != -1 || i + 1 >= ln.size()) continue;
                ((Node)ln.get(i + 1)).remove();
                --i;
            }
            return offset;
        }
        return offset;
    }

    public String getNumbers(String content) {
        Matcher matcher = this.pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    public LinkedHashSet<String> getFontNames() {
        return OpenhttptopdfRendererObjectFactory.getFontNames();
    }

    public void generatePdfFilesByTplAndExcel(String tplConfigStr, InputStream excelIs, String outputDirPath, String fileNamePrefix) throws Exception {
        JSONArray ja = JSONObject.parseArray((String)EasyExcelUtils.readWithoutHead((InputStream)excelIs));
        for (int i = 0; i < ja.size(); ++i) {
            this.generatePdfFileByTplConfigStr(tplConfigStr, ja.getJSONObject(i), outputDirPath + File.separator + fileNamePrefix + "_" + (i + 1) + ".pdf");
        }
    }

    public void generatePdfFileByTplAndExcel(String tplConfigStr, InputStream excelIs, String outputFilePath) throws Exception {
        JSONArray ja = JSONObject.parseArray((String)EasyExcelUtils.readWithoutHead((InputStream)excelIs));
        ArrayList<ByteArrayOutputStream> bosl = new ArrayList<ByteArrayOutputStream>();
        for (int i = 0; i < ja.size(); ++i) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.generatePdfStreamByTplConfigStr(tplConfigStr, ja.getJSONObject(i), os);
            bosl.add(os);
        }
        ByteArrayOutputStream out = this.mergePDF(bosl);
        FileUtil.toFile((InputStream)new ByteArrayInputStream(out.toByteArray()), (File)new File(outputFilePath));
    }

    public void generatePdfFilesByEleAndExcel(String elementStr, InputStream excelIs, String outputDirPath, String fileNamePrefix) throws Exception {
        JSONArray ja = JSONObject.parseArray((String)EasyExcelUtils.readWithoutHead((InputStream)excelIs));
        for (int i = 0; i < ja.size(); ++i) {
            this.generatePdfFileByHtmlStr(elementStr, ja.getJSONObject(i), outputDirPath + File.separator + fileNamePrefix + "_" + (i + 1) + ".pdf");
        }
    }

    public void generatePdfFileByEleAndExcel(String elementStr, InputStream excelIs, String outputFilePath) throws Exception {
        JSONArray ja = JSONObject.parseArray((String)EasyExcelUtils.readWithoutHead((InputStream)excelIs));
        ArrayList<ByteArrayOutputStream> bosl = new ArrayList<ByteArrayOutputStream>();
        for (int i = 0; i < ja.size(); ++i) {
            bosl.add(this.generatePdfSteamByHtmlStrAndData(elementStr, ja.getJSONObject(i)));
        }
        ByteArrayOutputStream out = this.mergePDF(bosl);
        FileUtil.toFile((InputStream)new ByteArrayInputStream(out.toByteArray()), (File)new File(outputFilePath));
    }
}

