/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.openhtmltopdf.service;

import ink.rayin.htmladapter.base.Signature;
import ink.rayin.htmladapter.base.model.tplconfig.SignatureProperty;
import ink.rayin.htmladapter.openhtmltopdf.signature.CreateVisibleSignature;
import ink.rayin.tools.utils.ResourceUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.springframework.util.Base64Utils;

public class PdfBoxSignature
implements Signature {
    public void multipleSign(String password, String keyStorePath, String inputFile, String signedFile, List<SignatureProperty> signatureProperties) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.multipleSign(password, ResourceUtil.getResourceAsStream((String)keyStorePath), ResourceUtil.getResourceAsStream((String)inputFile), bos, signatureProperties);
        FileUtils.writeByteArrayToFile((File)new File(signedFile), (byte[])bos.toByteArray());
    }

    public void multipleSign(String password, InputStream keyStoreIn, InputStream inputFileIs, ByteArrayOutputStream signedFileOs, List<SignatureProperty> signatureProperties) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        boolean externallySign = false;
        Security.addProvider(SecurityProvider.getProvider());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(keyStoreIn, password.toCharArray());
        CreateVisibleSignature signing = new CreateVisibleSignature(keyStore, password.toCharArray());
        InputStream signatureInfoBis = null;
        ByteArrayOutputStream tos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputFileIs, (OutputStream)tos);
        for (SignatureProperty signatureProperty : signatureProperties) {
            ByteArrayInputStream inputFileIs1 = new ByteArrayInputStream(tos.toByteArray());
            ByteArrayInputStream inputFileIs2 = new ByteArrayInputStream(tos.toByteArray());
            if (signatureProperty.getSignatureImage().indexOf(";base64,") > 0) {
                byte[] b = Base64Utils.decodeFromString((String)signatureProperty.getSignatureImage());
                signatureInfoBis = new ByteArrayInputStream(b);
            } else {
                signatureInfoBis = ResourceUtil.getResourceAsStream((String)signatureProperty.getSignatureImage());
            }
            signing.setVisibleSignDesigner(inputFileIs1, signatureProperty.getX(), signatureProperty.getY(), signatureProperty.getWidth(), signatureProperty.getHeight(), signatureInfoBis, signatureProperty.getPageNum());
            signing.setVisibleSignatureProperties(signatureProperty.getName(), signatureProperty.getLocation(), signatureProperty.getReason(), 0, signatureProperty.getPageNum(), signatureProperty.isVisualSignEnabled());
            signing.setExternalSigning(externallySign);
            signing.signPDF(inputFileIs2, signedFileOs, null);
            tos = signedFileOs;
        }
    }

    public void singleSign(String password, InputStream keyStoreIn, InputStream inputFileIs, ByteArrayOutputStream signedFileOs, SignatureProperty signatureProperty) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ByteArrayOutputStream tos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputFileIs, (OutputStream)tos);
        ByteArrayInputStream inputFileIs1 = new ByteArrayInputStream(tos.toByteArray());
        ByteArrayInputStream inputFileIs2 = new ByteArrayInputStream(tos.toByteArray());
        PDDocument pdDocument = PDDocument.load((InputStream)inputFileIs1);
        int pageNum = pdDocument.getNumberOfPages();
        pdDocument.close();
        ArrayList<SignatureProperty> signatureProperties = new ArrayList<SignatureProperty>();
        for (int i = 1; i <= pageNum; ++i) {
            SignatureProperty cloneSignatureProperty = (SignatureProperty)BeanUtils.cloneBean((Object)signatureProperty);
            cloneSignatureProperty.setPageNum(i);
            signatureProperties.add(cloneSignatureProperty);
        }
        this.multipleSign(password, keyStoreIn, inputFileIs2, signedFileOs, signatureProperties);
    }

    public void singleSign(String password, String keyStorePath, String inputFilePath, String signedFilePath, SignatureProperty signatureProperty) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.singleSign(password, ResourceUtil.getResourceAsStream((String)keyStorePath), ResourceUtil.getResourceAsStream((String)inputFilePath), bos, signatureProperty);
        FileUtils.writeByteArrayToFile((File)new File(signedFilePath), (byte[])bos.toByteArray());
    }

    public static void main(String[] args) throws Exception {
    }
}

