/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.openhtmltopdf.signature;

import ink.rayin.htmladapter.openhtmltopdf.signature.CreateSignatureBase;
import ink.rayin.htmladapter.openhtmltopdf.signature.SigUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Calendar;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;

public class CreateSignature
extends CreateSignatureBase {
    public CreateSignature(KeyStore keystore, char[] pin) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException {
        super(keystore, pin);
    }

    public void signDetached(File file) throws IOException {
        this.signDetached(file, file, null);
    }

    public void signDetached(File inFile, File outFile) throws IOException {
        this.signDetached(inFile, outFile, null);
    }

    public void signDetached(File inFile, File outFile, String tsaUrl) throws IOException {
        if (inFile == null || !inFile.exists()) {
            throw new FileNotFoundException("Document for signing does not exist");
        }
        this.setTsaUrl(tsaUrl);
        try (FileOutputStream fos = new FileOutputStream(outFile);
             PDDocument doc = PDDocument.load((InputStream)new FileInputStream(outFile));){
            this.signDetached(doc, fos);
        }
    }

    public void signDetached(PDDocument document, OutputStream output) throws IOException {
        int accessPermissions = SigUtils.getMDPPermission(document);
        if (accessPermissions == 1) {
            throw new IllegalStateException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
        }
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        signature.setName("Example User");
        signature.setLocation("Los Angeles, CA");
        signature.setReason("Testing");
        signature.setSignDate(Calendar.getInstance());
        if (accessPermissions == 0) {
            SigUtils.setMDPPermission(document, signature, 2);
        }
        if (this.isExternalSigning()) {
            document.addSignature(signature);
            ExternalSigningSupport externalSigning = document.saveIncrementalForExternalSigning(output);
            byte[] cmsSignature = this.sign(externalSigning.getContent());
            externalSigning.setSignature(cmsSignature);
        } else {
            SignatureOptions signatureOptions = new SignatureOptions();
            signatureOptions.setPreferredSignatureSize(18944);
            document.addSignature(signature, (SignatureInterface)this, signatureOptions);
            document.saveIncremental(output);
        }
    }

    public static void main(String[] args) throws IOException, GeneralSecurityException {
        if (args.length < 3) {
            CreateSignature.usage();
            System.exit(1);
        }
        String tsaUrl = null;
        boolean externalSig = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-tsa")) {
                if (++i >= args.length) {
                    CreateSignature.usage();
                    System.exit(1);
                }
                tsaUrl = args[i];
            }
            if (!args[i].equals("-e")) continue;
            externalSig = true;
        }
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        char[] password = args[1].toCharArray();
        keystore.load(new FileInputStream(args[0]), password);
        CreateSignature signing = new CreateSignature(keystore, password);
        signing.setExternalSigning(externalSig);
        File inFile = new File(args[2]);
        String name = inFile.getName();
        String substring = name.substring(0, name.lastIndexOf(46));
        File outFile = new File(inFile.getParent(), substring + "_signed.pdf");
        signing.signDetached(inFile, outFile, tsaUrl);
    }

    private static void usage() {
        System.err.println("usage: java " + CreateSignature.class.getName() + " <pkcs12_keystore> <password> <pdf_to_sign>\noptions:\n  -tsa <url>    sign timestamp using the given TSA server\n  -e            sign using external signature creation scenario");
    }
}

