/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.openhtmltopdf.signature.cert;

import ink.rayin.htmladapter.openhtmltopdf.signature.cert.CRLVerifier;
import ink.rayin.htmladapter.openhtmltopdf.signature.cert.CertificateVerificationException;
import ink.rayin.htmladapter.openhtmltopdf.signature.cert.OcspHelper;
import ink.rayin.htmladapter.openhtmltopdf.signature.cert.RevokedCertificateException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;

public final class CertificateVerifier {
    private static final Log LOG = LogFactory.getLog(CertificateVerifier.class);

    private CertificateVerifier() {
    }

    public static PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert, Set<X509Certificate> additionalCerts, boolean verifySelfSignedCert, Date signDate) throws CertificateVerificationException {
        try {
            if (!verifySelfSignedCert && CertificateVerifier.isSelfSigned(cert)) {
                throw new CertificateVerificationException("The certificate is self-signed.");
            }
            HashSet<X509Certificate> certSet = new HashSet<X509Certificate>();
            certSet.addAll(additionalCerts);
            HashSet<X509Certificate> certsToTrySet = new HashSet<X509Certificate>();
            certsToTrySet.add(cert);
            int downloadSize = 0;
            while (!certsToTrySet.isEmpty()) {
                HashSet<X509Certificate> nextCertsToTrySet = new HashSet<X509Certificate>();
                for (X509Certificate x509Certificate : certsToTrySet) {
                    Set<X509Certificate> downloadedExtraCertificatesSet = CertificateVerifier.downloadExtraCertificates(x509Certificate);
                    for (X509Certificate downloadedCertificate : downloadedExtraCertificatesSet) {
                        if (certSet.contains(downloadedCertificate)) continue;
                        nextCertsToTrySet.add(downloadedCertificate);
                        certSet.add(downloadedCertificate);
                        ++downloadSize;
                    }
                }
                certsToTrySet = nextCertsToTrySet;
            }
            if (downloadSize > 0) {
                LOG.info((Object)("CA issuers: " + downloadSize + " downloaded certificate(s) are new"));
            }
            HashSet<X509Certificate> intermediateCerts = new HashSet<X509Certificate>();
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (X509Certificate additionalCert : certSet) {
                if (CertificateVerifier.isSelfSigned(additionalCert)) {
                    trustAnchors.add(new TrustAnchor(additionalCert, null));
                    continue;
                }
                intermediateCerts.add(additionalCert);
            }
            if (trustAnchors.isEmpty()) {
                throw new CertificateVerificationException("No root certificate in the chain");
            }
            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = CertificateVerifier.verifyCertificate(cert, trustAnchors, intermediateCerts, signDate);
            LOG.info((Object)("Certification chain verified successfully up to this root: " + pKIXCertPathBuilderResult.getTrustAnchor().getTrustedCert().getSubjectX500Principal()));
            CertificateVerifier.checkRevocations(cert, certSet, signDate);
            return pKIXCertPathBuilderResult;
        }
        catch (CertPathBuilderException certPathEx) {
            throw new CertificateVerificationException("Error building certification path: " + cert.getSubjectX500Principal(), certPathEx);
        }
        catch (CertificateVerificationException cvex) {
            throw cvex;
        }
        catch (RevokedCertificateException | IOException | GeneralSecurityException | OCSPException ex) {
            throw new CertificateVerificationException("Error verifying the certificate: " + cert.getSubjectX500Principal(), ex);
        }
    }

    private static void checkRevocations(X509Certificate cert, Set<X509Certificate> additionalCerts, Date signDate) throws IOException, CertificateVerificationException, OCSPException, RevokedCertificateException, GeneralSecurityException {
        String ocspURL;
        if (CertificateVerifier.isSelfSigned(cert)) {
            return;
        }
        X509Certificate issuerCert = null;
        for (X509Certificate additionalCert : additionalCerts) {
            try {
                cert.verify(additionalCert.getPublicKey(), SecurityProvider.getProvider());
                issuerCert = additionalCert;
                break;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        if ((ocspURL = CertificateVerifier.extractOCSPURL(cert)) != null) {
            OcspHelper ocspHelper = new OcspHelper(cert, signDate, issuerCert, additionalCerts, ocspURL);
            try {
                CertificateVerifier.verifyOCSP(ocspHelper, additionalCerts);
            }
            catch (IOException | OCSPException ex) {
                LOG.warn((Object)"Exception trying OCSP, will try CRL", ex);
                LOG.warn((Object)("Certificate# to check: " + cert.getSerialNumber().toString(16)));
                CRLVerifier.verifyCertificateCRLs(cert, signDate, additionalCerts);
            }
        } else {
            LOG.info((Object)"OCSP not available, will try CRL");
            CRLVerifier.verifyCertificateCRLs(cert, signDate, additionalCerts);
        }
        CertificateVerifier.checkRevocations(issuerCert, additionalCerts, signDate);
    }

    public static boolean isSelfSigned(X509Certificate cert) throws GeneralSecurityException {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key, SecurityProvider.getProvider());
            return true;
        }
        catch (IOException | InvalidKeyException | SignatureException ex) {
            LOG.debug((Object)"Couldn't get signature information - returning false", (Throwable)ex);
            return false;
        }
    }

    public static Set<X509Certificate> downloadExtraCertificates(X509Extension ext) {
        ASN1Primitive asn1Prim;
        HashSet<X509Certificate> resultSet = new HashSet<X509Certificate>();
        byte[] authorityExtensionValue = ext.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (authorityExtensionValue == null) {
            return resultSet;
        }
        try {
            asn1Prim = JcaX509ExtensionUtils.parseExtensionValue((byte[])authorityExtensionValue);
        }
        catch (IOException ex) {
            LOG.warn((Object)ex.getMessage(), (Throwable)ex);
            return resultSet;
        }
        if (!(asn1Prim instanceof ASN1Sequence)) {
            LOG.warn((Object)("ASN1Sequence expected, got " + asn1Prim.getClass().getSimpleName()));
            return resultSet;
        }
        ASN1Sequence asn1Seq = (ASN1Sequence)asn1Prim;
        Enumeration objects = asn1Seq.getObjects();
        while (objects.hasMoreElements()) {
            ASN1Sequence obj = (ASN1Sequence)objects.nextElement();
            ASN1Encodable oid = obj.getObjectAt(0);
            if (!X509ObjectIdentifiers.id_ad_caIssuers.equals(oid)) continue;
            ASN1TaggedObject location = (ASN1TaggedObject)obj.getObjectAt(1);
            ASN1OctetString uri = (ASN1OctetString)location.getObject();
            String urlString = new String(uri.getOctets());
            LOG.info((Object)("CA issuers URL: " + urlString));
            try {
                InputStream in = new URL(urlString).openStream();
                Throwable throwable = null;
                try {
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    Collection<? extends Certificate> altCerts = certFactory.generateCertificates(in);
                    altCerts.forEach(altCert -> resultSet.add((X509Certificate)altCert));
                    LOG.info((Object)("CA issuers URL: " + altCerts.size() + " certificate(s) downloaded"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException ex) {
                LOG.warn((Object)(urlString + " failure: " + ex.getMessage()), (Throwable)ex);
            }
            catch (CertificateException ex) {
                LOG.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        LOG.info((Object)("CA issuers: Downloaded " + resultSet.size() + " certificate(s) total"));
        return resultSet;
    }

    private static PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert, Set<TrustAnchor> trustAnchors, Set<X509Certificate> intermediateCerts, Date signDate) throws GeneralSecurityException {
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        pkixParams.setRevocationEnabled(false);
        pkixParams.setPolicyQualifiersRejected(false);
        pkixParams.setDate(signDate);
        CertStore intermediateCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(intermediateCerts));
        pkixParams.addCertStore(intermediateCertStore);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        return (PKIXCertPathBuilderResult)builder.build(pkixParams);
    }

    private static String extractOCSPURL(X509Certificate cert) throws IOException {
        byte[] authorityExtensionValue = cert.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (authorityExtensionValue != null) {
            ASN1Sequence asn1Seq = (ASN1Sequence)JcaX509ExtensionUtils.parseExtensionValue((byte[])authorityExtensionValue);
            Enumeration objects = asn1Seq.getObjects();
            while (objects.hasMoreElements()) {
                ASN1Sequence obj = (ASN1Sequence)objects.nextElement();
                ASN1Encodable oid = obj.getObjectAt(0);
                ASN1TaggedObject location = (ASN1TaggedObject)obj.getObjectAt(1);
                if (!X509ObjectIdentifiers.id_ad_ocsp.equals(oid) || location.getTagNo() != 6) continue;
                ASN1OctetString url = (ASN1OctetString)location.getObject();
                String ocspURL = new String(url.getOctets());
                LOG.info((Object)("OCSP URL: " + ocspURL));
                return ocspURL;
            }
        }
        return null;
    }

    private static void verifyOCSP(OcspHelper ocspHelper, Set<X509Certificate> additionalCerts) throws RevokedCertificateException, IOException, OCSPException, CertificateVerificationException {
        Date now = Calendar.getInstance().getTime();
        OCSPResp ocspResponse = ocspHelper.getResponseOcsp();
        if (ocspResponse.getStatus() != 0) {
            throw new CertificateVerificationException("OCSP check not successful, status: " + ocspResponse.getStatus());
        }
        LOG.info((Object)"OCSP check successful");
        BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
        X509Certificate ocspResponderCertificate = ocspHelper.getOcspResponderCertificate();
        if (ocspResponderCertificate.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) != null) {
            LOG.info((Object)"Revocation check of OCSP responder certificate skipped (id-pkix-ocsp-nocheck is set)");
            return;
        }
        if (ocspHelper.getCertificateToCheck().equals(ocspResponderCertificate)) {
            LOG.info((Object)"OCSP responder certificate is identical to certificate to check");
            return;
        }
        LOG.info((Object)"Check of OCSP responder certificate");
        HashSet<X509Certificate> additionalCerts2 = new HashSet<X509Certificate>(additionalCerts);
        JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();
        for (X509CertificateHolder certHolder : basicResponse.getCerts()) {
            try {
                X509Certificate cert = certificateConverter.getCertificate(certHolder);
                if (ocspResponderCertificate.equals(cert)) continue;
                additionalCerts2.add(cert);
            }
            catch (CertificateException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        CertificateVerifier.verifyCertificate(ocspResponderCertificate, additionalCerts2, true, now);
        LOG.info((Object)"Check of OCSP responder certificate done");
    }
}

