/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.openhtmltopdf.utils;

import ink.rayin.htmladapter.openhtmltopdf.utils.TextPositionSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBoxPositionFindByKey {
    private static final Logger log = LoggerFactory.getLogger(PdfBoxPositionFindByKey.class);

    private static List<TextPositionSequence> findKeywordPage(PDDocument document, int page, final String keyword) throws IOException {
        final ArrayList<TextPositionSequence> hits = new ArrayList<TextPositionSequence>();
        PDFTextStripper stripper = new PDFTextStripper(){

            protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
                int index;
                TextPositionSequence word = new TextPositionSequence(textPositions);
                String string = word.toString();
                int fromIndex = 0;
                while ((index = string.indexOf(keyword, fromIndex)) > -1) {
                    hits.add(word.subSequence(index, index + keyword.length()));
                    fromIndex = index + 1;
                }
                super.writeString(text, textPositions);
            }
        };
        stripper.setSortByPosition(true);
        stripper.setStartPage(page);
        stripper.setEndPage(page);
        stripper.getText(document);
        return hits;
    }

    public static List<float[]> findKeywordPagesPostions(byte[] pdfData, String keyword) throws IOException {
        PDDocument document = PDDocument.load((byte[])pdfData);
        ArrayList<float[]> pagesPositions = new ArrayList<float[]>();
        for (int page = 1; page <= document.getNumberOfPages(); ++page) {
            List<float[]> pagePositions = PdfBoxPositionFindByKey.findKeywordPagePostions(pdfData, keyword, page);
            pagesPositions.addAll(pagePositions);
        }
        return pagesPositions;
    }

    public static List<float[]> findKeywordPagePostions(byte[] pdfData, String keyword, int pageNum) throws IOException {
        PDDocument document = PDDocument.load((byte[])pdfData);
        ArrayList<float[]> positions = new ArrayList<float[]>();
        List<TextPositionSequence> hits = PdfBoxPositionFindByKey.findKeywordPage(document, pageNum, keyword);
        for (TextPositionSequence hit : hits) {
            float[] pos = new float[]{pageNum, hit.getX(), hit.getY()};
            positions.add(pos);
        }
        return positions;
    }
}

