/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.openhtmltopdf.utils;

import java.util.List;
import org.apache.pdfbox.text.TextPosition;

public class TextPositionSequence
implements CharSequence {
    final List<TextPosition> textPositions;
    final int start;
    final int end;

    public TextPositionSequence(List<TextPosition> textPositions) {
        this(textPositions, 0, textPositions.size());
    }

    public TextPositionSequence(List<TextPosition> textPositions, int start, int end) {
        this.textPositions = textPositions;
        this.start = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        TextPosition textPosition = this.textPositionAt(index);
        String text = textPosition.getUnicode();
        return text.charAt(0);
    }

    @Override
    public TextPositionSequence subSequence(int start, int end) {
        return new TextPositionSequence(this.textPositions, this.start + start, this.start + end);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.length());
        for (int i = 0; i < this.length(); ++i) {
            builder.append(this.charAt(i));
        }
        return builder.toString();
    }

    public TextPosition textPositionAt(int index) {
        return this.textPositions.get(this.start + index);
    }

    public float getX() {
        return this.textPositions.get(this.start).getXDirAdj();
    }

    public float getY() {
        return this.textPositions.get(this.start).getYDirAdj();
    }

    public float getWidth() {
        if (this.end == this.start) {
            return 0.0f;
        }
        TextPosition first = this.textPositions.get(this.start);
        TextPosition last = this.textPositions.get(this.end - 1);
        return last.getWidthDirAdj() + last.getXDirAdj() - first.getXDirAdj();
    }
}

