/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.backuprequests;

import com.linkedin.d2.BoundedCostBackupRequests;
import com.linkedin.d2.backuprequests.BackupRequestsStrategy;
import com.linkedin.d2.backuprequests.BoundedCostBackupRequestsStrategy;
import com.linkedin.d2.backuprequests.TrackingBackupRequestsStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackupRequestsStrategyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BackupRequestsStrategyFactory.class);
    private static final BoundedCostBackupRequests BCBR = new BoundedCostBackupRequests();

    private BackupRequestsStrategyFactory() {
    }

    public static TrackingBackupRequestsStrategy create(Map<String, Object> backupRequestsConfiguration) {
        try {
            return new TrackingBackupRequestsStrategy(BackupRequestsStrategyFactory.tryCreate(backupRequestsConfiguration));
        }
        catch (Exception e) {
            LOG.error("Failed to create BackupRequestsStrategy from configuration: " + backupRequestsConfiguration, (Throwable)e);
            return null;
        }
    }

    static BackupRequestsStrategy tryCreate(Map<String, Object> backupRequestsConfiguration) {
        Map strategy = (Map)BackupRequestsStrategyFactory.mapGet(backupRequestsConfiguration, "strategy");
        if (strategy.containsKey(BCBR.getClass().getName())) {
            return BackupRequestsStrategyFactory.tryCreateBoundedCost((Map)BackupRequestsStrategyFactory.mapGet(strategy, BCBR.getClass().getName()));
        }
        throw new RuntimeException("Unrecognized type of BackupRequestsStrategy: " + strategy);
    }

    static BoundedCostBackupRequestsStrategy tryCreateBoundedCost(Map<String, Object> properties) {
        int cost = (Integer)BackupRequestsStrategyFactory.mapGet(properties, "cost");
        int historyLength = properties.containsKey("historyLength") ? ((Integer)BackupRequestsStrategyFactory.mapGet(properties, "historyLength")).intValue() : BCBR.getHistoryLength().intValue();
        int requiredHistoryLength = properties.containsKey("requiredHistoryLength") ? ((Integer)BackupRequestsStrategyFactory.mapGet(properties, "requiredHistoryLength")).intValue() : BCBR.getRequiredHistoryLength().intValue();
        int maxBurst = properties.containsKey("maxBurst") ? ((Integer)BackupRequestsStrategyFactory.mapGet(properties, "maxBurst")).intValue() : BCBR.getMaxBurst().intValue();
        int minBackupDelayMs = properties.containsKey("minBackupDelayMs") ? ((Integer)BackupRequestsStrategyFactory.mapGet(properties, "minBackupDelayMs")).intValue() : BCBR.getMinBackupDelayMs().intValue();
        return new BoundedCostBackupRequestsStrategy(cost, maxBurst, historyLength, requiredHistoryLength, minBackupDelayMs);
    }

    private static <T> T mapGet(Map<String, Object> map, String key) {
        return (T)map.get(key);
    }
}

