/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.backuprequests;

import com.linkedin.d2.backuprequests.BackupRequestsStrategyFactory;
import com.linkedin.d2.backuprequests.TrackingBackupRequestsStrategy;
import java.util.Map;
import java.util.Optional;

public class BackupRequestsStrategyFromConfig {
    private final Optional<TrackingBackupRequestsStrategy> _strategy;
    private final Map<String, Object> _config;

    public BackupRequestsStrategyFromConfig(Map<String, Object> config) {
        this._strategy = config == null ? Optional.empty() : Optional.ofNullable(BackupRequestsStrategyFactory.create(config));
        this._config = config;
    }

    public Optional<TrackingBackupRequestsStrategy> getStrategy() {
        return this._strategy;
    }

    public BackupRequestsStrategyFromConfig update(Map<String, Object> config) {
        if (config == null) {
            if (this._config != null) {
                return new BackupRequestsStrategyFromConfig(config);
            }
            return this;
        }
        if (!config.equals(this._config)) {
            return new BackupRequestsStrategyFromConfig(config);
        }
        return this;
    }

    public String toString() {
        return "BackupRequestsStrategyFromConfig [strategy=" + this._strategy + ", config=" + this._config + "]";
    }
}

