/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.backuprequests;

import com.linkedin.d2.backuprequests.BackupRequestsStrategy;
import com.linkedin.d2.balancer.util.BurstyBarrier;
import java.util.Optional;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.IntCountsHistogram;
import org.HdrHistogram.ShortCountsHistogram;

public class BoundedCostBackupRequestsStrategy
implements BackupRequestsStrategy {
    private static final int UNREASONABLE_HISTORY_LENGTH = 0x1000000;
    static final long LOW = 1000L;
    static final long HIGH = 100000000000L;
    private final AbstractHistogram _histogram;
    private final long[] _history;
    private int _historyIdx = 0;
    private boolean _histogramReady = false;
    private final int _historyLength;
    private final int _requiredHistory;
    private final double _percentile;
    private final long _minBackupDelayNano;
    private final BurstyBarrier _costLimiter;
    private final Object _lock = new Object();

    public BoundedCostBackupRequestsStrategy(double percent, int maxBurst, int historyLength, int requiredHistory, int minBackupDelayMs) {
        if (percent <= 0.0 || percent >= 100.0) {
            throw new IllegalArgumentException("percent parameter has to be within range: (0, 100), excluding 0 and 100, got: " + percent);
        }
        if (maxBurst <= 0) {
            throw new IllegalArgumentException("maxBurst parameter has to be a positive number, got: " + maxBurst);
        }
        if (historyLength <= 99 || historyLength >= 0x1000000) {
            throw new IllegalArgumentException("historyLength parameter has to be within range: (100, 16777215), got: " + historyLength);
        }
        if (requiredHistory <= 99) {
            throw new IllegalArgumentException("requiredHistory parameter has to be a number greater than 99, got: " + requiredHistory);
        }
        if (minBackupDelayMs < 0) {
            throw new IllegalArgumentException("minBackupDelayMs parameter must not be a negative number, got: " + minBackupDelayMs);
        }
        this._historyLength = historyLength;
        this._histogram = historyLength <= Short.MAX_VALUE ? new ShortCountsHistogram(1000L, 100000000000L, 3) : new IntCountsHistogram(1000L, 100000000000L, 3);
        this._history = new long[historyLength];
        this._requiredHistory = requiredHistory;
        this._percentile = 100.0 - percent;
        this._costLimiter = new BurstyBarrier(percent, maxBurst);
        this._minBackupDelayNano = 1000000L * (long)minBackupDelayMs;
    }

    @Override
    public boolean isBackupRequestAllowed() {
        return this._costLimiter.canPassThrough();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Long> getTimeUntilBackupRequestNano() {
        this._costLimiter.arrive();
        Object object = this._lock;
        synchronized (object) {
            if (this._histogramReady) {
                return Optional.of(Math.max(this._minBackupDelayNano, this._histogram.getValueAtPercentile(this._percentile)));
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordCompletion(long duration) {
        duration = Math.max(1000L, duration);
        duration = Math.min(100000000000L, duration);
        Object object = this._lock;
        synchronized (object) {
            ++this._historyIdx;
            if (this._historyIdx == this._requiredHistory) {
                this._histogramReady = true;
            }
            this._historyIdx %= this._historyLength;
            if (this._history[this._historyIdx] != 0L) {
                this._histogram.recordValueWithCount(this._history[this._historyIdx], -1L);
            }
            this._histogram.recordValueWithCount(duration, 1L);
            this._history[this._historyIdx] = duration;
        }
    }

    public int getHistoryLength() {
        return this._historyLength;
    }

    public int getRequiredHistory() {
        return this._requiredHistory;
    }

    public double getPercent() {
        return 100.0 - this._percentile;
    }

    public long getMinBackupDelayNano() {
        return this._minBackupDelayNano;
    }
}

