/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.backuprequests;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.ShortCountsHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyMetric {
    private static final Logger LOG = LoggerFactory.getLogger(LatencyMetric.class);
    public static final long LOWEST_DISCERNIBLE_VALUE = TimeUnit.MICROSECONDS.toNanos(1L);
    public static final long HIGHEST_TRACKABLE_VALUE = TimeUnit.SECONDS.toNanos(100L);
    public static final int NUMBER_OF_SIGNIFICANT_VALUE_DIGITS = 3;
    private AtomicReference<AbstractHistogram> _current = new AtomicReference<ShortCountsHistogram>(new ShortCountsHistogram(LOWEST_DISCERNIBLE_VALUE, HIGHEST_TRACKABLE_VALUE, 3));
    private AtomicReference<AbstractHistogram> _inactive = new AtomicReference<ShortCountsHistogram>(new ShortCountsHistogram(LOWEST_DISCERNIBLE_VALUE, HIGHEST_TRACKABLE_VALUE, 3));

    public void record(long latencyNano, Consumer<AbstractHistogram> overflownConsumer) {
        this.recordSafeValue(this.narrow(latencyNano), overflownConsumer);
    }

    private long narrow(long latencyNano) {
        if (latencyNano < LOWEST_DISCERNIBLE_VALUE) {
            return LOWEST_DISCERNIBLE_VALUE;
        }
        if (latencyNano > HIGHEST_TRACKABLE_VALUE) {
            return HIGHEST_TRACKABLE_VALUE;
        }
        return latencyNano;
    }

    private static <T> T claim(AtomicReference<T> ref) {
        T current;
        while ((current = ref.get()) == null || !ref.compareAndSet(current, null)) {
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSafeValue(long latencyNano, Consumer<AbstractHistogram> overflownConsumer) {
        AbstractHistogram current = LatencyMetric.claim(this._current);
        try {
            current.recordValue(latencyNano);
            this._current.set(current);
        }
        catch (IllegalStateException e) {
            AbstractHistogram inactive = LatencyMetric.claim(this._inactive);
            inactive.recordValue(latencyNano);
            this._current.set(inactive);
            try {
                overflownConsumer.accept(current);
            }
            catch (Throwable t) {
                LOG.error("failed to consume overflown histogram for latencies metric", t);
            }
            finally {
                current.reset();
                this._inactive.set(current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void harvest(Consumer<AbstractHistogram> consumer) {
        AbstractHistogram current = LatencyMetric.claim(this._current);
        this._current.set(LatencyMetric.claim(this._inactive));
        try {
            consumer.accept(current);
        }
        catch (Throwable t) {
            LOG.error("failed to consume histogram for latencies metric", t);
        }
        finally {
            current.reset();
            this._inactive.set(current);
        }
    }
}

