/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.backuprequests;

import com.linkedin.d2.backuprequests.BackupRequestsStrategy;
import com.linkedin.d2.backuprequests.BackupRequestsStrategyStats;
import com.linkedin.d2.backuprequests.BackupRequestsStrategyStatsProvider;
import com.linkedin.d2.backuprequests.LatencyMetric;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

public class TrackingBackupRequestsStrategy
implements BackupRequestsStrategy,
BackupRequestsStrategyStatsProvider {
    private final BackupRequestsStrategy _delegate;
    private final LongAdder _totalAllowedCount = new LongAdder();
    private final LongAdder _totalSuccessCount = new LongAdder();
    private final AtomicReference<DelayStats> _lastDelayStats = new AtomicReference();
    private final AtomicReference<BackupRequestsStrategyStats> _snapshotStats = new AtomicReference();
    private final AtomicReference<DelayStats> _snapshotDelayStats = new AtomicReference();
    private final LatencyMetric _latencyWithBackup = new LatencyMetric();
    private final LatencyMetric _latencyWithoutBackup = new LatencyMetric();

    public TrackingBackupRequestsStrategy(BackupRequestsStrategy delegate) {
        this._delegate = delegate;
    }

    @Override
    public Optional<Long> getTimeUntilBackupRequestNano() {
        Optional<Long> delay = this._delegate.getTimeUntilBackupRequestNano();
        delay.ifPresent(this::recordDelay);
        return delay;
    }

    private void recordDelay(long delay) {
        DelayStats next;
        DelayStats prev;
        while (!this._lastDelayStats.compareAndSet(prev, next = (prev = this._lastDelayStats.get()) == null ? DelayStats.create(delay) : prev.recordDelay(delay))) {
        }
    }

    @Override
    public void recordCompletion(long responseTime) {
        this._delegate.recordCompletion(responseTime);
    }

    @Override
    public boolean isBackupRequestAllowed() {
        boolean allowed = this._delegate.isBackupRequestAllowed();
        if (allowed) {
            this._totalAllowedCount.increment();
        }
        return allowed;
    }

    public void backupRequestSuccess() {
        this._totalSuccessCount.increment();
    }

    @Override
    public BackupRequestsStrategyStats getStats() {
        return this.getStats(this._lastDelayStats.get());
    }

    private BackupRequestsStrategyStats getStats(DelayStats delayStats) {
        if (delayStats == null) {
            return new BackupRequestsStrategyStats(this._totalAllowedCount.sum(), this._totalSuccessCount.sum(), 0L, 0L, 0L);
        }
        return new BackupRequestsStrategyStats(this._totalAllowedCount.sum(), this._totalSuccessCount.sum(), delayStats._totalDelayMin, delayStats._totalDelayMax, delayStats._totalDelaySum / delayStats._totalDelayCount);
    }

    @Override
    public BackupRequestsStrategyStats getDiffStats() {
        BackupRequestsStrategyStats stats = this.doGetDiffStats();
        while (stats == null) {
            stats = this.doGetDiffStats();
        }
        return stats;
    }

    private BackupRequestsStrategyStats doGetDiffStats() {
        BackupRequestsStrategyStats snapshotStats = this._snapshotStats.get();
        if (snapshotStats == null) {
            BackupRequestsStrategyStats stats;
            DelayStats lastDelayStats = this._lastDelayStats.get();
            if (lastDelayStats != null) {
                if (!this._lastDelayStats.compareAndSet(lastDelayStats, lastDelayStats.resetNonTotal())) {
                    return null;
                }
                this._snapshotDelayStats.set(this._lastDelayStats.get());
            }
            if (this._snapshotStats.compareAndSet(null, stats = this.getStats(this._snapshotDelayStats.get()))) {
                return stats;
            }
            return this.doGetDiffStats();
        }
        return this.getDiffStats(snapshotStats);
    }

    private BackupRequestsStrategyStats getDiffStats(BackupRequestsStrategyStats snapshotStats) {
        DelayStats snapshotDelayStats;
        DelayStats lastDelayStats;
        do {
            if ((lastDelayStats = this._lastDelayStats.get()) != null) continue;
            if (this._snapshotStats.compareAndSet(snapshotStats, new BackupRequestsStrategyStats(this._totalAllowedCount.sum(), this._totalSuccessCount.sum(), 0L, 0L, 0L))) {
                return new BackupRequestsStrategyStats(this._totalAllowedCount.sum() - snapshotStats.getAllowed(), this._totalSuccessCount.sum() - snapshotStats.getSuccessful(), 0L, 0L, 0L);
            }
            return null;
        } while (!this._lastDelayStats.compareAndSet(lastDelayStats, lastDelayStats.resetNonTotal()) || !this._snapshotDelayStats.compareAndSet(snapshotDelayStats = this._snapshotDelayStats.get(), lastDelayStats));
        if (snapshotDelayStats == null) {
            if (this._snapshotStats.compareAndSet(snapshotStats, new BackupRequestsStrategyStats(this._totalAllowedCount.sum(), this._totalSuccessCount.sum(), lastDelayStats._totalDelayMin, lastDelayStats._totalDelayMax, lastDelayStats._totalDelaySum / lastDelayStats._totalDelayCount))) {
                return new BackupRequestsStrategyStats(this._totalAllowedCount.sum() - snapshotStats.getAllowed(), this._totalSuccessCount.sum() - snapshotStats.getSuccessful(), lastDelayStats._totalDelayMin, lastDelayStats._totalDelayMax, lastDelayStats._totalDelaySum / lastDelayStats._totalDelayCount);
            }
            return null;
        }
        return this.getDiffStats(snapshotStats, snapshotDelayStats, lastDelayStats);
    }

    private BackupRequestsStrategyStats getDiffStats(BackupRequestsStrategyStats snapshotStats, DelayStats snapshotDelayStats, DelayStats lastDelayStats) {
        long count = lastDelayStats._totalDelayCount - snapshotDelayStats._totalDelayCount;
        if (count <= 0L) {
            if (this._snapshotStats.compareAndSet(snapshotStats, new BackupRequestsStrategyStats(this._totalAllowedCount.sum(), this._totalSuccessCount.sum(), 0L, 0L, 0L))) {
                return new BackupRequestsStrategyStats(this._totalAllowedCount.sum() - snapshotStats.getAllowed(), this._totalSuccessCount.sum() - snapshotStats.getSuccessful(), 0L, 0L, 0L);
            }
            return null;
        }
        if (this._snapshotStats.compareAndSet(snapshotStats, new BackupRequestsStrategyStats(this._totalAllowedCount.sum(), this._totalSuccessCount.sum(), lastDelayStats._delayMin, lastDelayStats._delayMax, (lastDelayStats._totalDelaySum - snapshotDelayStats._totalDelaySum) / count))) {
            return new BackupRequestsStrategyStats(this._totalAllowedCount.sum() - snapshotStats.getAllowed(), this._totalSuccessCount.sum() - snapshotStats.getSuccessful(), lastDelayStats._delayMin, lastDelayStats._delayMax, (lastDelayStats._totalDelaySum - snapshotDelayStats._totalDelaySum) / count);
        }
        return null;
    }

    public String toString() {
        return "TrackingBackupRequestsStrategy [delegate=" + this._delegate + ", totalAllowedCount=" + this._totalAllowedCount + ", totalSuccessCount=" + this._totalSuccessCount + ", lastDelayStats=" + this._lastDelayStats + ", snapshotStats=" + this._snapshotStats + ", snapshotDelayStats=" + this._snapshotDelayStats + "]";
    }

    public LatencyMetric getLatencyWithBackup() {
        return this._latencyWithBackup;
    }

    public LatencyMetric getLatencyWithoutBackup() {
        return this._latencyWithoutBackup;
    }

    static class DelayStats {
        private final long _totalDelayCount;
        private final long _totalDelaySum;
        private final long _totalDelayMax;
        private final long _totalDelayMin;
        private final long _delayMax;
        private final long _delayMin;

        DelayStats(long totalDelayCount, long totalDelaySum, long totalDelayMax, long totalDelayMin, long delayMax, long delayMin) {
            this._totalDelayCount = totalDelayCount;
            this._totalDelaySum = totalDelaySum;
            this._totalDelayMax = totalDelayMax;
            this._totalDelayMin = totalDelayMin;
            this._delayMax = delayMax;
            this._delayMin = delayMin;
        }

        DelayStats recordDelay(long delay) {
            if (this._totalDelaySum + delay > 0L) {
                return new DelayStats(this._totalDelayCount + 1L, this._totalDelaySum + delay, Math.max(delay, this._totalDelayMax), Math.min(delay, this._totalDelayMin), Math.max(delay, this._delayMax), Math.min(delay, this._delayMin));
            }
            return DelayStats.create(delay);
        }

        DelayStats resetNonTotal() {
            return new DelayStats(this._totalDelayCount, this._totalDelaySum, this._totalDelayMax, this._totalDelayMin, Long.MIN_VALUE, Long.MAX_VALUE);
        }

        static DelayStats create(long delay) {
            return new DelayStats(1L, delay, delay, delay, delay, delay);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this._delayMax ^ this._delayMax >>> 32);
            result = 31 * result + (int)(this._delayMin ^ this._delayMin >>> 32);
            result = 31 * result + (int)(this._totalDelayCount ^ this._totalDelayCount >>> 32);
            result = 31 * result + (int)(this._totalDelayMax ^ this._totalDelayMax >>> 32);
            result = 31 * result + (int)(this._totalDelayMin ^ this._totalDelayMin >>> 32);
            result = 31 * result + (int)(this._totalDelaySum ^ this._totalDelaySum >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DelayStats other = (DelayStats)obj;
            if (this._delayMax != other._delayMax) {
                return false;
            }
            if (this._delayMin != other._delayMin) {
                return false;
            }
            if (this._totalDelayCount != other._totalDelayCount) {
                return false;
            }
            if (this._totalDelayMax != other._totalDelayMax) {
                return false;
            }
            if (this._totalDelayMin != other._totalDelayMin) {
                return false;
            }
            return this._totalDelaySum == other._totalDelaySum;
        }

        public String toString() {
            return "DelayStats [totalDelayCount=" + this._totalDelayCount + ", totalDelaySum=" + this._totalDelaySum + ", totalDelayMin=" + this._totalDelayMin + ", totalDelayMax=" + this._totalDelayMax + ", delayMin=" + this._delayMin + ", delayMax=" + this._delayMax + "]";
        }
    }
}

