/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.backuprequests.BackupRequestsStrategyStatsConsumer;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.D2ClientConfig;
import com.linkedin.d2.balancer.D2ClientDelegator;
import com.linkedin.d2.balancer.LoadBalancerWithFacilities;
import com.linkedin.d2.balancer.LoadBalancerWithFacilitiesFactory;
import com.linkedin.d2.balancer.ZKFSLoadBalancerWithFacilitiesFactory;
import com.linkedin.d2.balancer.clients.BackupRequestsClient;
import com.linkedin.d2.balancer.clients.DynamicClient;
import com.linkedin.d2.balancer.clients.FailoutClient;
import com.linkedin.d2.balancer.clients.FailoutRedirectStrategy;
import com.linkedin.d2.balancer.clients.RequestTimeoutClient;
import com.linkedin.d2.balancer.clients.RetryClient;
import com.linkedin.d2.balancer.clusterfailout.FailoutConfigProviderFactory;
import com.linkedin.d2.balancer.event.EventEmitter;
import com.linkedin.d2.balancer.simple.SslSessionValidatorFactory;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyFactoryV3;
import com.linkedin.d2.balancer.strategies.random.RandomLoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.strategies.relative.RelativeLoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.subsetting.DeterministicSubsettingMetadataProvider;
import com.linkedin.d2.balancer.util.canary.CanaryDistributionProvider;
import com.linkedin.d2.balancer.util.downstreams.DownstreamServicesFetcher;
import com.linkedin.d2.balancer.util.downstreams.FSBasedDownstreamServicesFetcher;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckOperations;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessorRegistry;
import com.linkedin.d2.balancer.zkfs.ZKFSTogglingLoadBalancerFactoryImpl;
import com.linkedin.d2.discovery.stores.zk.ZKPersistentConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import com.linkedin.d2.jmx.JmxManager;
import com.linkedin.d2.jmx.NoOpJmxManager;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import com.linkedin.r2.util.NamedThreadFactory;
import com.linkedin.util.ArgumentUtil;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class D2ClientBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(D2ClientBuilder.class);
    private boolean _restOverStream = false;
    private final D2ClientConfig _config = new D2ClientConfig();

    public D2Client build() {
        Map<String, TransportClientFactory> transportClientFactories = this._config.clientFactories == null ? this.createDefaultTransportClientFactories() : this._config.clientFactories;
        ArrayList<ScheduledExecutorService> executorsToShutDown = new ArrayList<ScheduledExecutorService>();
        if (this._config.startUpExecutorService == null) {
            this._config.startUpExecutorService = Executors.newScheduledThreadPool(0, (ThreadFactory)new NamedThreadFactory("D2 StartupOnlyExecutor"));
            executorsToShutDown.add(this._config.startUpExecutorService);
        }
        if (this._config._executorService == null) {
            LOG.warn("No executor service passed as argument. Pass it for enhanced monitoring and to have better control over the executor.");
            this._config._executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("D2 PropertyEventExecutor"));
            executorsToShutDown.add(this._config._executorService);
        }
        if (this._config.downstreamServicesFetcher == null) {
            this._config.downstreamServicesFetcher = new FSBasedDownstreamServicesFetcher(this._config.fsBasePath, this._config.d2ServicePath);
        }
        if (this._config.jmxManager == null) {
            this._config.jmxManager = new NoOpJmxManager();
        }
        if (this._config.d2ServicePath == null || this._config.d2ServicePath.isEmpty()) {
            this._config.d2ServicePath = "services";
        }
        Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories = this.createDefaultLoadBalancerStrategyFactories();
        D2ClientConfig cfg = new D2ClientConfig(this._config.zkHosts, this._config.zkSessionTimeoutInMs, this._config.zkStartupTimeoutInMs, this._config.lbWaitTimeout, this._config.lbWaitUnit, this._config.flagFile, this._config.basePath, this._config.fsBasePath, this._config.componentFactory, transportClientFactories, this._config.lbWithFacilitiesFactory, this._config.sslContext, this._config.sslParameters, this._config.isSSLEnabled, this._config.shutdownAsynchronously, this._config.isSymlinkAware, this._config.clientServicesConfig, this._config.d2ServicePath, this._config.useNewEphemeralStoreWatcher, this._config.healthCheckOperations, this._config._executorService, this._config.retry, this._config.restRetryEnabled, this._config.streamRetryEnabled, this._config.retryLimit, this._config.retryUpdateIntervalMs, this._config.retryAggregatedIntervalNum, this._config.warmUp, this._config.warmUpTimeoutSeconds, this._config.warmUpConcurrentRequests, this._config.downstreamServicesFetcher, this._config.backupRequestsEnabled, this._config.backupRequestsStrategyStatsConsumer, this._config.backupRequestsLatencyNotificationInterval, this._config.backupRequestsLatencyNotificationIntervalUnit, this._config.enableBackupRequestsClientAsync, this._config._backupRequestsExecutorService, this._config.eventEmitter, this._config.partitionAccessorRegistry, this._config.zooKeeperDecorator, this._config.enableSaveUriDataOnDisk, loadBalancerStrategyFactories, this._config.requestTimeoutHandlerEnabled, this._config.sslSessionValidatorFactory, this._config.zkConnectionToUseForLB, this._config.startUpExecutorService, this._config.jmxManager, this._config.d2JmxManagerPrefix, this._config.zookeeperReadWindowMs, this._config.enableRelativeLoadBalancer, this._config.deterministicSubsettingMetadataProvider, this._config.canaryDistributionProvider, this._config.enableClusterFailout, this._config.failoutConfigProviderFactory, this._config.failoutRedirectStrategy);
        LoadBalancerWithFacilitiesFactory loadBalancerFactory = this._config.lbWithFacilitiesFactory == null ? new ZKFSLoadBalancerWithFacilitiesFactory() : this._config.lbWithFacilitiesFactory;
        LoadBalancerWithFacilities loadBalancer = loadBalancerFactory.create(cfg);
        D2Client d2Client = new DynamicClient(loadBalancer, loadBalancer, this._restOverStream);
        if (this._config.requestTimeoutHandlerEnabled) {
            d2Client = new RequestTimeoutClient(d2Client, loadBalancer, this._config._executorService);
        }
        if (this._config.backupRequestsEnabled) {
            ScheduledExecutorService executor = this._config._backupRequestsExecutorService;
            if (executor == null) {
                LOG.warn("Backup Requests Executor not configured, creating one with core pool size equal to: " + Runtime.getRuntime().availableProcessors());
                executor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new NamedThreadFactory("Backup Requests Executor"));
                executorsToShutDown.add(executor);
            }
            d2Client = new BackupRequestsClient(d2Client, loadBalancer, executor, this._config.backupRequestsStrategyStatsConsumer, this._config.backupRequestsLatencyNotificationInterval, this._config.backupRequestsLatencyNotificationIntervalUnit, this._config.enableBackupRequestsClientAsync);
        }
        if (this._config.retry) {
            d2Client = new RetryClient(d2Client, loadBalancer, this._config.retryLimit, this._config.retryUpdateIntervalMs, this._config.retryAggregatedIntervalNum, (Clock)SystemClock.instance(), true, true);
        } else if (this._config.restRetryEnabled || this._config.streamRetryEnabled) {
            d2Client = new RetryClient(d2Client, loadBalancer, this._config.retryLimit, this._config.retryUpdateIntervalMs, this._config.retryAggregatedIntervalNum, (Clock)SystemClock.instance(), this._config.restRetryEnabled, this._config.streamRetryEnabled);
        }
        if (this._config.enableClusterFailout) {
            if (this._config.failoutRedirectStrategy == null) {
                LOG.warn("A URI rewrite strategy is required for failout.");
            } else {
                LOG.info("Enabling D2Client failout support");
                d2Client = new FailoutClient(d2Client, loadBalancer, this._config.failoutRedirectStrategy);
            }
        }
        if (this._config.clientFactories != transportClientFactories) {
            d2Client = new TransportClientFactoryAwareD2Client(d2Client, transportClientFactories.values());
        }
        if (executorsToShutDown.size() > 0) {
            d2Client = new ExecutorShutdownAwareD2Client(d2Client, executorsToShutDown);
        }
        return d2Client;
    }

    public D2ClientBuilder setZkHosts(String zkHosts) {
        this._config.zkHosts = zkHosts;
        return this;
    }

    public D2ClientBuilder setZkSessionTimeout(long zkSessionTimeout, TimeUnit unit) {
        this._config.zkSessionTimeoutInMs = unit.toMillis(zkSessionTimeout);
        return this;
    }

    public D2ClientBuilder setZkStartupTimeout(long zkStartupTimeout, TimeUnit unit) {
        this._config.zkStartupTimeoutInMs = unit.toMillis(zkStartupTimeout);
        return this;
    }

    public D2ClientBuilder setLbWaitTimeout(long lbWaitTimeout, TimeUnit unit) {
        this._config.lbWaitTimeout = lbWaitTimeout;
        this._config.lbWaitUnit = unit;
        return this;
    }

    public D2ClientBuilder setFlagFile(String flagFile) {
        this._config.flagFile = flagFile;
        return this;
    }

    public D2ClientBuilder setBasePath(String basePath) {
        this._config.basePath = basePath;
        return this;
    }

    public D2ClientBuilder setFsBasePath(String fsBasePath) {
        this._config.fsBasePath = fsBasePath;
        return this;
    }

    public D2ClientBuilder setComponentFactory(ZKFSTogglingLoadBalancerFactoryImpl.ComponentFactory componentFactory) {
        this._config.componentFactory = componentFactory;
        return this;
    }

    public D2ClientBuilder setSSLContext(SSLContext sslContext) {
        this._config.sslContext = sslContext;
        return this;
    }

    public D2ClientBuilder setSSLParameters(SSLParameters sslParameters) {
        this._config.sslParameters = sslParameters;
        return this;
    }

    public D2ClientBuilder setIsSSLEnabled(boolean isSSLEnabled) {
        this._config.isSSLEnabled = isSSLEnabled;
        return this;
    }

    public D2ClientBuilder setShutdownAsynchronously(boolean shutdownAsynchronously) {
        this._config.shutdownAsynchronously = shutdownAsynchronously;
        return this;
    }

    public D2ClientBuilder setIsSymlinkAware(boolean isSymlinkAware) {
        this._config.isSymlinkAware = isSymlinkAware;
        return this;
    }

    public D2ClientBuilder setClientServicesConfig(Map<String, Map<String, Object>> clientServicesConfig) {
        this._config.clientServicesConfig = clientServicesConfig;
        return this;
    }

    public D2ClientBuilder setD2ServicePath(String d2ServicePath) {
        this._config.d2ServicePath = d2ServicePath;
        return this;
    }

    public D2ClientBuilder setHealthCheckOperations(HealthCheckOperations healthCheckOperations) {
        this._config.healthCheckOperations = healthCheckOperations;
        return this;
    }

    public D2ClientBuilder setExecutorService(ScheduledExecutorService executorService) {
        this._config._executorService = executorService;
        return this;
    }

    public D2ClientBuilder setBackupRequestsExecutorService(ScheduledExecutorService executorService) {
        this._config._backupRequestsExecutorService = executorService;
        return this;
    }

    public D2ClientBuilder setRetry(boolean retry) {
        this._config.retry = retry;
        return this;
    }

    public D2ClientBuilder setRestRetryEnabled(boolean restRetryEnabled) {
        this._config.restRetryEnabled = restRetryEnabled;
        return this;
    }

    public D2ClientBuilder setStreamRetryEnabled(boolean streamRetryEnabled) {
        this._config.streamRetryEnabled = streamRetryEnabled;
        return this;
    }

    public D2ClientBuilder setBackupRequestsEnabled(boolean backupRequestsEnabled) {
        this._config.backupRequestsEnabled = backupRequestsEnabled;
        return this;
    }

    public D2ClientBuilder setBackupRequestsStrategyStatsConsumer(BackupRequestsStrategyStatsConsumer backupRequestsStrategyStatsConsumer) {
        this._config.backupRequestsStrategyStatsConsumer = backupRequestsStrategyStatsConsumer;
        return this;
    }

    public D2ClientBuilder setBackupRequestsLatencyNotificationInterval(long backupRequestsLatencyNotificationInterval) {
        this._config.backupRequestsLatencyNotificationInterval = backupRequestsLatencyNotificationInterval;
        return this;
    }

    public D2ClientBuilder setBackupRequestsLatencyNotificationIntervalUnit(TimeUnit backupRequestsLatencyNotificationIntervalUnit) {
        this._config.backupRequestsLatencyNotificationIntervalUnit = backupRequestsLatencyNotificationIntervalUnit;
        return this;
    }

    public D2ClientBuilder setEnableBackupRequestsClientAsync(boolean enableBackupRequestsClientAsync) {
        this._config.enableBackupRequestsClientAsync = enableBackupRequestsClientAsync;
        return this;
    }

    public D2ClientBuilder setRetryLimit(int retryLimit) {
        this._config.retryLimit = retryLimit;
        return this;
    }

    public D2ClientBuilder setRetryUpdateIntervalMs(long retryUpdateIntervalMs) {
        this._config.retryUpdateIntervalMs = retryUpdateIntervalMs;
        return this;
    }

    public D2ClientBuilder setRetryAggregatedIntervalNum(int retryAggregatedIntervalNum) {
        this._config.retryAggregatedIntervalNum = retryAggregatedIntervalNum;
        return this;
    }

    public D2ClientBuilder setEventEmitter(EventEmitter eventEmitter) {
        this._config.eventEmitter = eventEmitter;
        return this;
    }

    public D2ClientBuilder setClientFactories(Map<String, TransportClientFactory> clientFactories) {
        this._config.clientFactories = clientFactories;
        return this;
    }

    public D2ClientBuilder setLoadBalancerWithFacilitiesFactory(LoadBalancerWithFacilitiesFactory lbWithFacilitiesFactory) {
        this._config.lbWithFacilitiesFactory = lbWithFacilitiesFactory;
        return this;
    }

    public D2ClientBuilder setRestOverStream(boolean restOverStream) {
        this._restOverStream = restOverStream;
        return this;
    }

    public D2ClientBuilder setUseNewEphemeralStoreWatcher(boolean useNewEphemeralStoreWatcher) {
        this._config.useNewEphemeralStoreWatcher = useNewEphemeralStoreWatcher;
        return this;
    }

    public D2ClientBuilder setWarmUp(boolean warmUp) {
        this._config.warmUp = warmUp;
        return this;
    }

    public D2ClientBuilder setWarmUpTimeoutSeconds(int warmUpTimeoutSeconds) {
        this._config.warmUpTimeoutSeconds = warmUpTimeoutSeconds;
        return this;
    }

    public D2ClientBuilder setZookeeperReadWindowMs(int zookeeperReadWindowMs) {
        this._config.zookeeperReadWindowMs = zookeeperReadWindowMs;
        return this;
    }

    public D2ClientBuilder setWarmUpConcurrentRequests(int warmUpConcurrentRequests) {
        this._config.warmUpConcurrentRequests = warmUpConcurrentRequests;
        return this;
    }

    public D2ClientBuilder setDownstreamServicesFetcher(DownstreamServicesFetcher downstreamServicesFetcher) {
        this._config.downstreamServicesFetcher = downstreamServicesFetcher;
        return this;
    }

    public D2ClientBuilder setEnableSaveUriDataOnDisk(boolean enableSaveUriDataOnDisk) {
        this._config.enableSaveUriDataOnDisk = enableSaveUriDataOnDisk;
        return this;
    }

    public D2ClientBuilder setPartitionAccessorRegistry(PartitionAccessorRegistry registry) {
        this._config.partitionAccessorRegistry = registry;
        return this;
    }

    public D2ClientBuilder setZooKeeperDecorator(Function<ZooKeeper, ZooKeeper> zooKeeperDecorator) {
        this._config.zooKeeperDecorator = zooKeeperDecorator;
        return this;
    }

    public D2ClientBuilder setLoadBalancerStrategyFactories(Map<String, LoadBalancerStrategyFactory<?>> loadBalancerStrategyFactories) {
        this._config.loadBalancerStrategyFactories = loadBalancerStrategyFactories;
        return this;
    }

    public D2ClientBuilder setRequestTimeoutHandlerEnabled(boolean requestTimeoutHandlerEnabled) {
        this._config.requestTimeoutHandlerEnabled = requestTimeoutHandlerEnabled;
        return this;
    }

    public D2ClientBuilder setZKConnectionForloadBalancer(ZKPersistentConnection connection) {
        this._config.zkConnectionToUseForLB = connection;
        return this;
    }

    public D2ClientBuilder setSslSessionValidatorFactory(SslSessionValidatorFactory sslSessionValidatorFactory) {
        this._config.sslSessionValidatorFactory = (SslSessionValidatorFactory)ArgumentUtil.ensureNotNull((Object)sslSessionValidatorFactory, (String)"sslSessionValidatorFactor");
        return this;
    }

    public D2ClientBuilder setD2JmxManager(JmxManager d2JmxManager) {
        this._config.jmxManager = d2JmxManager;
        return this;
    }

    public D2ClientBuilder setD2JmxManagerPrefix(String d2JmxManagerPrefix) {
        this._config.d2JmxManagerPrefix = d2JmxManagerPrefix;
        return this;
    }

    public D2ClientBuilder setEnableRelativeLoadBalancer(boolean enableRelativeLoadBalancer) {
        this._config.enableRelativeLoadBalancer = enableRelativeLoadBalancer;
        return this;
    }

    public D2ClientBuilder setDeterministicSubsettingMetadataProvider(DeterministicSubsettingMetadataProvider provider) {
        this._config.deterministicSubsettingMetadataProvider = provider;
        return this;
    }

    public D2ClientBuilder setCanaryDistributionProvider(CanaryDistributionProvider provider) {
        this._config.canaryDistributionProvider = provider;
        return this;
    }

    public D2ClientBuilder setEnableClusterFailout(boolean enableClusterFailout) {
        this._config.enableClusterFailout = enableClusterFailout;
        return this;
    }

    public D2ClientBuilder setFailoutConfigProviderFactory(FailoutConfigProviderFactory failoutConfigProviderFactory) {
        this._config.failoutConfigProviderFactory = failoutConfigProviderFactory;
        return this;
    }

    public D2ClientBuilder setFailoutRedirectStrategy(FailoutRedirectStrategy failoutRedirectStrategy) {
        this._config.failoutRedirectStrategy = failoutRedirectStrategy;
        return this;
    }

    private Map<String, TransportClientFactory> createDefaultTransportClientFactories() {
        HashMap<String, TransportClientFactory> clientFactories = new HashMap<String, TransportClientFactory>();
        HttpClientFactory transportClientFactory = new HttpClientFactory.Builder().build();
        clientFactories.put("http", (TransportClientFactory)transportClientFactory);
        clientFactories.put("https", (TransportClientFactory)transportClientFactory);
        return clientFactories;
    }

    private Map<String, LoadBalancerStrategyFactory<?>> createDefaultLoadBalancerStrategyFactories() {
        HashMap loadBalancerStrategyFactories = new HashMap(this._config.loadBalancerStrategyFactories);
        RandomLoadBalancerStrategyFactory randomStrategyFactory = new RandomLoadBalancerStrategyFactory();
        loadBalancerStrategyFactories.putIfAbsent("random", randomStrategyFactory);
        DegraderLoadBalancerStrategyFactoryV3 degraderStrategyFactoryV3 = new DegraderLoadBalancerStrategyFactoryV3(this._config.healthCheckOperations, this._config._executorService, this._config.eventEmitter, Collections.emptyList());
        loadBalancerStrategyFactories.putIfAbsent("degrader", degraderStrategyFactoryV3);
        loadBalancerStrategyFactories.putIfAbsent("degraderV2", degraderStrategyFactoryV3);
        loadBalancerStrategyFactories.putIfAbsent("degraderV3", degraderStrategyFactoryV3);
        loadBalancerStrategyFactories.putIfAbsent("degraderV2_1", degraderStrategyFactoryV3);
        if (this._config.enableRelativeLoadBalancer) {
            RelativeLoadBalancerStrategyFactory relativeLoadBalancerStrategyFactory = new RelativeLoadBalancerStrategyFactory(this._config._executorService, this._config.healthCheckOperations, Collections.emptyList(), this._config.eventEmitter, (Clock)SystemClock.instance());
            loadBalancerStrategyFactories.putIfAbsent("relative", relativeLoadBalancerStrategyFactory);
        }
        return loadBalancerStrategyFactories;
    }

    private class ExecutorShutdownAwareD2Client
    extends D2ClientDelegator {
        private List<ScheduledExecutorService> _executors;

        ExecutorShutdownAwareD2Client(D2Client d2Client, List<ScheduledExecutorService> executors) {
            super(d2Client);
            this._executors = executors;
        }

        @Override
        public void shutdown(final Callback<None> callback) {
            this._d2Client.shutdown((Callback)new Callback<None>(){

                public void onError(Throwable e) {
                    ExecutorShutdownAwareD2Client.this._executors.forEach(ExecutorService::shutdown);
                    callback.onError(e);
                }

                public void onSuccess(None result) {
                    ExecutorShutdownAwareD2Client.this._executors.forEach(ExecutorService::shutdown);
                    callback.onSuccess((Object)result);
                }
            });
        }
    }

    private class TransportClientFactoryAwareD2Client
    extends D2ClientDelegator {
        private Collection<TransportClientFactory> _clientFactories;

        TransportClientFactoryAwareD2Client(D2Client d2Client, Collection<TransportClientFactory> clientFactories) {
            super(d2Client);
            this._clientFactories = clientFactories;
        }

        @Override
        public void shutdown(Callback<None> callback) {
            this._d2Client.shutdown(callback);
            for (TransportClientFactory clientFactory : this._clientFactories) {
                clientFactory.shutdown((Callback)new FutureCallback());
            }
        }
    }
}

