/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer;

import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.util.HostSet;
import com.linkedin.d2.balancer.util.HostToKeyMapper;
import com.linkedin.d2.balancer.util.MapKeyResult;
import com.linkedin.r2.message.RequestContext;
import java.net.URI;
import java.util.Collection;

public interface KeyMapper {
    public <K> MapKeyResult<URI, K> mapKeysV2(URI var1, Iterable<K> var2) throws ServiceUnavailableException;

    public <K> HostToKeyMapper<K> mapKeysV3(URI var1, Collection<K> var2, int var3) throws ServiceUnavailableException;

    public <K, S> HostToKeyMapper<K> mapKeysV3(URI var1, Collection<K> var2, int var3, S var4) throws ServiceUnavailableException;

    public HostSet getAllPartitionsMultipleHosts(URI var1, int var2) throws ServiceUnavailableException;

    public <S> HostSet getAllPartitionsMultipleHosts(URI var1, int var2, S var3) throws ServiceUnavailableException;

    public static class TargetHostHints {
        private static final String TARGET_HOST_KEY_NAME = "D2-KeyMapper-TargetHost";
        private static final String OTHER_HOST_ACCEPTABLE = "Other-Host-Acceptable";

        public static void setRequestContextTargetHost(RequestContext context, URI targetHost) {
            context.putLocalAttr(TARGET_HOST_KEY_NAME, (Object)targetHost);
        }

        public static URI getRequestContextTargetHost(RequestContext context) {
            return (URI)context.getLocalAttr(TARGET_HOST_KEY_NAME);
        }

        public static URI removeRequestContextTargetHost(RequestContext context) {
            return (URI)context.removeLocalAttr(TARGET_HOST_KEY_NAME);
        }

        public static void setRequestContextOtherHostAcceptable(RequestContext context, boolean acceptable) {
            context.putLocalAttr(OTHER_HOST_ACCEPTABLE, (Object)acceptable);
        }

        public static Boolean getRequestContextOtherHostAcceptable(RequestContext context) {
            return (Boolean)context.getLocalAttr(OTHER_HOST_ACCEPTABLE);
        }
    }
}

