/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import java.util.concurrent.ExecutionException;

public interface LoadBalancer {
    default public void getClient(Request request, RequestContext requestContext, Callback<TransportClient> clientCallback) {
        try {
            clientCallback.onSuccess((Object)this.getClient(request, requestContext));
        }
        catch (ServiceUnavailableException e) {
            clientCallback.onError((Throwable)((Object)e));
        }
    }

    default public void getLoadBalancedServiceProperties(String serviceName, Callback<ServiceProperties> clientCallback) {
        try {
            clientCallback.onSuccess((Object)this.getLoadBalancedServiceProperties(serviceName));
        }
        catch (ServiceUnavailableException e) {
            clientCallback.onError((Throwable)((Object)e));
        }
    }

    public void start(Callback<None> var1);

    public void shutdown(PropertyEventThread.PropertyEventShutdownCallback var1);

    default public TransportClient getClient(Request request, RequestContext requestContext) throws ServiceUnavailableException {
        FutureCallback callback = new FutureCallback();
        this.getClient(request, requestContext, (Callback<TransportClient>)callback);
        try {
            return (TransportClient)callback.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ServiceUnavailableException) {
                throw (ServiceUnavailableException)((Object)throwable);
            }
            throw new RuntimeException(e);
        }
    }

    default public ServiceProperties getLoadBalancedServiceProperties(String serviceName) throws ServiceUnavailableException {
        FutureCallback callback = new FutureCallback();
        this.getLoadBalancedServiceProperties(serviceName, (Callback<ServiceProperties>)callback);
        try {
            return (ServiceProperties)callback.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ServiceUnavailableException) {
                throw (ServiceUnavailableException)((Object)throwable);
            }
            throw new RuntimeException(e);
        }
    }
}

