/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancerClusterListener;
import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.FailoutProperties;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.subsetting.SubsettingState;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface LoadBalancerState {
    public boolean isListeningToCluster(String var1);

    public boolean isListeningToService(String var1);

    public void listenToService(String var1, LoadBalancerStateListenerCallback var2);

    public void listenToCluster(String var1, LoadBalancerStateListenerCallback var2);

    public void start(Callback<None> var1);

    public void shutdown(PropertyEventThread.PropertyEventShutdownCallback var1);

    public LoadBalancerStateItem<UriProperties> getUriProperties(String var1);

    public LoadBalancerStateItem<ClusterProperties> getClusterProperties(String var1);

    public LoadBalancerStateItem<FailoutProperties> getFailoutProperties(String var1);

    public LoadBalancerStateItem<PartitionAccessor> getPartitionAccessor(String var1);

    public LoadBalancerStateItem<ServiceProperties> getServiceProperties(String var1);

    public TrackerClient getClient(String var1, URI var2);

    public TransportClient getClient(String var1, String var2);

    public LoadBalancerStrategy getStrategy(String var1, String var2);

    public List<SchemeStrategyPair> getStrategiesForService(String var1, List<String> var2);

    default public SubsettingState.SubsetItem getClientsSubset(String serviceName, int minClusterSubsetSize, int partitionId, Map<URI, Double> possibleUris, long version) {
        return new SubsettingState.SubsetItem(false, false, possibleUris, Collections.emptySet());
    }

    default public void registerClusterListener(LoadBalancerClusterListener clusterListener) {
    }

    default public void unregisterClusterListener(LoadBalancerClusterListener clusterListener) {
    }

    public static class SchemeStrategyPair {
        private final String _scheme;
        private final LoadBalancerStrategy _strategy;

        public SchemeStrategyPair(String scheme, LoadBalancerStrategy strategy) {
            this._scheme = scheme;
            this._strategy = strategy;
        }

        public String getScheme() {
            return this._scheme;
        }

        public LoadBalancerStrategy getStrategy() {
            return this._strategy;
        }
    }

    public static class NullStateListenerCallback
    implements LoadBalancerStateListenerCallback {
        @Override
        public void done(int type, String name) {
        }
    }

    public static interface LoadBalancerStateListenerCallback {
        public static final int SERVICE = 0;
        public static final int CLUSTER = 1;

        public void done(int var1, String var2);
    }
}

