/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer;

import com.linkedin.d2.balancer.D2ClientConfig;
import com.linkedin.d2.balancer.LoadBalancerWithFacilities;
import com.linkedin.d2.balancer.LoadBalancerWithFacilitiesFactory;
import com.linkedin.d2.balancer.util.WarmUpLoadBalancer;
import com.linkedin.d2.balancer.zkfs.ZKFSComponentFactory;
import com.linkedin.d2.balancer.zkfs.ZKFSLoadBalancer;
import com.linkedin.d2.balancer.zkfs.ZKFSTogglingLoadBalancerFactoryImpl;
import com.linkedin.d2.jmx.D2ClientJmxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKFSLoadBalancerWithFacilitiesFactory
implements LoadBalancerWithFacilitiesFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ZKFSLoadBalancerWithFacilitiesFactory.class);

    @Override
    public LoadBalancerWithFacilities create(D2ClientConfig config) {
        ZKFSLoadBalancer zkfsLoadBalancer;
        LOG.info("Creating D2 LoadBalancer based on ZKFSLoadBalancerWithFacilitiesFactory");
        LoadBalancerWithFacilities balancer = zkfsLoadBalancer = new ZKFSLoadBalancer(config.zkHosts, (int)config.zkSessionTimeoutInMs, (int)config.zkStartupTimeoutInMs, this.createLoadBalancerFactory(config), config.flagFile, config.basePath, config.shutdownAsynchronously, config.isSymlinkAware, config._executorService, config.zooKeeperDecorator);
        if (config.warmUp) {
            balancer = new WarmUpLoadBalancer(balancer, zkfsLoadBalancer, config.startUpExecutorService, config.fsBasePath, config.d2ServicePath, config.downstreamServicesFetcher, config.warmUpTimeoutSeconds, config.warmUpConcurrentRequests);
        }
        return balancer;
    }

    private ZKFSLoadBalancer.TogglingLoadBalancerFactory createLoadBalancerFactory(D2ClientConfig config) {
        ZKFSTogglingLoadBalancerFactoryImpl.ComponentFactory loadBalancerComponentFactory = config.componentFactory == null ? new ZKFSComponentFactory() : config.componentFactory;
        D2ClientJmxManager d2ClientJmxManager = new D2ClientJmxManager(config.d2JmxManagerPrefix, config.jmxManager);
        return new ZKFSTogglingLoadBalancerFactoryImpl(loadBalancerComponentFactory, config.lbWaitTimeout, config.lbWaitUnit, config.basePath, config.fsBasePath, config.clientFactories, config.loadBalancerStrategyFactories, config.d2ServicePath, config.sslContext, config.sslParameters, config.isSSLEnabled, config.clientServicesConfig, config.useNewEphemeralStoreWatcher, config.partitionAccessorRegistry, config.enableSaveUriDataOnDisk, config.sslSessionValidatorFactory, d2ClientJmxManager, config.zookeeperReadWindowMs, config.deterministicSubsettingMetadataProvider, config.failoutConfigProviderFactory);
    }
}

