/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.backuprequests.BackupRequestsStrategyFromConfig;
import com.linkedin.d2.backuprequests.BackupRequestsStrategyStatsConsumer;
import com.linkedin.d2.backuprequests.BackupRequestsStrategyStatsProvider;
import com.linkedin.d2.backuprequests.TrackingBackupRequestsStrategy;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.D2ClientDelegator;
import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.LoadBalancer;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.data.ByteString;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.ByteStringWriter;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.FullEntityObserver;
import com.linkedin.r2.message.stream.entitystream.Observer;
import com.linkedin.r2.message.stream.entitystream.Writer;
import com.linkedin.r2.util.NamedThreadFactory;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.HdrHistogram.AbstractHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupRequestsClient
extends D2ClientDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(BackupRequestsClient.class);
    public static final String BACKUP_REQUEST_ATTRIBUTE_NAME = "BackupRequest";
    private final LoadBalancer _loadBalancer;
    private final ScheduledExecutorService _executorService;
    private final ScheduledThreadPoolExecutor _latenciesNotifierExecutor;
    private final ScheduledFuture<?> _latenciesNotifier;
    private final boolean _isD2Async;
    private final Map<String, Map<String, BackupRequestsStrategyFromConfig>> _strategies = new ConcurrentHashMap<String, Map<String, BackupRequestsStrategyFromConfig>>();
    private final Optional<BackupRequestsStrategyStatsConsumer> _statsConsumer;
    private final Map<FinalSweepLatencyNotification, FinalSweepLatencyNotification> _finalSweepLatencyNotification = new ConcurrentHashMap<FinalSweepLatencyNotification, FinalSweepLatencyNotification>();
    private final Map<String, List<Map<String, Object>>> _configs = new ConcurrentHashMap<String, List<Map<String, Object>>>();

    public BackupRequestsClient(D2Client d2Client, LoadBalancer loadBalancer, ScheduledExecutorService executorService, BackupRequestsStrategyStatsConsumer statsConsumer, long notifyLatencyInterval, TimeUnit notifyLatencyIntervalUnit, boolean isD2Async) {
        super(d2Client);
        this._loadBalancer = loadBalancer;
        this._executorService = executorService;
        this._statsConsumer = Optional.ofNullable(statsConsumer).map(BackupRequestsClient::toSafeConsumer);
        this._latenciesNotifierExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("backup-requests-latencies-notifier"));
        this._latenciesNotifierExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this._latenciesNotifierExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this._latenciesNotifierExecutor.setRemoveOnCancelPolicy(true);
        this._latenciesNotifier = this._latenciesNotifierExecutor.scheduleAtFixedRate(this::notifyLatencies, notifyLatencyInterval, notifyLatencyInterval, notifyLatencyIntervalUnit);
        this._isD2Async = isD2Async;
    }

    private void notifyLatencies() {
        try {
            this._strategies.forEach((serviceName, strategiesForOperations) -> strategiesForOperations.forEach((operation, strategy) -> strategy.getStrategy().ifPresent(st -> {
                this.notifyLatency((String)serviceName, (String)operation, (TrackingBackupRequestsStrategy)st);
                this._finalSweepLatencyNotification.remove(new FinalSweepLatencyNotification((String)serviceName, (String)operation, (TrackingBackupRequestsStrategy)st));
            })));
            this._finalSweepLatencyNotification.forEach((key, value) -> {
                this.notifyLatency(key.getServiceName(), key.getOperation(), key.getStrategy());
                this._finalSweepLatencyNotification.remove(key, value);
            });
        }
        catch (Throwable t) {
            LOG.error("Failed to notify latencies", t);
        }
    }

    private void notifyLatency(String serviceName, String operation, TrackingBackupRequestsStrategy strategy) {
        strategy.getLatencyWithoutBackup().harvest(histogram -> this.notifyLatency(serviceName, operation, (AbstractHistogram)histogram, false));
        strategy.getLatencyWithBackup().harvest(histogram -> this.notifyLatency(serviceName, operation, (AbstractHistogram)histogram, true));
    }

    private void notifyLatency(String serviceName, String operation, AbstractHistogram histogram, boolean withBackup) {
        this._statsConsumer.ifPresent(consumer -> consumer.latencyUpdate(serviceName, operation, histogram, withBackup));
    }

    @Override
    public Future<RestResponse> restRequest(RestRequest request) {
        return this.restRequest(request, new RequestContext());
    }

    @Override
    public Future<RestResponse> restRequest(RestRequest request, RequestContext requestContext) {
        FutureCallback future = new FutureCallback();
        this.restRequest(request, requestContext, (Callback<RestResponse>)future);
        return future;
    }

    @Override
    public void restRequest(RestRequest request, Callback<RestResponse> callback) {
        this.restRequest(request, new RequestContext(), callback);
    }

    @Override
    public void restRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        if (this._isD2Async) {
            this.requestAsync(request, requestContext, (arg_0, arg_1, arg_2) -> ((D2Client)this._d2Client).restRequest(arg_0, arg_1, arg_2), callback);
            return;
        }
        this._d2Client.restRequest(request, requestContext, this.decorateCallbackSync(request, requestContext, (arg_0, arg_1, arg_2) -> ((D2Client)this._d2Client).restRequest(arg_0, arg_1, arg_2), callback));
    }

    Optional<TrackingBackupRequestsStrategy> getStrategyAfterUpdate(String serviceName, String operation) {
        BackupRequestsStrategyFromConfig backupRequestsStrategyFromConfig;
        Map<String, BackupRequestsStrategyFromConfig> strategiesForOperation = this._strategies.get(serviceName);
        if (strategiesForOperation != null && (backupRequestsStrategyFromConfig = strategiesForOperation.get(operation)) != null) {
            return backupRequestsStrategyFromConfig.getStrategy();
        }
        LOG.debug("No backup requests strategy found");
        return Optional.empty();
    }

    private void updateServiceProperties(String serviceName, ServiceProperties serviceProperties) {
        List<Map<String, Object>> existing = this._configs.get(serviceName);
        if (serviceProperties != null && existing != serviceProperties.getBackupRequests()) {
            this.update(serviceName, serviceProperties.getBackupRequests());
            this._configs.put(serviceName, serviceProperties.getBackupRequests());
        }
    }

    private <R extends Request, T> void requestAsync(final R request, final RequestContext requestContext, final DecoratorClient<R, T> client, final Callback<T> callback) {
        final String serviceName = LoadBalancerUtil.getServiceNameFromUri(request.getURI());
        Object operationObject = requestContext.getLocalAttr("OPERATION");
        if (operationObject == null) {
            client.doRequest(request, requestContext, callback);
            return;
        }
        final String operation = operationObject.toString();
        Callback<Optional<TrackingBackupRequestsStrategy>> maybeStrategyCallback = new Callback<Optional<TrackingBackupRequestsStrategy>>(){

            public void onError(Throwable e) {
                LOG.error("Error attempting to use backup requests, falling back to request without a backup", e);
                client.doRequest(request, requestContext, callback);
            }

            public void onSuccess(Optional<TrackingBackupRequestsStrategy> maybeStrategy) {
                if (maybeStrategy.isPresent()) {
                    Callback decoratedCallback = BackupRequestsClient.this.decorateCallbackWithBackupRequest(request, requestContext, client, callback, maybeStrategy.get(), serviceName, operation);
                    client.doRequest(request, requestContext, decoratedCallback);
                } else {
                    client.doRequest(request, requestContext, callback);
                }
            }
        };
        this.getStrategyAsync(serviceName, operation, maybeStrategyCallback);
    }

    private Optional<TrackingBackupRequestsStrategy> getStrategySync(String serviceName, String operation) {
        try {
            ServiceProperties serviceProperties = this._loadBalancer.getLoadBalancedServiceProperties(serviceName);
            this.updateServiceProperties(serviceName, serviceProperties);
        }
        catch (ServiceUnavailableException e) {
            LOG.debug("Failed to fetch backup requests strategy ", (Throwable)((Object)e));
        }
        return this.getStrategyAfterUpdate(serviceName, operation);
    }

    void getStrategyAsync(final String serviceName, final String operation, final Callback<Optional<TrackingBackupRequestsStrategy>> callback) {
        Callback<ServiceProperties> servicePropertiesCallback = new Callback<ServiceProperties>(){

            public void onError(Throwable e) {
                LOG.debug("Failed to fetch backup requests strategy", e);
                callback.onSuccess(Optional.empty());
            }

            public void onSuccess(ServiceProperties serviceProperties) {
                BackupRequestsClient.this.updateServiceProperties(serviceName, serviceProperties);
                Optional<TrackingBackupRequestsStrategy> maybeStrategy = BackupRequestsClient.this.getStrategyAfterUpdate(serviceName, operation);
                callback.onSuccess(maybeStrategy);
            }
        };
        this._loadBalancer.getLoadBalancedServiceProperties(serviceName, servicePropertiesCallback);
    }

    private void update(String serviceName, List<Map<String, Object>> backupRequestsConfigs) {
        Map<String, BackupRequestsStrategyFromConfig> strategiesForOperation = this.getOrCreateStrategiesForOperation(serviceName);
        Set operationsInNewConfig = backupRequestsConfigs.stream().map(config -> this.updateStrategy(serviceName, (Map<String, Object>)config, strategiesForOperation)).collect(Collectors.toSet());
        Set<Map.Entry> toRemove = strategiesForOperation.entrySet().stream().filter(entry -> !operationsInNewConfig.contains(entry.getKey())).collect(Collectors.toSet());
        toRemove.forEach(entry -> ((BackupRequestsStrategyFromConfig)entry.getValue()).getStrategy().ifPresent(strategy -> {
            String operation = (String)entry.getKey();
            strategiesForOperation.remove(operation);
            this._statsConsumer.ifPresent(consumer -> consumer.removeStatsProvider(serviceName, operation, (BackupRequestsStrategyStatsProvider)strategy));
            FinalSweepLatencyNotification fsln = new FinalSweepLatencyNotification(serviceName, operation, (TrackingBackupRequestsStrategy)strategy);
            this._finalSweepLatencyNotification.put(fsln, fsln);
        }));
    }

    private Map<String, BackupRequestsStrategyFromConfig> getOrCreateStrategiesForOperation(String serviceName) {
        Map<String, BackupRequestsStrategyFromConfig> existing;
        Map<String, BackupRequestsStrategyFromConfig> strategiesForOperation = this._strategies.get(serviceName);
        if (strategiesForOperation == null && (existing = this._strategies.putIfAbsent(serviceName, strategiesForOperation = new ConcurrentHashMap<String, BackupRequestsStrategyFromConfig>())) != null) {
            strategiesForOperation = existing;
        }
        return strategiesForOperation;
    }

    private String updateStrategy(String serviceName, Map<String, Object> config, Map<String, BackupRequestsStrategyFromConfig> strategiesForOperation) {
        String operation = (String)config.get("operation");
        strategiesForOperation.compute(operation, (op, existing) -> this.updateBackupRequestsStrategyFromConfig(serviceName, operation, (BackupRequestsStrategyFromConfig)existing, config));
        return operation;
    }

    private BackupRequestsStrategyFromConfig updateBackupRequestsStrategyFromConfig(String serviceName, String operation, BackupRequestsStrategyFromConfig existing, Map<String, Object> config) {
        if (existing == null) {
            BackupRequestsStrategyFromConfig newOne = new BackupRequestsStrategyFromConfig(config);
            newOne.getStrategy().ifPresent(statsProvider -> this._statsConsumer.ifPresent(consumer -> consumer.addStatsProvider(serviceName, operation, (BackupRequestsStrategyStatsProvider)statsProvider)));
            return newOne;
        }
        BackupRequestsStrategyFromConfig newOne = existing.update(config);
        if (newOne != existing) {
            this._statsConsumer.ifPresent(consumer -> {
                existing.getStrategy().ifPresent(statsProvider -> {
                    consumer.removeStatsProvider(serviceName, operation, (BackupRequestsStrategyStatsProvider)statsProvider);
                    FinalSweepLatencyNotification fsln = new FinalSweepLatencyNotification(serviceName, operation, (TrackingBackupRequestsStrategy)statsProvider);
                    this._finalSweepLatencyNotification.put(fsln, fsln);
                });
                newOne.getStrategy().ifPresent(statsProvider -> consumer.addStatsProvider(serviceName, operation, (BackupRequestsStrategyStatsProvider)statsProvider));
            });
        }
        return newOne;
    }

    @Override
    public void streamRequest(StreamRequest request, Callback<StreamResponse> callback) {
        this.streamRequest(request, new RequestContext(), callback);
    }

    @Override
    public void streamRequest(StreamRequest request, final RequestContext requestContext, Callback<StreamResponse> callback) {
        if (!BackupRequestsClient.isFullRequest(requestContext)) {
            this._d2Client.streamRequest(request, requestContext, callback);
            return;
        }
        if (!BackupRequestsClient.isBuffered(requestContext)) {
            FullEntityObserver observer = new FullEntityObserver((Callback)new Callback<ByteString>(){

                public void onError(Throwable e) {
                    LOG.warn("Failed to record request's entity for retrying backup request.");
                }

                public void onSuccess(ByteString result) {
                    requestContext.putLocalAttr("BACKUP_REQUEST_BUFFERED_BODY", (Object)result);
                }
            });
            request.getEntityStream().addObserver((Observer)observer);
        }
        if (this._isD2Async) {
            this.requestAsync(request, requestContext, (arg_0, arg_1, arg_2) -> ((D2Client)this._d2Client).streamRequest(arg_0, arg_1, arg_2), callback);
            return;
        }
        this._d2Client.streamRequest(request, requestContext, this.decorateCallbackSync(request, requestContext, (arg_0, arg_1, arg_2) -> ((D2Client)this._d2Client).streamRequest(arg_0, arg_1, arg_2), callback));
    }

    private <R extends Request, T> Callback<T> decorateCallbackSync(R request, RequestContext requestContext, DecoratorClient<R, T> client, Callback<T> callback) {
        try {
            String serviceName = LoadBalancerUtil.getServiceNameFromUri(request.getURI());
            Object operationObject = requestContext.getLocalAttr("OPERATION");
            if (operationObject != null) {
                String operation = operationObject.toString();
                Optional<TrackingBackupRequestsStrategy> strategy = this.getStrategySync(serviceName, operation);
                if (strategy.isPresent()) {
                    return this.decorateCallbackWithBackupRequest(request, requestContext, client, callback, strategy.get(), serviceName, operation);
                }
                return callback;
            }
            return callback;
        }
        catch (Throwable t) {
            LOG.error("Error attempting to use backup requests, falling back to request without a backup", t);
            return callback;
        }
    }

    private <R extends Request, T> Callback<T> decorateCallbackWithBackupRequest(R request, RequestContext requestContext, DecoratorClient<R, T> client, final Callback<T> callback, final TrackingBackupRequestsStrategy strategy, final String serviceName, final String operation) {
        Optional<Long> delayNano;
        final long startNano = System.nanoTime();
        URI targetHostUri = KeyMapper.TargetHostHints.getRequestContextTargetHost(requestContext);
        Boolean backupRequestAcceptable = KeyMapper.TargetHostHints.getRequestContextOtherHostAcceptable(requestContext);
        if ((targetHostUri == null || backupRequestAcceptable != null && backupRequestAcceptable.booleanValue()) && (delayNano = strategy.getTimeUntilBackupRequestNano()).isPresent()) {
            return new DecoratedCallback(this, request, requestContext, client, callback, strategy, delayNano.get().longValue(), this._executorService, startNano, serviceName, operation);
        }
        return new Callback<T>(){

            public void onSuccess(T result) {
                this.recordLatency();
                callback.onSuccess(result);
            }

            private void recordLatency() {
                long latency = System.nanoTime() - startNano;
                strategy.recordCompletion(latency);
                strategy.getLatencyWithoutBackup().record(latency, histogram -> BackupRequestsClient.this.notifyLatency(serviceName, operation, histogram, false));
                strategy.getLatencyWithBackup().record(latency, histogram -> BackupRequestsClient.this.notifyLatency(serviceName, operation, histogram, true));
            }

            public void onError(Throwable e) {
                if (!(e instanceof ServiceUnavailableException)) {
                    this.recordLatency();
                }
                callback.onError(e);
            }
        };
    }

    @Override
    public void shutdown(Callback<None> callback) {
        this._latenciesNotifier.cancel(false);
        this._latenciesNotifierExecutor.shutdown();
        this._d2Client.shutdown(callback);
    }

    private static BackupRequestsStrategyStatsConsumer toSafeConsumer(final BackupRequestsStrategyStatsConsumer consumer) {
        return new BackupRequestsStrategyStatsConsumer(){

            @Override
            public void removeStatsProvider(String service, String operation, BackupRequestsStrategyStatsProvider statsProvider) {
                try {
                    consumer.removeStatsProvider(service, operation, statsProvider);
                }
                catch (Throwable t) {
                    LOG.error("Error when calling BackupRequestsStrategyStatsConsumer", t);
                }
            }

            @Override
            public void addStatsProvider(String service, String operation, BackupRequestsStrategyStatsProvider statsProvider) {
                try {
                    consumer.addStatsProvider(service, operation, statsProvider);
                }
                catch (Throwable t) {
                    LOG.error("Error when calling BackupRequestsStrategyStatsConsumer", t);
                }
            }

            @Override
            public void latencyUpdate(String service, String operation, AbstractHistogram histogram, boolean withBackup) {
                try {
                    consumer.latencyUpdate(service, operation, histogram, withBackup);
                }
                catch (Throwable t) {
                    LOG.error("Error when calling BackupRequestsStrategyStatsConsumer", t);
                }
            }
        };
    }

    private static boolean isFullRequest(RequestContext requestContext) {
        Object isFullRequest = requestContext.getLocalAttr("IS_FULL_REQUEST");
        return isFullRequest != null && (Boolean)isFullRequest != false;
    }

    private static boolean isBuffered(RequestContext requestContext) {
        Object bufferedBody = requestContext.getLocalAttr("BACKUP_REQUEST_BUFFERED_BODY");
        return bufferedBody != null;
    }

    private static class FinalSweepLatencyNotification {
        private final String _serviceName;
        private final String _operation;
        private final TrackingBackupRequestsStrategy _strategy;

        public FinalSweepLatencyNotification(String serviceName, String operation, TrackingBackupRequestsStrategy strategy) {
            this._serviceName = serviceName;
            this._operation = operation;
            this._strategy = strategy;
        }

        public String getServiceName() {
            return this._serviceName;
        }

        public String getOperation() {
            return this._operation;
        }

        public TrackingBackupRequestsStrategy getStrategy() {
            return this._strategy;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._operation == null ? 0 : this._operation.hashCode());
            result = 31 * result + (this._serviceName == null ? 0 : this._serviceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FinalSweepLatencyNotification other = (FinalSweepLatencyNotification)obj;
            if (this._operation == null ? other._operation != null : !this._operation.equals(other._operation)) {
                return false;
            }
            return !(this._serviceName == null ? other._serviceName != null : !this._serviceName.equals(other._serviceName));
        }
    }

    private class DecoratedCallback<R extends Request, T>
    implements Callback<T> {
        private final AtomicBoolean _done = new AtomicBoolean(false);
        private final R _request;
        private final RequestContext _requestContext;
        private final RequestContext _backupRequestContext;
        private final DecoratorClient<R, T> _client;
        private final Callback<T> _callback;
        private final TrackingBackupRequestsStrategy _strategy;
        private final long _startNano;
        private final String _serviceName;
        private final String _operation;
        final /* synthetic */ BackupRequestsClient this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public DecoratedCallback(R strategy, RequestContext delayNano, DecoratorClient<R, T> decoratorClient, Callback<T> executorService, TrackingBackupRequestsStrategy startNano, long l2, ScheduledExecutorService operation, long l3, String string, String string2) {
            void serviceName;
            void client;
            void request;
            this.this$0 = (BackupRequestsClient)l;
            this._startNano = startNano;
            this._request = request;
            this._requestContext = requestContext;
            this._backupRequestContext = requestContext.clone();
            this._backupRequestContext.putLocalAttr(BackupRequestsClient.BACKUP_REQUEST_ATTRIBUTE_NAME, (Object)((long)delayNano));
            KeyMapper.TargetHostHints.removeRequestContextTargetHost(this._backupRequestContext);
            this._client = client;
            this._callback = callback;
            this._strategy = strategy;
            this._serviceName = serviceName;
            this._operation = operation;
            executorService.schedule(this::maybeSendBackupRequest, (long)delayNano, TimeUnit.NANOSECONDS);
        }

        private void maybeSendBackupRequest() {
            Set<URI> exclusionSet = LoadBalancerStrategy.ExcludedHostHints.getRequestContextExcludedHosts(this._requestContext);
            if (exclusionSet != null) {
                exclusionSet.forEach(uri -> LoadBalancerStrategy.ExcludedHostHints.addRequestContextExcludedHost(this._backupRequestContext, uri));
                if (this._request instanceof StreamRequest && !BackupRequestsClient.isBuffered(this._requestContext)) {
                    return;
                }
                if (!this._done.get() && this._strategy.isBackupRequestAllowed()) {
                    Object request = this._request;
                    if (this._request instanceof StreamRequest) {
                        StreamRequest req = (StreamRequest)this._request;
                        req = req.builder().build(EntityStreams.newEntityStream((Writer)new ByteStringWriter((ByteString)this._requestContext.getLocalAttr("BACKUP_REQUEST_BUFFERED_BODY"))));
                        request = req;
                        if (!BackupRequestsClient.isBuffered(this._backupRequestContext)) {
                            this._backupRequestContext.putLocalAttr("BACKUP_REQUEST_BUFFERED_BODY", this._requestContext.getLocalAttr("BACKUP_REQUEST_BUFFERED_BODY"));
                        }
                    }
                    this._client.doRequest(request, this._backupRequestContext, new Callback<T>(){

                        public void onSuccess(T result) {
                            if (DecoratedCallback.this._done.compareAndSet(false, true)) {
                                this.completeBackup();
                                DecoratedCallback.this._callback.onSuccess(result);
                            }
                        }

                        public void onError(Throwable e) {
                            if (!(e instanceof ServiceUnavailableException) && DecoratedCallback.this._done.compareAndSet(false, true)) {
                                this.completeBackup();
                                DecoratedCallback.this._callback.onError(e);
                            }
                        }

                        private void completeBackup() {
                            DecoratedCallback.this._strategy.backupRequestSuccess();
                            DecoratedCallback.this._strategy.getLatencyWithBackup().record(System.nanoTime() - DecoratedCallback.this._startNano, histogram -> DecoratedCallback.this.this$0.notifyLatency(DecoratedCallback.this._serviceName, DecoratedCallback.this._operation, histogram, true));
                        }
                    });
                }
            }
        }

        public void onSuccess(T result) {
            this.trackingCompletion(() -> this._callback.onSuccess(result));
        }

        private void trackingCompletion(Runnable completion) {
            long latency = System.nanoTime() - this._startNano;
            this._strategy.recordCompletion(latency);
            if (this._done.compareAndSet(false, true)) {
                this._strategy.getLatencyWithBackup().record(latency, histogram -> this.this$0.notifyLatency(this._serviceName, this._operation, histogram, true));
                this._strategy.getLatencyWithoutBackup().record(latency, histogram -> this.this$0.notifyLatency(this._serviceName, this._operation, histogram, false));
                completion.run();
            } else {
                this._strategy.getLatencyWithoutBackup().record(latency, histogram -> this.this$0.notifyLatency(this._serviceName, this._operation, histogram, false));
            }
        }

        public void onError(Throwable e) {
            this.trackingCompletion(() -> this._callback.onError(e));
        }
    }

    @FunctionalInterface
    private static interface DecoratorClient<R, T> {
        public void doRequest(R var1, RequestContext var2, Callback<T> var3);
    }
}

