/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.d2.balancer.clients.DegraderTrackerClient;
import com.linkedin.d2.balancer.clients.TrackerClientImpl;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import com.linkedin.util.degrader.Degrader;
import com.linkedin.util.degrader.DegraderControl;
import com.linkedin.util.degrader.DegraderImpl;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DegraderTrackerClientImpl
extends TrackerClientImpl
implements DegraderTrackerClient {
    private final Map<Integer, PartitionState> _partitionStates;

    public DegraderTrackerClientImpl(URI uri, Map<Integer, PartitionData> partitionDataMap, TransportClient wrappedClient) {
        this(uri, partitionDataMap, wrappedClient, (Clock)SystemClock.instance(), null, 5000L, DEFAULT_ERROR_STATUS_PATTERN);
    }

    public DegraderTrackerClientImpl(URI uri, Map<Integer, PartitionData> partitionDataMap, TransportClient wrappedClient, Clock clock, DegraderImpl.Config config) {
        this(uri, partitionDataMap, wrappedClient, clock, config, 5000L, TrackerClientImpl.DEFAULT_ERROR_STATUS_PATTERN, false);
    }

    public DegraderTrackerClientImpl(URI uri, Map<Integer, PartitionData> partitionDataMap, TransportClient wrappedClient, Clock clock, DegraderImpl.Config config, long interval, Pattern errorStatusPattern) {
        this(uri, partitionDataMap, wrappedClient, clock, config, interval, errorStatusPattern, false);
    }

    public DegraderTrackerClientImpl(URI uri, Map<Integer, PartitionData> partitionDataMap, TransportClient wrappedClient, Clock clock, DegraderImpl.Config config, long interval, Pattern errorStatusPattern, boolean doNotSlowStart) {
        super(uri, partitionDataMap, wrappedClient, clock, interval, status -> errorStatusPattern.matcher(Integer.toString(status)).matches(), true, doNotSlowStart, false);
        if (config == null) {
            config = new DegraderImpl.Config();
        }
        config.setCallTracker(this._callTracker);
        config.setClock(clock);
        config.setOverrideDropRate(Double.valueOf(0.0));
        if (doNotSlowStart) {
            config.setInitialDropRate(0.0);
        }
        int mapSize = partitionDataMap.size();
        HashMap<Integer, PartitionState> partitionStates = new HashMap<Integer, PartitionState>(mapSize * 2);
        config.setName("TrackerClient Degrader: " + uri);
        DegraderImpl degrader = new DegraderImpl(config);
        DegraderControl degraderControl = new DegraderControl(degrader);
        for (Map.Entry<Integer, PartitionData> entry : partitionDataMap.entrySet()) {
            int partitionId = entry.getKey();
            PartitionState partitionState = new PartitionState(entry.getValue(), (Degrader)degrader, degraderControl);
            partitionStates.put(partitionId, partitionState);
        }
        this._partitionStates = Collections.unmodifiableMap(partitionStates);
    }

    @Override
    public Degrader getDegrader(int partitionId) {
        return this.getPartitionState(partitionId).getDegrader();
    }

    @Override
    public DegraderControl getDegraderControl(int partitionId) {
        return this.getPartitionState(partitionId).getDegraderControl();
    }

    private PartitionState getPartitionState(int partitionId) {
        PartitionState partitionState = this._partitionStates.get(partitionId);
        if (partitionState == null) {
            String msg = "PartitionState does not exist for partitionId: " + partitionId + ". The current states are " + this._partitionStates;
            throw new IllegalStateException(msg);
        }
        return partitionState;
    }

    private class PartitionState {
        private final Degrader _degrader;
        private final DegraderControl _degraderControl;
        private final PartitionData _partitionData;

        PartitionState(PartitionData partitionData, Degrader degrader, DegraderControl degraderControl) {
            this._partitionData = partitionData;
            this._degrader = degrader;
            this._degraderControl = degraderControl;
        }

        Degrader getDegrader() {
            return this._degrader;
        }

        DegraderControl getDegraderControl() {
            return this._degraderControl;
        }

        PartitionData getPartitionData() {
            return this._partitionData;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{_partitionData = ");
            sb.append(this._partitionData);
            sb.append(", _degrader = " + this._degrader);
            sb.append(", degraderMinCallCount = " + this._degraderControl.getMinCallCount());
            sb.append("}");
            return sb.toString();
        }
    }
}

