/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.SuccessCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.Facilities;
import com.linkedin.d2.balancer.LoadBalancer;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.timing.TimingContextUtil;
import com.linkedin.r2.message.timing.TimingImportance;
import com.linkedin.r2.message.timing.TimingKey;
import com.linkedin.r2.transport.common.AbstractClient;
import com.linkedin.r2.transport.common.Client;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.client.TransportClientAdapter;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClient
extends AbstractClient
implements D2Client {
    private static final Logger _log = LoggerFactory.getLogger(DynamicClient.class);
    private static final TimingKey TIMING_KEY = TimingKey.registerNewKey((String)"d2-total", (TimingImportance)TimingImportance.MEDIUM);
    private final LoadBalancer _balancer;
    private final Facilities _facilities;
    private final boolean _restOverStream;

    public DynamicClient(LoadBalancer balancer, Facilities facilities) {
        this(balancer, facilities, false);
    }

    public DynamicClient(LoadBalancer balancer, Facilities facilities, boolean restOverStream) {
        this._balancer = balancer;
        this._facilities = facilities;
        this._restOverStream = restOverStream;
        LogUtil.debug(_log, "created dynamic client: ", this);
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        if (!this._restOverStream) {
            Callback<RestResponse> loggerCallback = DynamicClient.decorateLoggingCallback(callback, (Request)request, "rest");
            TimingContextUtil.markTiming((RequestContext)requestContext, (TimingKey)TIMING_KEY);
            this._balancer.getClient((Request)request, requestContext, this.getClientCallback((Request)request, requestContext, false, callback, (SuccessCallback<Client>)((SuccessCallback)client -> client.restRequest(request, requestContext, loggerCallback))));
        } else {
            super.restRequest(request, requestContext, callback);
        }
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Callback<StreamResponse> callback) {
        Callback<StreamResponse> loggerCallback = DynamicClient.decorateLoggingCallback(callback, (Request)request, "stream");
        this._balancer.getClient((Request)request, requestContext, this.getClientCallback((Request)request, requestContext, true, callback, (SuccessCallback<Client>)((SuccessCallback)client -> client.streamRequest(request, requestContext, loggerCallback))));
    }

    private Callback<TransportClient> getClientCallback(final Request request, final RequestContext requestContext, final boolean restOverStream, final Callback<? extends Response> callback, final SuccessCallback<Client> clientSuccessCallback) {
        return new Callback<TransportClient>(){

            public void onError(Throwable e) {
                TimingContextUtil.markTiming((RequestContext)requestContext, (TimingKey)TIMING_KEY);
                callback.onError(e);
                LogUtil.warn(_log, "unable to find service for: ", DynamicClient.extractLogInfo(request));
            }

            public void onSuccess(TransportClient client) {
                TimingContextUtil.markTiming((RequestContext)requestContext, (TimingKey)TIMING_KEY);
                if (client != null) {
                    clientSuccessCallback.onSuccess((Object)new TransportClientAdapter(client, restOverStream));
                } else {
                    callback.onError((Throwable)((Object)new ServiceUnavailableException("PEGA_1000. Unknown: " + request.getURI(), "got null client from load balancer")));
                }
            }
        };
    }

    public void start(Callback<None> callback) {
        _log.info("starting D2 client");
        this._balancer.start(callback);
    }

    public void shutdown(Callback<None> callback) {
        LogUtil.info(_log, "shutting down dynamic client");
        this._balancer.shutdown(() -> {
            LogUtil.info(_log, "dynamic client shutdown complete");
            callback.onSuccess((Object)None.none());
        });
        TimingKey.unregisterKey((TimingKey)TIMING_KEY);
    }

    @Override
    public Facilities getFacilities() {
        return this._facilities;
    }

    public void getMetadata(URI uri, final Callback<Map<String, Object>> callback) {
        if (this._balancer == null) {
            callback.onSuccess(Collections.emptyMap());
            return;
        }
        String serviceName = LoadBalancerUtil.getServiceNameFromUri(uri);
        this._balancer.getLoadBalancedServiceProperties(serviceName, new Callback<ServiceProperties>(){

            public void onError(Throwable e) {
                LogUtil.error(_log, e);
                callback.onSuccess(Collections.emptyMap());
            }

            public void onSuccess(ServiceProperties serviceProperties) {
                if (serviceProperties == null) {
                    callback.onSuccess(Collections.emptyMap());
                    return;
                }
                callback.onSuccess(Collections.unmodifiableMap(serviceProperties.getServiceMetadataProperties()));
            }
        });
    }

    private static <T> Callback<T> decorateLoggingCallback(final Callback<T> callback, Request request, final String type) {
        if (_log.isTraceEnabled()) {
            LogUtil.trace(_log, type + " request: ", request);
            return new Callback<T>(){

                public void onError(Throwable e) {
                    callback.onError(e);
                    LogUtil.trace(_log, type + " response error: ", e);
                }

                public void onSuccess(T result) {
                    callback.onSuccess(result);
                    LogUtil.trace(_log, type + " response success: ", result);
                }
            };
        }
        return callback;
    }

    private static String extractLogInfo(Request request) {
        return request.getClass().getName() + ": [Service: " + LoadBalancerUtil.getServiceNameFromUri(request.getURI()) + ", Method: " + request.getMethod() + "]";
    }
}

