/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.D2ClientDelegator;
import com.linkedin.d2.balancer.LoadBalancerWithFacilities;
import com.linkedin.d2.balancer.clients.FailoutRedirectStrategy;
import com.linkedin.d2.balancer.clusterfailout.FailoutConfig;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import java.net.URI;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoutClient
extends D2ClientDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(FailoutClient.class);
    private final FailoutRedirectStrategy _redirectStrategy;
    private final LoadBalancerWithFacilities _balancer;

    public FailoutClient(D2Client d2Client, LoadBalancerWithFacilities balancer, FailoutRedirectStrategy redirectStrategy) {
        super(d2Client);
        this._balancer = balancer;
        this._redirectStrategy = redirectStrategy;
    }

    @Override
    public Future<RestResponse> restRequest(RestRequest request) {
        return this.restRequest(request, new RequestContext());
    }

    @Override
    public Future<RestResponse> restRequest(RestRequest request, RequestContext requestContext) {
        FutureCallback future = new FutureCallback();
        this.restRequest(request, requestContext, (Callback<RestResponse>)future);
        return future;
    }

    @Override
    public void restRequest(RestRequest request, Callback<RestResponse> callback) {
        this.restRequest(request, new RequestContext(), callback);
    }

    @Override
    public void restRequest(final RestRequest request, final RequestContext requestContext, final Callback<RestResponse> callback) {
        this.determineRequestUri((Request)request, new Callback<URI>(){

            public void onError(Throwable e) {
                LOG.error("Failed to build request URI. Original request URI will be used.", e);
                FailoutClient.access$101(FailoutClient.this, request, requestContext, callback);
            }

            public void onSuccess(URI result) {
                RestRequest redirectedRequest = ((RestRequestBuilder)request.builder().setURI(result)).build();
                FailoutClient.access$201(FailoutClient.this, redirectedRequest, requestContext, callback);
            }
        });
        super.restRequest(request, requestContext, callback);
    }

    @Override
    public void streamRequest(StreamRequest request, Callback<StreamResponse> callback) {
        this.streamRequest(request, new RequestContext(), callback);
    }

    @Override
    public void streamRequest(final StreamRequest request, final RequestContext requestContext, final Callback<StreamResponse> callback) {
        this.determineRequestUri((Request)request, new Callback<URI>(){

            public void onError(Throwable e) {
                LOG.error("Failed to build request URI. Original request URI will be used.", e);
                FailoutClient.access$301(FailoutClient.this, request, requestContext, callback);
            }

            public void onSuccess(URI result) {
                StreamRequest redirectedRequest = ((StreamRequestBuilder)request.builder().setURI(result)).build(request.getEntityStream());
                FailoutClient.access$401(FailoutClient.this, redirectedRequest, requestContext, callback);
            }
        });
    }

    private void determineRequestUri(final Request request, final Callback<URI> callback) {
        String currentService = LoadBalancerUtil.getServiceNameFromUri(request.getURI());
        this._balancer.getLoadBalancedServiceProperties(currentService, new Callback<ServiceProperties>(){

            public void onError(Throwable e) {
                callback.onError(e);
            }

            public void onSuccess(ServiceProperties result) {
                String cluster = result.getClusterName();
                FailoutConfig config = FailoutClient.this._balancer.getClusterInfoProvider().getFailoutConfig(cluster);
                if (config != null && config.isFailedOut()) {
                    callback.onSuccess((Object)FailoutClient.this._redirectStrategy.redirect(config, request.getURI()));
                } else {
                    callback.onSuccess((Object)request.getURI());
                }
            }
        });
    }

    static /* synthetic */ void access$101(FailoutClient x0, RestRequest x1, RequestContext x2, Callback x3) {
        super.restRequest(x1, x2, (Callback<RestResponse>)x3);
    }

    static /* synthetic */ void access$201(FailoutClient x0, RestRequest x1, RequestContext x2, Callback x3) {
        super.restRequest(x1, x2, (Callback<RestResponse>)x3);
    }

    static /* synthetic */ void access$301(FailoutClient x0, StreamRequest x1, RequestContext x2, Callback x3) {
        super.streamRequest(x1, x2, (Callback<StreamResponse>)x3);
    }

    static /* synthetic */ void access$401(FailoutClient x0, StreamRequest x1, RequestContext x2, Callback x3) {
        super.streamRequest(x1, x2, (Callback<StreamResponse>)x3);
    }
}

