/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.MapUtil;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.D2ClientDelegator;
import com.linkedin.d2.balancer.LoadBalancer;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.http.client.TimeoutCallback;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTimeoutClient
extends D2ClientDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(RequestTimeoutClient.class);
    private final D2Client _d2Client;
    private final LoadBalancer _balancer;
    private final ScheduledExecutorService _scheduler;

    public RequestTimeoutClient(D2Client d2Client, LoadBalancer balancer, ScheduledExecutorService scheduler) {
        super(d2Client);
        this._d2Client = d2Client;
        this._balancer = balancer;
        this._scheduler = scheduler;
    }

    @Override
    public Future<RestResponse> restRequest(RestRequest request) {
        return this.restRequest(request, new RequestContext());
    }

    @Override
    public Future<RestResponse> restRequest(RestRequest request, RequestContext requestContext) {
        FutureCallback future = new FutureCallback();
        this.restRequest(request, requestContext, (Callback<RestResponse>)future);
        return future;
    }

    @Override
    public void restRequest(RestRequest request, Callback<RestResponse> callback) {
        this.restRequest(request, new RequestContext(), callback);
    }

    @Override
    public void restRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        Callback<RestResponse> transportCallback = this.decorateCallbackWithRequestTimeout(callback, (Request)request, requestContext);
        this._d2Client.restRequest(request, requestContext, transportCallback);
    }

    @Override
    public void streamRequest(StreamRequest request, Callback<StreamResponse> callback) {
        this.streamRequest(request, new RequestContext(), callback);
    }

    @Override
    public void streamRequest(StreamRequest request, RequestContext requestContext, Callback<StreamResponse> callback) {
        Callback<StreamResponse> transportCallback = this.decorateCallbackWithRequestTimeout(callback, (Request)request, requestContext);
        this._d2Client.streamRequest(request, requestContext, transportCallback);
    }

    private <RES> Callback<RES> decorateCallbackWithRequestTimeout(Callback<RES> callback, Request request, RequestContext requestContext) {
        Map<String, Object> transportClientProperties;
        String serviceName = LoadBalancerUtil.getServiceNameFromUri(request.getURI());
        try {
            transportClientProperties = this._balancer.getLoadBalancedServiceProperties(serviceName).getTransportClientProperties();
        }
        catch (ServiceUnavailableException e) {
            return callback;
        }
        int defaultRequestTimeout = (Integer)MapUtil.getWithDefault(transportClientProperties, (Object)"http.requestTimeout", (Object)1000, Integer.class);
        Number perRequestTimeout = (Number)requestContext.getLocalAttr("REQUEST_TIMEOUT");
        if (perRequestTimeout == null) {
            requestContext.putLocalAttr("CLIENT_REQUEST_TIMEOUT_VIEW", (Object)defaultRequestTimeout);
            return callback;
        }
        if (perRequestTimeout.longValue() >= (long)defaultRequestTimeout) {
            Boolean requestTimeoutIgnoreIfHigher = (Boolean)requestContext.getLocalAttr("REQUEST_TIMEOUT_IGNORE_IF_HIGHER");
            if (requestTimeoutIgnoreIfHigher != null && requestTimeoutIgnoreIfHigher.booleanValue()) {
                requestContext.putLocalAttr("CLIENT_REQUEST_TIMEOUT_VIEW", (Object)defaultRequestTimeout);
                requestContext.removeLocalAttr("REQUEST_TIMEOUT");
            }
            return callback;
        }
        requestContext.removeLocalAttr("REQUEST_TIMEOUT");
        requestContext.putLocalAttr("CLIENT_REQUEST_TIMEOUT_VIEW", (Object)perRequestTimeout);
        TimeoutCallback timeoutCallback = new TimeoutCallback(this._scheduler, perRequestTimeout.longValue(), TimeUnit.MILLISECONDS, callback, "per request timeout");
        return timeoutCallback;
    }
}

