/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.util.URIRewriter;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import java.util.Map;

public class RewriteClient
implements TransportClient {
    private final TransportClient _transportClient;
    private final URIRewriter _uriRewriter;

    public RewriteClient(TransportClient transportClient, URIRewriter URIRewriter2) {
        this._uriRewriter = URIRewriter2;
        this._transportClient = transportClient;
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        this._transportClient.restRequest(this.rewriteRequest(request), requestContext, wireAttrs, callback);
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        this._transportClient.streamRequest(this.rewriteRequest(request), requestContext, wireAttrs, callback);
    }

    public void shutdown(Callback<None> callback) {
        this._transportClient.shutdown(callback);
    }

    public TransportClient getDecoratedClient() {
        return this._transportClient;
    }

    private RestRequest rewriteRequest(RestRequest request) {
        return ((RestRequestBuilder)request.builder().setURI(this._uriRewriter.rewriteURI(request.getURI()))).build();
    }

    private StreamRequest rewriteRequest(StreamRequest request) {
        return ((StreamRequestBuilder)request.builder().setURI(this._uriRewriter.rewriteURI(request.getURI()))).build(request.getEntityStream());
    }
}

