/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancerClient;
import com.linkedin.d2.balancer.clients.RewriteClient;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.util.D2URIRewriter;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteLoadBalancerClient
implements LoadBalancerClient {
    private static final Logger _log = LoggerFactory.getLogger(TrackerClient.class);
    private final String _serviceName;
    private final URI _uri;
    private final RewriteClient _client;

    public RewriteLoadBalancerClient(String serviceName, URI uri, TransportClient client) {
        this._serviceName = serviceName;
        this._uri = uri;
        this._client = new RewriteClient(client, new D2URIRewriter(uri));
        LogUtil.debug(_log, "created rewrite client: ", this);
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        assert (this._serviceName.equals(LoadBalancerUtil.getServiceNameFromUri(request.getURI())));
        this._client.restRequest(request, requestContext, wireAttrs, callback);
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        assert (this._serviceName.equals(LoadBalancerUtil.getServiceNameFromUri(request.getURI())));
        this._client.streamRequest(request, requestContext, wireAttrs, callback);
    }

    public void shutdown(Callback<None> callback) {
        this._client.shutdown(callback);
    }

    @Deprecated
    public TransportClient getWrappedClient() {
        return this._client;
    }

    public TransportClient getDecoratedClient() {
        return this._client;
    }

    @Override
    public URI getUri() {
        return this._uri;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public String toString() {
        return "RewriteLoadBalancerClient [_serviceName=" + this._serviceName + ", _uri=" + this._uri + ", _wrappedClient=" + this._client + "]";
    }
}

