/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.util.MapUtil;
import com.linkedin.d2.D2RelativeStrategyProperties;
import com.linkedin.d2.HttpStatusCodeRange;
import com.linkedin.d2.balancer.clients.DegraderTrackerClient;
import com.linkedin.d2.balancer.clients.DegraderTrackerClientImpl;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.clients.TrackerClientImpl;
import com.linkedin.d2.balancer.config.RelativeStrategyPropertiesConverter;
import com.linkedin.d2.balancer.properties.PropertyKeys;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.strategies.degrader.DegraderConfigFactory;
import com.linkedin.d2.balancer.strategies.relative.RelativeLoadBalancerStrategyFactory;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.util.RateLimitedLogger;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import com.linkedin.util.degrader.DegraderImpl;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TrackerClientFactory.class);
    private static final int LOG_RATE_MS = 20000;

    public static TrackerClient createTrackerClient(URI uri, UriProperties uriProperties, ServiceProperties serviceProperties, String loadBalancerStrategyName, TransportClient transportClient) {
        return TrackerClientFactory.createTrackerClient(uri, uriProperties, serviceProperties, loadBalancerStrategyName, transportClient, (Clock)SystemClock.instance());
    }

    public static TrackerClient createTrackerClient(URI uri, UriProperties uriProperties, ServiceProperties serviceProperties, String loadBalancerStrategyName, TransportClient transportClient, Clock clock) {
        TrackerClient trackerClient;
        boolean doNotSlowStart = false;
        boolean doNotLoadBalance = false;
        Map<String, Object> uriSpecificProperties = uriProperties.getUriSpecificProperties().get(uri);
        if (uriSpecificProperties != null) {
            if (Boolean.parseBoolean(String.valueOf(uriSpecificProperties.get("doNotSlowStart")))) {
                doNotSlowStart = true;
            }
            if (Boolean.parseBoolean(String.valueOf(uriSpecificProperties.get("doNotLoadBalance")))) {
                doNotLoadBalance = true;
            }
        }
        switch (loadBalancerStrategyName) {
            case "degrader": {
                trackerClient = TrackerClientFactory.createDegraderTrackerClient(uri, uriProperties, serviceProperties, loadBalancerStrategyName, transportClient, clock, doNotSlowStart);
                break;
            }
            case "relative": {
                trackerClient = TrackerClientFactory.createTrackerClientImpl(uri, uriProperties, serviceProperties, loadBalancerStrategyName, transportClient, clock, false, doNotSlowStart, doNotLoadBalance);
                break;
            }
            default: {
                trackerClient = TrackerClientFactory.createTrackerClientImpl(uri, uriProperties, serviceProperties, loadBalancerStrategyName, transportClient, clock, true, doNotSlowStart, doNotLoadBalance);
            }
        }
        return trackerClient;
    }

    private static DegraderTrackerClient createDegraderTrackerClient(URI uri, UriProperties uriProperties, ServiceProperties serviceProperties, String loadBalancerStrategyName, TransportClient transportClient, Clock clock, boolean doNotSlowStart) {
        DegraderImpl.Config config = null;
        if (serviceProperties.getLoadBalancerStrategyProperties() != null) {
            Map<String, Object> loadBalancerStrategyProperties = serviceProperties.getLoadBalancerStrategyProperties();
            clock = (Clock)MapUtil.getWithDefault(loadBalancerStrategyProperties, (Object)"clock", (Object)clock, Clock.class);
        }
        if (serviceProperties.getDegraderProperties() != null && !serviceProperties.getDegraderProperties().isEmpty()) {
            config = DegraderConfigFactory.toDegraderConfig(serviceProperties.getDegraderProperties());
            config.setLogger((Logger)new RateLimitedLogger(LOG, 20000L, clock));
        }
        long trackerClientInterval = TrackerClientFactory.getInterval(loadBalancerStrategyName, serviceProperties);
        Pattern errorStatusPattern = TrackerClientFactory.getErrorStatusPattern(serviceProperties);
        return new DegraderTrackerClientImpl(uri, uriProperties.getPartitionDataMap(uri), transportClient, clock, config, trackerClientInterval, errorStatusPattern, doNotSlowStart);
    }

    private static long getInterval(String loadBalancerStrategyName, ServiceProperties serviceProperties) {
        long interval = 5000L;
        if (serviceProperties != null) {
            switch (loadBalancerStrategyName) {
                case "relative": {
                    Map<String, Object> relativeLoadBalancerProperties = serviceProperties.getRelativeStrategyProperties();
                    if (relativeLoadBalancerProperties == null) break;
                    interval = (Long)MapUtil.getWithDefault(serviceProperties.getRelativeStrategyProperties(), (Object)PropertyKeys.UPDATE_INTERVAL_MS, (Object)5000L, Long.class);
                    break;
                }
                default: {
                    Map<String, Object> loadBalancerStrategyProperties = serviceProperties.getLoadBalancerStrategyProperties();
                    if (loadBalancerStrategyProperties == null) break;
                    interval = (Long)MapUtil.getWithDefault(serviceProperties.getLoadBalancerStrategyProperties(), (Object)"http.loadBalancer.updateIntervalMs", (Object)5000L, Long.class);
                }
            }
        }
        return interval;
    }

    private static Pattern getErrorStatusPattern(ServiceProperties serviceProperties) {
        Pattern errorPattern;
        String regex = "(5..)";
        if (serviceProperties != null) {
            regex = (String)MapUtil.getWithDefault(serviceProperties.getLoadBalancerStrategyProperties(), (Object)"http.loadBalancer.errorStatusRegex", (Object)"(5..)", String.class);
        }
        try {
            errorPattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException ex) {
            LogUtil.warn(LOG, "Invalid error status regex: ", regex, ". Falling back to default regex: ", "(5..)");
            errorPattern = TrackerClientImpl.DEFAULT_ERROR_STATUS_PATTERN;
        }
        return errorPattern;
    }

    private static List<HttpStatusCodeRange> getErrorStatusRanges(ServiceProperties serviceProperties) {
        D2RelativeStrategyProperties relativeStrategyProperties = RelativeStrategyPropertiesConverter.toProperties(serviceProperties.getRelativeStrategyProperties());
        if (relativeStrategyProperties.getErrorStatusFilter() == null) {
            return RelativeLoadBalancerStrategyFactory.DEFAULT_ERROR_STATUS_FILTER;
        }
        return relativeStrategyProperties.getErrorStatusFilter();
    }

    private static TrackerClientImpl createTrackerClientImpl(URI uri, UriProperties uriProperties, ServiceProperties serviceProperties, String loadBalancerStrategyName, TransportClient transportClient, Clock clock, boolean percentileTrackingEnabled, boolean doNotSlowStart, boolean doNotLoadBalance) {
        List<HttpStatusCodeRange> errorStatusCodeRanges = TrackerClientFactory.getErrorStatusRanges(serviceProperties);
        Predicate<Integer> isErrorStatus = status -> {
            for (HttpStatusCodeRange statusCodeRange : errorStatusCodeRanges) {
                if (status < statusCodeRange.getLowerBound() || status > statusCodeRange.getUpperBound()) continue;
                return true;
            }
            return false;
        };
        return new TrackerClientImpl(uri, uriProperties.getPartitionDataMap(uri), transportClient, clock, TrackerClientFactory.getInterval(loadBalancerStrategyName, serviceProperties), isErrorStatus, percentileTrackingEnabled, doNotSlowStart, doNotLoadBalance);
    }
}

