/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clusterfailout;

import com.linkedin.d2.balancer.LoadBalancerState;
import com.linkedin.d2.balancer.clusterfailout.FailoutConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedoutClusterManager {
    private static final Logger _log = LoggerFactory.getLogger(FailedoutClusterManager.class);
    private final String _clusterName;
    private final LoadBalancerState _loadBalancerState;
    private final ConcurrentMap<String, LoadBalancerState.LoadBalancerStateListenerCallback> _clusterListeners = new ConcurrentHashMap<String, LoadBalancerState.LoadBalancerStateListenerCallback>();
    private FailoutConfig _failoutConfig;

    public FailedoutClusterManager(@Nonnull String clusterName, @Nonnull LoadBalancerState loadBalancerState) {
        this._clusterName = clusterName;
        this._loadBalancerState = loadBalancerState;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public FailoutConfig getFailoutConfig() {
        return this._failoutConfig;
    }

    public void updateFailoutConfig(@Nullable FailoutConfig failoutConfig) {
        if (failoutConfig == null) {
            this.removePeerClusterWatches();
        } else {
            this.processNewConfig(failoutConfig);
        }
        this._failoutConfig = failoutConfig;
    }

    private void processNewConfig(@Nonnull FailoutConfig failoutConfig) {
        if (!failoutConfig.isFailedOut()) {
            _log.debug("Failout completed for downstream cluster: {}. Removing all peer cluster watches.", (Object)this._clusterName);
            this.removePeerClusterWatches();
        } else {
            Set<String> peerClusters = failoutConfig.getPeerClusters();
            this.addPeerClusterWatches(peerClusters);
        }
    }

    void addPeerClusterWatches(@Nonnull Set<String> newPeerClusters) {
        Set existingPeerClusters = this._clusterListeners.keySet();
        if (newPeerClusters.isEmpty()) {
            this.removePeerClusterWatches();
            return;
        }
        HashSet<String> peerClustersToAdd = new HashSet<String>(newPeerClusters);
        peerClustersToAdd.removeAll(existingPeerClusters);
        if (!peerClustersToAdd.isEmpty()) {
            this.addClusterWatches(peerClustersToAdd);
        }
        HashSet<String> peerClustersToRemove = new HashSet<String>(existingPeerClusters);
        peerClustersToRemove.removeAll(newPeerClusters);
        if (!peerClustersToRemove.isEmpty()) {
            this.removeClusterWatches(peerClustersToRemove);
        }
    }

    void removePeerClusterWatches() {
        this.removeClusterWatches(this._clusterListeners.keySet());
    }

    private void addClusterWatches(@Nonnull Set<String> clustersToWatch) {
        if (_log.isDebugEnabled()) {
            _log.debug("Watching peer clusters: " + String.join((CharSequence)",", clustersToWatch));
        }
        for (String cluster : clustersToWatch) {
            this._clusterListeners.computeIfAbsent(cluster, clusterName -> {
                LoadBalancerState.NullStateListenerCallback listener = new LoadBalancerState.NullStateListenerCallback();
                this._loadBalancerState.listenToCluster(cluster, listener);
                return listener;
            });
        }
    }

    private void removeClusterWatches(@Nonnull Set<String> clustersToRemove) {
        if (_log.isDebugEnabled()) {
            _log.debug("Removing peer clusters: " + String.join((CharSequence)",", clustersToRemove));
        }
        for (String cluster : clustersToRemove) {
            LoadBalancerState.LoadBalancerStateListenerCallback listener = (LoadBalancerState.LoadBalancerStateListenerCallback)this._clusterListeners.remove(cluster);
            if (listener == null) continue;
        }
    }
}

