/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clusterfailout;

import com.linkedin.d2.balancer.LoadBalancerClusterListener;
import com.linkedin.d2.balancer.LoadBalancerState;
import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.clusterfailout.FailedoutClusterManager;
import com.linkedin.d2.balancer.clusterfailout.FailoutConfig;
import com.linkedin.d2.balancer.clusterfailout.FailoutConfigProvider;
import com.linkedin.d2.balancer.properties.FailoutProperties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZKFailoutConfigProvider
implements FailoutConfigProvider,
LoadBalancerClusterListener {
    private static final Logger _log = LoggerFactory.getLogger(FailedoutClusterManager.class);
    private final ConcurrentMap<String, FailedoutClusterManager> _failedoutClusterManagers = new ConcurrentHashMap<String, FailedoutClusterManager>();
    private final LoadBalancerState _loadBalancerState;

    public ZKFailoutConfigProvider(@Nonnull LoadBalancerState loadBalancerState) {
        this._loadBalancerState = loadBalancerState;
    }

    @Override
    public void start() {
        _log.info("Registering cluster listener to watch for failout config changes");
        this._loadBalancerState.registerClusterListener(this);
    }

    @Override
    public void shutdown() {
        this._loadBalancerState.unregisterClusterListener(this);
    }

    @Nullable
    public abstract FailoutConfig createFailoutConfig(@Nonnull String var1, @Nullable FailoutProperties var2);

    @Override
    public FailoutConfig getFailoutConfig(String clusterName) {
        FailedoutClusterManager failedoutClusterManager = (FailedoutClusterManager)this._failedoutClusterManagers.get(clusterName);
        return failedoutClusterManager != null ? failedoutClusterManager.getFailoutConfig() : null;
    }

    @Override
    public void onClusterAdded(String clusterName) {
        LoadBalancerStateItem<FailoutProperties> item = this._loadBalancerState.getFailoutProperties(clusterName);
        if (item != null) {
            FailoutProperties failoutProperties = item.getProperty();
            _log.info("Detected cluster failout property change for cluster: {}. New properties: {}", (Object)clusterName, (Object)failoutProperties);
            FailoutConfig failoutConfig = this.createFailoutConfig(clusterName, failoutProperties);
            this._failedoutClusterManagers.computeIfAbsent(clusterName, name -> new FailedoutClusterManager(clusterName, this._loadBalancerState)).updateFailoutConfig(failoutConfig);
        } else {
            _log.debug("Cluster properties change for cluster: {}. No cluster failout property found.", (Object)clusterName);
        }
    }

    @Override
    public void onClusterRemoved(String clusterName) {
        FailedoutClusterManager manager = (FailedoutClusterManager)this._failedoutClusterManagers.remove(clusterName);
        if (manager != null) {
            _log.info("Cluster: {} removed. Resetting cluster failout config.", (Object)clusterName);
            manager.updateFailoutConfig(null);
        }
    }
}

