/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.d2.BackupRequestsConfigurationArray;
import com.linkedin.d2.balancer.util.JacksonUtil;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.template.DataTemplate;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BackupRequestsConverter {
    private static final JacksonDataCodec CODEC = new JacksonDataCodec();
    private static final ValidationOptions VALIDATION_OPTIONS = new ValidationOptions(RequiredMode.CAN_BE_ABSENT_IF_HAS_DEFAULT, CoercionMode.STRING_TO_PRIMITIVE);

    public static List<Map<String, Object>> toProperties(BackupRequestsConfigurationArray config) {
        if (config == null) {
            return Collections.emptyList();
        }
        try {
            String json = CODEC.listToString(config.data());
            return (List)JacksonUtil.getObjectMapper().readValue(json, List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BackupRequestsConfigurationArray toConfig(List<Map<String, Object>> properties) {
        try {
            String json = JacksonUtil.getObjectMapper().writeValueAsString(properties);
            BackupRequestsConfigurationArray brca = new BackupRequestsConfigurationArray(CODEC.stringToList(json));
            ValidateDataAgainstSchema.validate((DataTemplate)brca, (ValidationOptions)VALIDATION_OPTIONS);
            return brca;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

