/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.d2.D2CanaryDistributionStrategy;
import com.linkedin.d2.PercentageStrategyProperties;
import com.linkedin.d2.StrategyType;
import com.linkedin.d2.TargetApplicationsStrategyProperties;
import com.linkedin.d2.TargetHostsStrategyProperties;
import com.linkedin.d2.balancer.properties.CanaryDistributionStrategy;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.data.template.StringArray;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanaryDistributionStrategyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CanaryDistributionStrategyConverter.class);
    private static final Map<String, StrategyType> strategyTypes = new HashMap<String, StrategyType>();
    private static final String STRATEGY_NAME_PERCENTAGE = "percentage";
    private static final String STRATEGY_NAME_TARGET_HOSTS = "targetHosts";
    private static final String STRATEGY_NAME_TARGET_APPLICATIONS = "targetApplications";
    private static final String STRATEGY_NAME_DISABLED = "disabled";

    public static D2CanaryDistributionStrategy toConfig(CanaryDistributionStrategy properties) {
        D2CanaryDistributionStrategy config = new D2CanaryDistributionStrategy();
        StrategyType type = strategyTypes.get(properties.getStrategy());
        if (type == null) {
            LOG.warn("Unknown strategy type from CanaryDistributionStrategy: " + properties.getStrategy() + ". Fall back to DISABLED.");
            type = StrategyType.DISABLED;
        }
        config.setStrategy(type);
        try {
            switch (type) {
                case PERCENTAGE: {
                    Double scope = CanaryDistributionStrategyConverter.getValidScope(PropertyUtil.checkAndGetValue(properties.getPercentageStrategyProperties(), "scope", Number.class, "PercentageStrategyProperties").doubleValue());
                    PercentageStrategyProperties toPercentageProperties = new PercentageStrategyProperties();
                    toPercentageProperties.setScope(scope);
                    config.setPercentageStrategyProperties(toPercentageProperties);
                    break;
                }
                case TARGET_HOSTS: {
                    List hosts = PropertyUtil.checkAndGetValue(properties.getTargetHostsStrategyProperties(), STRATEGY_NAME_TARGET_HOSTS, List.class, "TargetHostsStrategyProperties");
                    TargetHostsStrategyProperties toTargetHostsProperties = new TargetHostsStrategyProperties();
                    toTargetHostsProperties.setTargetHosts(new StringArray((Collection)hosts));
                    config.setTargetHostsStrategyProperties(toTargetHostsProperties);
                    break;
                }
                case TARGET_APPLICATIONS: {
                    Map<String, Object> fromTargetAppsProperties = properties.getTargetApplicationsStrategyProperties();
                    List apps = PropertyUtil.checkAndGetValue(fromTargetAppsProperties, STRATEGY_NAME_TARGET_APPLICATIONS, List.class, "TargetApplicationsStrategyProperties");
                    Double appScope = CanaryDistributionStrategyConverter.getValidScope(PropertyUtil.checkAndGetValue(fromTargetAppsProperties, "scope", Number.class, "TargetApplicationsStrategyProperties").doubleValue());
                    TargetApplicationsStrategyProperties toTargetAppsProperties = new TargetApplicationsStrategyProperties();
                    toTargetAppsProperties.setTargetApplications(new StringArray((Collection)apps));
                    toTargetAppsProperties.setScope(appScope);
                    config.setTargetApplicationsStrategyProperties(toTargetAppsProperties);
                    break;
                }
                case DISABLED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected strategy type: " + type);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error in converting distribution strategy. Fall back to DISABLED.", (Throwable)e);
            config.setStrategy(StrategyType.DISABLED);
        }
        return config;
    }

    public static CanaryDistributionStrategy toProperties(D2CanaryDistributionStrategy config) {
        String strategyName;
        HashMap<String, Object> percentageStrategyProperties = new HashMap<String, Object>();
        HashMap<String, Object> targetHostsStrategyProperties = new HashMap<String, Object>();
        HashMap<String, Object> targetApplicationsStrategyProperties = new HashMap<String, Object>();
        switch (config.getStrategy()) {
            case PERCENTAGE: {
                strategyName = STRATEGY_NAME_PERCENTAGE;
                if (!config.hasPercentageStrategyProperties()) break;
                percentageStrategyProperties.put("scope", config.getPercentageStrategyProperties().getScope());
                break;
            }
            case TARGET_HOSTS: {
                strategyName = STRATEGY_NAME_TARGET_HOSTS;
                if (!config.hasTargetHostsStrategyProperties()) break;
                targetHostsStrategyProperties.put(STRATEGY_NAME_TARGET_HOSTS, config.getTargetHostsStrategyProperties().getTargetHosts());
                break;
            }
            case TARGET_APPLICATIONS: {
                strategyName = STRATEGY_NAME_TARGET_APPLICATIONS;
                if (!config.hasTargetApplicationsStrategyProperties()) break;
                TargetApplicationsStrategyProperties configTargetApplicationProperties = config.getTargetApplicationsStrategyProperties();
                targetApplicationsStrategyProperties.put(STRATEGY_NAME_TARGET_APPLICATIONS, configTargetApplicationProperties.getTargetApplications());
                targetApplicationsStrategyProperties.put("scope", configTargetApplicationProperties.getScope());
                break;
            }
            case DISABLED: {
                strategyName = STRATEGY_NAME_DISABLED;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + config.getStrategy());
            }
        }
        return new CanaryDistributionStrategy(strategyName, percentageStrategyProperties, targetHostsStrategyProperties, targetApplicationsStrategyProperties);
    }

    private static Double getValidScope(double scope) {
        if (scope < 0.0 || scope >= 1.0) {
            LOG.warn("Invalid scope: " + scope + ". Use default value 0.");
            scope = CanaryDistributionStrategy.DEFAULT_SCOPE;
        }
        return scope;
    }

    static {
        strategyTypes.put(STRATEGY_NAME_PERCENTAGE, StrategyType.PERCENTAGE);
        strategyTypes.put(STRATEGY_NAME_TARGET_HOSTS, StrategyType.TARGET_HOSTS);
        strategyTypes.put(STRATEGY_NAME_TARGET_APPLICATIONS, StrategyType.TARGET_APPLICATIONS);
        strategyTypes.put(STRATEGY_NAME_DISABLED, StrategyType.DISABLED);
    }
}

