/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.d2.D2TransportClientProperties;
import com.linkedin.d2.DarkClusterConfig;
import com.linkedin.d2.DarkClusterConfigMap;
import com.linkedin.d2.DarkClusterStrategyName;
import com.linkedin.d2.DarkClusterStrategyNameArray;
import com.linkedin.d2.balancer.config.TransportClientPropertiesConverter;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.data.DataList;
import com.linkedin.data.template.DataTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DarkClustersConverter {
    public static Map<String, Object> toProperties(DarkClusterConfigMap config) {
        if (config == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> darkProps = new HashMap<String, Object>();
        for (Map.Entry entry : config.entrySet()) {
            String darkClusterName = (String)entry.getKey();
            DarkClusterConfig darkClusterConfig = (DarkClusterConfig)entry.getValue();
            HashMap<String, Object> prop = new HashMap<String, Object>();
            if (darkClusterConfig.hasMultiplier()) {
                prop.put("multiplier", darkClusterConfig.getMultiplier().toString());
            }
            if (darkClusterConfig.hasDispatcherOutboundTargetRate()) {
                prop.put("dispatcherOutboundTargetRate", darkClusterConfig.getDispatcherOutboundTargetRate().toString());
            }
            if (darkClusterConfig.hasDispatcherMaxRequestsToBuffer()) {
                prop.put("dispatcherMaxRequestsToBuffer", darkClusterConfig.getDispatcherMaxRequestsToBuffer().toString());
            }
            if (darkClusterConfig.hasDispatcherBufferedRequestExpiryInSeconds()) {
                prop.put("dispatcherBufferedRequestExpiryInSeconds", darkClusterConfig.getDispatcherBufferedRequestExpiryInSeconds().toString());
            }
            if (darkClusterConfig.hasDarkClusterStrategyPrioritizedList()) {
                DarkClusterStrategyNameArray strategyNameArray = darkClusterConfig.getDarkClusterStrategyPrioritizedList();
                ArrayList<String> strategyList = new ArrayList<String>();
                for (DarkClusterStrategyName type : strategyNameArray) {
                    strategyList.add(type.toString());
                }
                prop.put("darkClusterStrategyList", strategyList);
            }
            if (darkClusterConfig.hasTransportClientProperties()) {
                prop.put("transportClientProperties", TransportClientPropertiesConverter.toProperties(darkClusterConfig.getTransportClientProperties()));
            }
            darkProps.put(darkClusterName, prop);
        }
        return darkProps;
    }

    public static DarkClusterConfigMap toConfig(Map<String, Object> properties) {
        DarkClusterConfigMap configMap = new DarkClusterConfigMap();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String darkClusterName = entry.getKey();
            DarkClusterConfig darkClusterConfig = new DarkClusterConfig();
            Map props = (Map)entry.getValue();
            if (props.containsKey("multiplier")) {
                darkClusterConfig.setMultiplier(PropertyUtil.coerce(props.get("multiplier"), Float.class));
            } else {
                darkClusterConfig.setMultiplier(0.0f);
            }
            if (props.containsKey("dispatcherOutboundTargetRate")) {
                darkClusterConfig.setDispatcherOutboundTargetRate(PropertyUtil.coerce(props.get("dispatcherOutboundTargetRate"), Float.class));
            } else {
                darkClusterConfig.setDispatcherOutboundTargetRate(0.0f);
            }
            if (props.containsKey("dispatcherMaxRequestsToBuffer")) {
                darkClusterConfig.setDispatcherMaxRequestsToBuffer(PropertyUtil.coerce(props.get("dispatcherMaxRequestsToBuffer"), Integer.class));
            } else {
                darkClusterConfig.setDispatcherMaxRequestsToBuffer(1);
            }
            if (props.containsKey("dispatcherBufferedRequestExpiryInSeconds")) {
                darkClusterConfig.setDispatcherBufferedRequestExpiryInSeconds(PropertyUtil.coerce(props.get("dispatcherBufferedRequestExpiryInSeconds"), Integer.class));
            } else {
                darkClusterConfig.setDispatcherBufferedRequestExpiryInSeconds(1);
            }
            if (props.containsKey("darkClusterStrategyList")) {
                DataList dataList = new DataList();
                List strategyList = (List)props.get("darkClusterStrategyList");
                dataList.addAll((Collection)strategyList);
                DarkClusterStrategyNameArray darkClusterStrategyNameArray = new DarkClusterStrategyNameArray(dataList);
                darkClusterConfig.setDarkClusterStrategyPrioritizedList(darkClusterStrategyNameArray);
            }
            if (props.containsKey("transportClientProperties")) {
                D2TransportClientProperties transportClientProperties = TransportClientPropertiesConverter.toConfig((Map)props.get("transportClientProperties"));
                darkClusterConfig.setTransportClientProperties(transportClientProperties);
            }
            configMap.put(darkClusterName, (DataTemplate)darkClusterConfig);
        }
        return configMap;
    }
}

