/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.d2.D2ClusterPartitionConfiguration;
import com.linkedin.d2.HashAlgorithm;
import com.linkedin.d2.PartitionAccessorList;
import com.linkedin.d2.PartitionTypeEnum;
import com.linkedin.d2.RangedPartitionProperties;
import com.linkedin.d2.balancer.properties.CustomizedPartitionProperties;
import com.linkedin.d2.balancer.properties.HashBasedPartitionProperties;
import com.linkedin.d2.balancer.properties.NullPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.d2.balancer.properties.RangeBasedPartitionProperties;
import com.linkedin.data.template.StringArray;
import java.util.List;

public class PartitionPropertiesConverter {
    public static PartitionProperties toProperties(D2ClusterPartitionConfiguration config) {
        PartitionProperties partitionProperties;
        switch (config.getType()) {
            case RANGE: {
                RangedPartitionProperties rangedPartitionProperties = config.getPartitionTypeSpecificData().getRangedPartitionProperties();
                partitionProperties = new RangeBasedPartitionProperties(config.getPartitionKeyRegex(), rangedPartitionProperties.getKeyRangeStart(), rangedPartitionProperties.getPartitionSize(), config.getPartitionCount());
                break;
            }
            case HASH: {
                HashBasedPartitionProperties.HashAlgorithm algorithm;
                switch (config.getPartitionTypeSpecificData().getHashAlgorithm()) {
                    case MODULO: {
                        algorithm = HashBasedPartitionProperties.HashAlgorithm.MODULO;
                        break;
                    }
                    case MD5: {
                        algorithm = HashBasedPartitionProperties.HashAlgorithm.MD5;
                        break;
                    }
                    case XXHASH: {
                        algorithm = HashBasedPartitionProperties.HashAlgorithm.XXHASH;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported hash algorithm: " + config.getPartitionTypeSpecificData().getHashAlgorithm());
                    }
                }
                partitionProperties = new HashBasedPartitionProperties(config.getPartitionKeyRegex(), config.getPartitionCount(), algorithm);
                break;
            }
            case CUSTOM: {
                partitionProperties = new CustomizedPartitionProperties(config.getPartitionCount(), (List<String>)config.getPartitionTypeSpecificData().getPartitionAccessorList().getClassNames());
                break;
            }
            case NONE: {
                partitionProperties = NullPartitionProperties.getInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported partitionType: " + config.getType());
            }
        }
        return partitionProperties;
    }

    public static D2ClusterPartitionConfiguration toConfig(PartitionProperties property) {
        D2ClusterPartitionConfiguration config;
        switch (property.getPartitionType()) {
            case RANGE: {
                RangeBasedPartitionProperties range = (RangeBasedPartitionProperties)property;
                config = new D2ClusterPartitionConfiguration();
                config.setType(PartitionTypeEnum.RANGE);
                config.setPartitionKeyRegex(range.getPartitionKeyRegex());
                config.setPartitionCount(range.getPartitionCount());
                D2ClusterPartitionConfiguration.PartitionTypeSpecificData specificData = new D2ClusterPartitionConfiguration.PartitionTypeSpecificData();
                RangedPartitionProperties rangedPartitionProperties = new RangedPartitionProperties();
                rangedPartitionProperties.setKeyRangeStart(range.getKeyRangeStart());
                rangedPartitionProperties.setPartitionSize(range.getPartitionSize());
                specificData.setRangedPartitionProperties(rangedPartitionProperties);
                config.setPartitionTypeSpecificData(specificData);
                break;
            }
            case HASH: {
                HashBasedPartitionProperties hash = (HashBasedPartitionProperties)property;
                config = new D2ClusterPartitionConfiguration();
                config.setType(PartitionTypeEnum.HASH);
                config.setPartitionKeyRegex(hash.getPartitionKeyRegex());
                config.setPartitionCount(hash.getPartitionCount());
                D2ClusterPartitionConfiguration.PartitionTypeSpecificData specificData = new D2ClusterPartitionConfiguration.PartitionTypeSpecificData();
                specificData.setHashAlgorithm(HashAlgorithm.valueOf((String)hash.getHashAlgorithm().name()));
                config.setPartitionTypeSpecificData(specificData);
                break;
            }
            case CUSTOM: {
                CustomizedPartitionProperties properties = (CustomizedPartitionProperties)property;
                config = new D2ClusterPartitionConfiguration();
                config.setType(PartitionTypeEnum.CUSTOM);
                config.setPartitionCount(properties.getPartitionCount());
                D2ClusterPartitionConfiguration.PartitionTypeSpecificData specificData = new D2ClusterPartitionConfiguration.PartitionTypeSpecificData();
                PartitionAccessorList partitionList = new PartitionAccessorList();
                partitionList.setClassNames(new StringArray(properties.getPartitionAccessorList()));
                specificData.setPartitionAccessorList(partitionList);
                config.setPartitionTypeSpecificData(specificData);
                break;
            }
            case NONE: {
                config = new D2ClusterPartitionConfiguration();
                config.setType(PartitionTypeEnum.NONE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported partitionType: " + (Object)((Object)property.getPartitionType()));
            }
        }
        return config;
    }
}

