/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.d2.ConsistentHashAlgorithm;
import com.linkedin.d2.D2QuarantineProperties;
import com.linkedin.d2.D2RelativeStrategyProperties;
import com.linkedin.d2.D2RingProperties;
import com.linkedin.d2.HashConfig;
import com.linkedin.d2.HashMethod;
import com.linkedin.d2.HttpMethod;
import com.linkedin.d2.HttpStatusCodeRange;
import com.linkedin.d2.HttpStatusCodeRangeArray;
import com.linkedin.d2.balancer.properties.PropertyKeys;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.StringArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RelativeStrategyPropertiesConverter {
    public static Map<String, Object> toMap(D2RelativeStrategyProperties properties) {
        if (properties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (properties.hasUpStep()) {
            map.put(PropertyKeys.UP_STEP, properties.getUpStep().toString());
        }
        if (properties.hasDownStep()) {
            map.put(PropertyKeys.DOWN_STEP, properties.getDownStep().toString());
        }
        if (properties.hasRelativeLatencyHighThresholdFactor()) {
            map.put(PropertyKeys.RELATIVE_LATENCY_HIGH_THRESHOLD_FACTOR, properties.getRelativeLatencyHighThresholdFactor().toString());
        }
        if (properties.hasRelativeLatencyLowThresholdFactor()) {
            map.put(PropertyKeys.RELATIVE_LATENCY_LOW_THRESHOLD_FACTOR, properties.getRelativeLatencyLowThresholdFactor().toString());
        }
        if (properties.hasHighErrorRate()) {
            map.put(PropertyKeys.HIGH_ERROR_RATE, properties.getHighErrorRate().toString());
        }
        if (properties.hasLowErrorRate()) {
            map.put(PropertyKeys.LOW_ERROR_RATE, properties.getLowErrorRate().toString());
        }
        if (properties.hasMinCallCount()) {
            map.put(PropertyKeys.MIN_CALL_COUNT, properties.getMinCallCount().toString());
        }
        if (properties.hasUpdateIntervalMs()) {
            map.put(PropertyKeys.UPDATE_INTERVAL_MS, properties.getUpdateIntervalMs().toString());
        }
        if (properties.hasInitialHealthScore()) {
            map.put(PropertyKeys.INITIAL_HEALTH_SCORE, properties.getInitialHealthScore().toString());
        }
        if (properties.hasSlowStartThreshold()) {
            map.put(PropertyKeys.SLOW_START_THRESHOLD, properties.getSlowStartThreshold().toString());
        }
        if (properties.hasEmittingIntervalMs()) {
            map.put(PropertyKeys.EMITTING_INTERVAL_MS, properties.getEmittingIntervalMs().toString());
        }
        if (properties.hasEnableFastRecovery()) {
            map.put(PropertyKeys.ENABLE_FAST_RECOVERY, properties.isEnableFastRecovery().toString());
        }
        if (properties.hasErrorStatusFilter()) {
            ArrayList errorStatusFilterList = new ArrayList();
            for (HttpStatusCodeRange errorStatusRange : properties.getErrorStatusFilter()) {
                HashMap<String, String> errorStatusFilterMap = new HashMap<String, String>();
                errorStatusFilterMap.put(PropertyKeys.ERROR_STATUS_LOWER_BOUND, errorStatusRange.getLowerBound().toString());
                errorStatusFilterMap.put(PropertyKeys.ERROR_STATUS_UPPER_BOUND, errorStatusRange.getUpperBound().toString());
                errorStatusFilterList.add(errorStatusFilterMap);
            }
            map.put(PropertyKeys.ERROR_STATUS_FILTER, errorStatusFilterList);
        }
        if (properties.hasQuarantineProperties()) {
            D2QuarantineProperties quarantineProperties = properties.getQuarantineProperties();
            Map<String, Object> quarantinePropertyMap = RelativeStrategyPropertiesConverter.toQuarantinePropertyMap(quarantineProperties);
            map.put(PropertyKeys.QUARANTINE_PROPERTIES, quarantinePropertyMap);
        }
        if (properties.hasRingProperties()) {
            D2RingProperties ringProperties = properties.getRingProperties();
            Map<String, Object> ringPropertyMap = RelativeStrategyPropertiesConverter.toRingPropertyMap(ringProperties);
            map.put(PropertyKeys.RING_PROPERTIES, ringPropertyMap);
        }
        return map;
    }

    public static D2RelativeStrategyProperties toProperties(Map<String, Object> properties) {
        D2RelativeStrategyProperties config = new D2RelativeStrategyProperties();
        if (properties.containsKey(PropertyKeys.UP_STEP)) {
            config.setUpStep(PropertyUtil.coerce(properties.get(PropertyKeys.UP_STEP), Double.class));
        }
        if (properties.containsKey(PropertyKeys.DOWN_STEP)) {
            config.setDownStep(PropertyUtil.coerce(properties.get(PropertyKeys.DOWN_STEP), Double.class));
        }
        if (properties.containsKey(PropertyKeys.RELATIVE_LATENCY_HIGH_THRESHOLD_FACTOR)) {
            config.setRelativeLatencyHighThresholdFactor(PropertyUtil.coerce(properties.get(PropertyKeys.RELATIVE_LATENCY_HIGH_THRESHOLD_FACTOR), Double.class));
        }
        if (properties.containsKey(PropertyKeys.RELATIVE_LATENCY_LOW_THRESHOLD_FACTOR)) {
            config.setRelativeLatencyLowThresholdFactor(PropertyUtil.coerce(properties.get(PropertyKeys.RELATIVE_LATENCY_LOW_THRESHOLD_FACTOR), Double.class));
        }
        if (properties.containsKey(PropertyKeys.HIGH_ERROR_RATE)) {
            config.setHighErrorRate(PropertyUtil.coerce(properties.get(PropertyKeys.HIGH_ERROR_RATE), Double.class));
        }
        if (properties.containsKey(PropertyKeys.LOW_ERROR_RATE)) {
            config.setLowErrorRate(PropertyUtil.coerce(properties.get(PropertyKeys.LOW_ERROR_RATE), Double.class));
        }
        if (properties.containsKey(PropertyKeys.MIN_CALL_COUNT)) {
            config.setMinCallCount(PropertyUtil.coerce(properties.get(PropertyKeys.MIN_CALL_COUNT), Integer.class));
        }
        if (properties.containsKey(PropertyKeys.UPDATE_INTERVAL_MS)) {
            config.setUpdateIntervalMs(PropertyUtil.coerce(properties.get(PropertyKeys.UPDATE_INTERVAL_MS), Long.class));
        }
        if (properties.containsKey(PropertyKeys.INITIAL_HEALTH_SCORE)) {
            config.setInitialHealthScore(PropertyUtil.coerce(properties.get(PropertyKeys.INITIAL_HEALTH_SCORE), Double.class));
        }
        if (properties.containsKey(PropertyKeys.SLOW_START_THRESHOLD)) {
            config.setSlowStartThreshold(PropertyUtil.coerce(properties.get(PropertyKeys.SLOW_START_THRESHOLD), Double.class));
        }
        if (properties.containsKey(PropertyKeys.EMITTING_INTERVAL_MS)) {
            config.setEmittingIntervalMs(PropertyUtil.coerce(properties.get(PropertyKeys.EMITTING_INTERVAL_MS), Long.class));
        }
        if (properties.containsKey(PropertyKeys.ENABLE_FAST_RECOVERY)) {
            config.setEnableFastRecovery(PropertyUtil.coerce(properties.get(PropertyKeys.ENABLE_FAST_RECOVERY), Boolean.class));
        }
        if (properties.containsKey(PropertyKeys.ERROR_STATUS_FILTER)) {
            HttpStatusCodeRangeArray array = new HttpStatusCodeRangeArray();
            List errorStatusFilterList = (List)properties.get(PropertyKeys.ERROR_STATUS_FILTER);
            for (Map errorStatusRange : errorStatusFilterList) {
                HttpStatusCodeRange httpStatusCodeRange = new HttpStatusCodeRange().setUpperBound(PropertyUtil.coerce(errorStatusRange.get(PropertyKeys.ERROR_STATUS_UPPER_BOUND), Integer.class)).setLowerBound(PropertyUtil.coerce(errorStatusRange.get(PropertyKeys.ERROR_STATUS_LOWER_BOUND), Integer.class));
                array.add((DataTemplate)httpStatusCodeRange);
            }
            config.setErrorStatusFilter(array);
        }
        if (properties.containsKey(PropertyKeys.QUARANTINE_PROPERTIES)) {
            config.setQuarantineProperties(RelativeStrategyPropertiesConverter.toQuarantineProperties((Map)properties.get(PropertyKeys.QUARANTINE_PROPERTIES)));
        }
        if (properties.containsKey(PropertyKeys.RING_PROPERTIES)) {
            config.setRingProperties(RelativeStrategyPropertiesConverter.toRingProperties((Map)properties.get(PropertyKeys.RING_PROPERTIES)));
        }
        return config;
    }

    private static Map<String, Object> toQuarantinePropertyMap(D2QuarantineProperties quarantineProperties) {
        HashMap<String, Object> quarantinePropertyMap = new HashMap<String, Object>();
        if (quarantineProperties.hasQuarantineMaxPercent()) {
            quarantinePropertyMap.put(PropertyKeys.QUARANTINE_MAX_PERCENT, quarantineProperties.getQuarantineMaxPercent().toString());
        }
        if (quarantineProperties.hasHealthCheckMethod()) {
            quarantinePropertyMap.put(PropertyKeys.QUARANTINE_HEALTH_CHECK_METHOD, quarantineProperties.getHealthCheckMethod().toString());
        }
        if (quarantineProperties.hasHealthCheckPath()) {
            quarantinePropertyMap.put(PropertyKeys.QUARANTINE_HEALTH_CHECK_PATH, quarantineProperties.getHealthCheckPath());
        }
        return quarantinePropertyMap;
    }

    private static D2QuarantineProperties toQuarantineProperties(Map<String, Object> quarantinePropertyMap) {
        D2QuarantineProperties quarantineProperties = new D2QuarantineProperties();
        if (quarantinePropertyMap.containsKey(PropertyKeys.QUARANTINE_MAX_PERCENT)) {
            quarantineProperties.setQuarantineMaxPercent(PropertyUtil.coerce(quarantinePropertyMap.get(PropertyKeys.QUARANTINE_MAX_PERCENT), Double.class));
        }
        if (quarantinePropertyMap.containsKey(PropertyKeys.QUARANTINE_HEALTH_CHECK_METHOD)) {
            String httpMethod = (String)quarantinePropertyMap.get(PropertyKeys.QUARANTINE_HEALTH_CHECK_METHOD);
            if (HttpMethod.OPTIONS.name().equalsIgnoreCase(httpMethod)) {
                quarantineProperties.setHealthCheckMethod(HttpMethod.OPTIONS);
            } else if (HttpMethod.GET.name().equalsIgnoreCase(httpMethod)) {
                quarantineProperties.setHealthCheckMethod(HttpMethod.GET);
            }
        }
        if (quarantinePropertyMap.containsKey(PropertyKeys.QUARANTINE_HEALTH_CHECK_PATH)) {
            quarantineProperties.setHealthCheckPath(PropertyUtil.coerce(quarantinePropertyMap.get(PropertyKeys.QUARANTINE_HEALTH_CHECK_PATH), String.class));
        }
        return quarantineProperties;
    }

    private static Map<String, Object> toRingPropertyMap(D2RingProperties ringProperties) {
        HashMap<String, Object> ringPropertyMap = new HashMap<String, Object>();
        if (ringProperties.hasPointsPerWeight()) {
            ringPropertyMap.put(PropertyKeys.RING_POINTS_PER_WEIGHT, ringProperties.getPointsPerWeight().toString());
        }
        if (ringProperties.hasHashMethod()) {
            switch (ringProperties.getHashMethod()) {
                case RANDOM: {
                    ringPropertyMap.put(PropertyKeys.RING_HASH_METHOD, "random");
                    break;
                }
                case URI_REGEX: {
                    ringPropertyMap.put(PropertyKeys.RING_HASH_METHOD, "uriRegex");
                    break;
                }
                default: {
                    ringPropertyMap.put(PropertyKeys.RING_HASH_METHOD, "random");
                }
            }
        }
        if (ringProperties.hasHashConfig()) {
            Map<String, Object> hashConfigMap = RelativeStrategyPropertiesConverter.toHashConfigMap(ringProperties.getHashConfig());
            ringPropertyMap.put(PropertyKeys.RING_HASH_CONFIG, hashConfigMap);
        }
        if (ringProperties.hasHashRingPointCleanupRate()) {
            ringPropertyMap.put(PropertyKeys.RING_HASH_RING_POINT_CLEANUP_RATE, ringProperties.getHashRingPointCleanupRate().toString());
        }
        if (ringProperties.hasConsistentHashAlgorithm()) {
            switch (ringProperties.getConsistentHashAlgorithm()) {
                case MULTI_PROBE: {
                    ringPropertyMap.put(PropertyKeys.RING_CONSISTENT_HASH_ALGORITHM, "multiProbe");
                    break;
                }
                case POINT_BASED: {
                    ringPropertyMap.put(PropertyKeys.RING_CONSISTENT_HASH_ALGORITHM, "pointBased");
                    break;
                }
                case DISTRIBUTION_BASED: {
                    ringPropertyMap.put(PropertyKeys.RING_CONSISTENT_HASH_ALGORITHM, "distributionBased");
                }
            }
        }
        if (ringProperties.hasNumberOfProbes()) {
            ringPropertyMap.put(PropertyKeys.RING_NUMBER_OF_PROBES, ringProperties.getNumberOfProbes().toString());
        }
        if (ringProperties.hasNumberOfPointsPerHost()) {
            ringPropertyMap.put(PropertyKeys.RING_NUMBER_OF_POINTS_PER_HOST, ringProperties.getNumberOfPointsPerHost().toString());
        }
        if (ringProperties.hasBoundedLoadBalancingFactor()) {
            ringPropertyMap.put(PropertyKeys.RING_BOUNDED_LOAD_BALANCING_FACTOR, ringProperties.getBoundedLoadBalancingFactor().toString());
        }
        return ringPropertyMap;
    }

    private static D2RingProperties toRingProperties(Map<String, Object> ringPropertyMap) {
        D2RingProperties ringProperties = new D2RingProperties();
        if (ringPropertyMap.containsKey(PropertyKeys.RING_POINTS_PER_WEIGHT)) {
            ringProperties.setPointsPerWeight(PropertyUtil.coerce(ringPropertyMap.get(PropertyKeys.RING_POINTS_PER_WEIGHT), Integer.class));
        }
        if (ringPropertyMap.containsKey(PropertyKeys.RING_HASH_METHOD)) {
            String hashMethod = (String)ringPropertyMap.get(PropertyKeys.RING_HASH_METHOD);
            if (HashMethod.URI_REGEX.name().equalsIgnoreCase(hashMethod) || "uriRegex".equalsIgnoreCase(hashMethod)) {
                ringProperties.setHashMethod(HashMethod.URI_REGEX);
            } else if (HashMethod.RANDOM.name().equalsIgnoreCase(hashMethod)) {
                ringProperties.setHashMethod(HashMethod.RANDOM);
            }
        }
        if (ringPropertyMap.containsKey(PropertyKeys.RING_HASH_CONFIG)) {
            HashConfig hashConfig = RelativeStrategyPropertiesConverter.toHashConfig((Map)ringPropertyMap.get(PropertyKeys.RING_HASH_CONFIG));
            ringProperties.setHashConfig(hashConfig);
        }
        if (ringPropertyMap.containsKey(PropertyKeys.RING_HASH_RING_POINT_CLEANUP_RATE)) {
            ringProperties.setHashRingPointCleanupRate(PropertyUtil.coerce(ringPropertyMap.get(PropertyKeys.RING_HASH_RING_POINT_CLEANUP_RATE), Double.class));
        }
        if (ringPropertyMap.containsKey(PropertyKeys.RING_CONSISTENT_HASH_ALGORITHM)) {
            String consistentHashAlgorithm = (String)ringPropertyMap.get(PropertyKeys.RING_CONSISTENT_HASH_ALGORITHM);
            if ("pointBased".equalsIgnoreCase(consistentHashAlgorithm)) {
                ringProperties.setConsistentHashAlgorithm(ConsistentHashAlgorithm.POINT_BASED);
            } else if ("multiProbe".equalsIgnoreCase(consistentHashAlgorithm)) {
                ringProperties.setConsistentHashAlgorithm(ConsistentHashAlgorithm.MULTI_PROBE);
            } else if ("distributionBased".equalsIgnoreCase(consistentHashAlgorithm)) {
                ringProperties.setConsistentHashAlgorithm(ConsistentHashAlgorithm.DISTRIBUTION_BASED);
            }
        }
        if (ringPropertyMap.containsKey(PropertyKeys.RING_NUMBER_OF_PROBES)) {
            ringProperties.setNumberOfProbes(PropertyUtil.coerce(ringPropertyMap.get(PropertyKeys.RING_NUMBER_OF_PROBES), Integer.class));
        }
        if (ringPropertyMap.containsKey(PropertyKeys.RING_NUMBER_OF_POINTS_PER_HOST)) {
            ringProperties.setNumberOfPointsPerHost(PropertyUtil.coerce(ringPropertyMap.get(PropertyKeys.RING_NUMBER_OF_POINTS_PER_HOST), Integer.class));
        }
        if (ringPropertyMap.containsKey(PropertyKeys.RING_BOUNDED_LOAD_BALANCING_FACTOR)) {
            ringProperties.setBoundedLoadBalancingFactor(PropertyUtil.coerce(ringPropertyMap.get(PropertyKeys.RING_BOUNDED_LOAD_BALANCING_FACTOR), Double.class));
        }
        return ringProperties;
    }

    public static Map<String, Object> toHashConfigMap(HashConfig hashConfig) {
        HashMap<String, Object> hashConfigMap = new HashMap<String, Object>();
        if (hashConfig.hasUriRegexes()) {
            hashConfigMap.put("regexes", hashConfig.getUriRegexes().stream().collect(Collectors.toList()));
        }
        if (hashConfig.hasFailOnNoMatch()) {
            hashConfigMap.put("failOnNoMatch", hashConfig.isFailOnNoMatch().toString());
        }
        if (hashConfig.hasWarnOnNoMatch()) {
            hashConfigMap.put("warnOnNoMatch", hashConfig.isWarnOnNoMatch().toString());
        }
        return hashConfigMap;
    }

    private static HashConfig toHashConfig(Map<String, Object> hashConfigMap) {
        HashConfig hashConfig = new HashConfig();
        if (hashConfigMap.containsKey("regexes")) {
            List uriRegexes = (List)hashConfigMap.get("regexes");
            hashConfig.setUriRegexes(new StringArray((Collection)uriRegexes));
        }
        if (hashConfigMap.containsKey("warnOnNoMatch")) {
            String warnOnNoMatchString = (String)hashConfigMap.get("warnOnNoMatch");
            hashConfig.setWarnOnNoMatch(Boolean.parseBoolean(warnOnNoMatchString));
        }
        if (hashConfigMap.containsKey("failOnNoMatch")) {
            String failOnNoMatchString = (String)hashConfigMap.get("failOnNoMatch");
            hashConfig.setFailOnNoMatch(Boolean.parseBoolean(failOnNoMatchString));
        }
        return hashConfig;
    }
}

