/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.common.util.MapUtil;
import com.linkedin.d2.D2TransportClientProperties;
import com.linkedin.d2.HttpProtocolVersionType;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.d2.poolStrategyType;
import com.linkedin.data.template.StringArray;
import com.linkedin.r2.util.ConfigValueExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class TransportClientPropertiesConverter {
    public static Map<String, Object> toProperties(D2TransportClientProperties config) {
        if (config == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> prop = new HashMap<String, Object>();
        if (config.hasQueryPostThreshold()) {
            prop.put("http.queryPostThreshold", config.getQueryPostThreshold().toString());
        }
        if (config.hasRequestTimeout()) {
            prop.put("http.requestTimeout", config.getRequestTimeout().toString());
        }
        if (config.hasStreamingTimeout()) {
            prop.put("http.streamingTimeout", config.getStreamingTimeout().toString());
        }
        if (config.hasMaxResponseSize()) {
            prop.put("http.maxResponseSize", config.getMaxResponseSize().toString());
        }
        if (config.hasPoolSize()) {
            prop.put("http.poolSize", config.getPoolSize().toString());
        }
        if (config.hasPoolWaiterSize()) {
            prop.put("http.poolWaiterSize", config.getPoolWaiterSize().toString());
        }
        if (config.hasIdleTimeout()) {
            prop.put("http.idleTimeout", config.getIdleTimeout().toString());
        }
        if (config.hasSslIdleTimeout()) {
            prop.put("http.sslIdleTimeout", config.getSslIdleTimeout().toString());
        }
        if (config.hasShutdownTimeout()) {
            prop.put("http.shutdownTimeout", config.getShutdownTimeout().toString());
        }
        if (config.hasGracefulShutdownTimeout()) {
            prop.put("http.gracefulShutdownTimeout", config.getGracefulShutdownTimeout().toString());
        }
        if (config.hasResponseCompressionOperations()) {
            prop.put("http.responseCompressionOperations", config.getResponseCompressionOperations().stream().collect(Collectors.joining(",")));
        }
        if (config.hasResponseContentEncodings()) {
            prop.put("http.responseContentEncodings", config.getResponseContentEncodings().stream().collect(Collectors.joining(",")));
        }
        if (config.hasRequestContentEncodings()) {
            prop.put("http.requestContentEncodings", config.getRequestContentEncodings().stream().collect(Collectors.joining(",")));
        }
        if (config.hasUseResponseCompression()) {
            prop.put("http.useResponseCompression", config.isUseResponseCompression().toString());
        }
        if (config.hasMaxHeaderSize()) {
            prop.put("http.maxHeaderSize", config.getMaxHeaderSize().toString());
        }
        if (config.hasMaxChunkSize()) {
            prop.put("http.maxChunkSize", config.getMaxChunkSize().toString());
        }
        if (config.hasPoolStrategy()) {
            prop.put("http.poolStrategy", config.getPoolStrategy().name());
        }
        if (config.hasMinPoolSize()) {
            prop.put("http.poolMinSize", config.getMinPoolSize().toString());
        }
        if (config.hasPoolStatsNamePrefix()) {
            prop.put("http.poolStatsNamePrefix", config.getPoolStatsNamePrefix());
        }
        if (config.hasMaxConcurrentConnections()) {
            prop.put("http.maxConcurrentConnections", config.getMaxConcurrentConnections().toString());
        }
        if (config.hasTcpNoDelay()) {
            prop.put("http.tcpNoDelay", config.isTcpNoDelay().toString());
        }
        if (config.hasProtocolVersion()) {
            prop.put("http.protocolVersion", config.getProtocolVersion().name());
        }
        if (!config.getAllowedClientOverrideKeys().isEmpty()) {
            prop.put("allowedClientOverrideKeys", config.getAllowedClientOverrideKeys().stream().collect(Collectors.joining(",")));
        }
        if (config.hasMaxClientRequestRetryRatio()) {
            prop.put("http.maxClientRequestRetryRatio", config.getMaxClientRequestRetryRatio().toString());
        }
        return prop;
    }

    public static D2TransportClientProperties toConfig(Map<String, Object> properties) {
        D2TransportClientProperties config = new D2TransportClientProperties();
        if (properties.containsKey("http.queryPostThreshold")) {
            config.setQueryPostThreshold(PropertyUtil.coerce(properties.get("http.queryPostThreshold"), Integer.class));
        }
        if (properties.containsKey("http.requestTimeout")) {
            config.setRequestTimeout(PropertyUtil.coerce(properties.get("http.requestTimeout"), Long.class));
        }
        if (properties.containsKey("http.streamingTimeout")) {
            config.setStreamingTimeout(PropertyUtil.coerce(properties.get("http.streamingTimeout"), Long.class));
        }
        if (properties.containsKey("http.maxResponseSize")) {
            config.setMaxResponseSize(PropertyUtil.coerce(properties.get("http.maxResponseSize"), Long.class));
        }
        if (properties.containsKey("http.poolSize")) {
            config.setPoolSize(PropertyUtil.coerce(properties.get("http.poolSize"), Integer.class));
        }
        if (properties.containsKey("http.poolWaiterSize")) {
            config.setPoolWaiterSize(PropertyUtil.coerce(properties.get("http.poolWaiterSize"), Integer.class));
        }
        if (properties.containsKey("http.idleTimeout")) {
            config.setIdleTimeout(PropertyUtil.coerce(properties.get("http.idleTimeout"), Long.class));
        }
        if (properties.containsKey("http.sslIdleTimeout")) {
            config.setSslIdleTimeout(PropertyUtil.coerce(properties.get("http.sslIdleTimeout"), Long.class));
        }
        if (properties.containsKey("http.shutdownTimeout")) {
            config.setShutdownTimeout(PropertyUtil.coerce(properties.get("http.shutdownTimeout"), Long.class));
        }
        if (properties.containsKey("http.gracefulShutdownTimeout")) {
            config.setGracefulShutdownTimeout(PropertyUtil.coerce(properties.get("http.gracefulShutdownTimeout"), Long.class));
        }
        if (properties.containsKey("http.responseCompressionOperations")) {
            config.setResponseCompressionOperations(new StringArray((Collection)ConfigValueExtractor.buildList((Object)properties.get("http.responseCompressionOperations"), (String)",")));
        }
        if (properties.containsKey("http.responseContentEncodings")) {
            config.setResponseContentEncodings(new StringArray((Collection)ConfigValueExtractor.buildList((Object)properties.get("http.responseContentEncodings"), (String)",")));
        }
        if (properties.containsKey("http.requestContentEncodings")) {
            config.setRequestContentEncodings(new StringArray((Collection)ConfigValueExtractor.buildList((Object)properties.get("http.requestContentEncodings"), (String)",")));
        }
        if (properties.containsKey("http.useResponseCompression")) {
            config.setUseResponseCompression((Boolean)MapUtil.getWithDefault(properties, (Object)"http.useResponseCompression", (Object)Boolean.TRUE));
        }
        if (properties.containsKey("http.maxHeaderSize")) {
            config.setMaxHeaderSize(PropertyUtil.coerce(properties.get("http.maxHeaderSize"), Integer.class));
        }
        if (properties.containsKey("http.maxChunkSize")) {
            config.setMaxChunkSize(PropertyUtil.coerce(properties.get("http.maxChunkSize"), Integer.class));
        }
        if (properties.containsKey("http.poolStrategy")) {
            config.setPoolStrategy(poolStrategyType.valueOf((String)((String)properties.get("http.poolStrategy"))));
        }
        if (properties.containsKey("http.poolMinSize")) {
            config.setMinPoolSize(PropertyUtil.coerce(properties.get("http.poolMinSize"), Integer.class));
        }
        if (properties.containsKey("http.poolStatsNamePrefix")) {
            config.setPoolStatsNamePrefix(PropertyUtil.coerce(properties.get("http.poolStatsNamePrefix"), String.class));
        }
        if (properties.containsKey("http.maxConcurrentConnections")) {
            config.setMaxConcurrentConnections(PropertyUtil.coerce(properties.get("http.maxConcurrentConnections"), Integer.class));
        }
        if (properties.containsKey("http.tcpNoDelay")) {
            config.setTcpNoDelay(PropertyUtil.coerce(properties.get("http.tcpNoDelay"), Boolean.class));
        }
        if (properties.containsKey("http.protocolVersion")) {
            config.setProtocolVersion(HttpProtocolVersionType.valueOf((String)((String)properties.get("http.protocolVersion"))));
        }
        if (properties.containsKey("allowedClientOverrideKeys")) {
            config.setAllowedClientOverrideKeys(new StringArray((Collection)ConfigValueExtractor.buildList((Object)properties.get("allowedClientOverrideKeys"), (String)",")));
        }
        if (properties.containsKey("http.maxClientRequestRetryRatio")) {
            config.setMaxClientRequestRetryRatio(PropertyUtil.coerce(properties.get("http.maxClientRequestRetryRatio"), Double.class));
        }
        return config;
    }
}

