/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class D2Monitor {
    private final String _serviceName;
    private final String _clusterName;
    private final ClusterStats _clusterStats;
    private final List<UriInfo> _uriList;
    private final int _partitionId;
    private final long _intervalMs;

    D2Monitor(String serviceName, String clusterName, ClusterStats clusterStats, List<UriInfo> uriList, int partitionId, long intervalMs) {
        this._serviceName = serviceName;
        this._clusterName = clusterName;
        this._clusterStats = clusterStats;
        this._uriList = Collections.unmodifiableList(new ArrayList<UriInfo>(uriList));
        this._partitionId = partitionId;
        this._intervalMs = intervalMs;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public List<UriInfo> getUriList() {
        return this._uriList;
    }

    public ClusterStats getClusterStats() {
        return this._clusterStats;
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public long getIntervalMs() {
        return this._intervalMs;
    }

    public String toString() {
        return "D2Monitor (service=" + this._serviceName + "),(cluster=" + this._clusterName + "),(clusterStats=" + this._clusterStats + "),[Uris: " + this._uriList + "](_intervalMs=" + this._intervalMs + ")";
    }

    public static class UriInfo {
        private final String _hostName;
        private final int _portNumber;
        private final long _currentCallCount;
        private final long _totalCallCount;
        private final long _outstandingCount;
        private final double _currentAvgLatency;
        private final int _currentErrorCount;
        private final long _50PctLatency;
        private final long _90PctLatency;
        private final long _95PctLatency;
        private final long _99PctLatency;
        private final long _quarantineDuration;
        private final double _computedDropRate;
        private final int _transmissionPoints;

        UriInfo(String hostName, int portNumber, long callCount, long totalCallCount, long outstandingCount, double currentAvgLatency, int errorCount, long a50PctLatency, long a90PctLatency, long a95PctLatency, long a99PctLatency, long quarantineDuration, double computedDropRate, int transmissionPoints) {
            this._hostName = hostName;
            this._portNumber = portNumber;
            this._currentCallCount = callCount;
            this._totalCallCount = totalCallCount;
            this._outstandingCount = outstandingCount;
            this._currentAvgLatency = currentAvgLatency;
            this._currentErrorCount = errorCount;
            this._50PctLatency = a50PctLatency;
            this._90PctLatency = a90PctLatency;
            this._95PctLatency = a95PctLatency;
            this._99PctLatency = a99PctLatency;
            this._quarantineDuration = quarantineDuration;
            this._computedDropRate = computedDropRate;
            this._transmissionPoints = transmissionPoints;
        }

        public String getHostName() {
            return this._hostName;
        }

        public int getPortNumber() {
            return this._portNumber;
        }

        public long getCurrentCallCount() {
            return this._currentCallCount;
        }

        public double getCurrentAvgLatency() {
            return this._currentAvgLatency;
        }

        public int getCurrentErrorCount() {
            return this._currentErrorCount;
        }

        public long getTotalCallCount() {
            return this._totalCallCount;
        }

        public long getOutstandingCount() {
            return this._outstandingCount;
        }

        public long get50PctLatency() {
            return this._50PctLatency;
        }

        public long get90PctLatency() {
            return this._90PctLatency;
        }

        public long get95PctLatency() {
            return this._95PctLatency;
        }

        public long get99PctLatency() {
            return this._99PctLatency;
        }

        public long getQuarantineDuration() {
            return this._quarantineDuration;
        }

        public double getComputedDropRate() {
            return this._computedDropRate;
        }

        public int getTransmissionPoints() {
            return this._transmissionPoints;
        }

        public String toString() {
            return "(uri:" + this._hostName + ':' + this._portNumber + ", callCount:" + this._currentCallCount + ", outstandingCount:" + this._outstandingCount + ", errorCount:" + this._currentErrorCount + ", quarantineDuration:" + this._quarantineDuration + ", computedDropRate:" + this._computedDropRate + ", transmissionPoints:" + this._transmissionPoints + ", 50PctLatency:" + this._50PctLatency + ", 90PctLatency:" + this._90PctLatency + ", 95PctLatency:" + this._95PctLatency + ", 99PctLatency:" + this._99PctLatency + ", currentAvgLatency: " + this._currentAvgLatency + ")";
        }
    }

    public static class ClusterStats {
        private final long _clusterCallCount;
        private final double _clusterAverageLatency;
        private final long _clusterDroppedCalls;
        private final long _clusterErrorCount;
        private final long _clusterFailedRouteCalls;
        private final double _clusterDropLevel;
        private final int _clusterNumHosts;

        ClusterStats(long callCount, double averageLatency, long droppedCalls, long clusterErrorCount, long failedToRoute, double dropLevel, int clusterNumHosts) {
            this._clusterCallCount = callCount;
            this._clusterAverageLatency = averageLatency;
            this._clusterDroppedCalls = droppedCalls;
            this._clusterErrorCount = clusterErrorCount;
            this._clusterFailedRouteCalls = failedToRoute;
            this._clusterDropLevel = dropLevel;
            this._clusterNumHosts = clusterNumHosts;
        }

        public long getClusterCallCount() {
            return this._clusterCallCount;
        }

        public double getClusterAverageLatency() {
            return this._clusterAverageLatency;
        }

        public long getClusterDroppedCalls() {
            return this._clusterDroppedCalls;
        }

        public long getClusterErrorCount() {
            return this._clusterErrorCount;
        }

        public long getClusterFailedRouteCalls() {
            return this._clusterFailedRouteCalls;
        }

        public double getClusterDropLevel() {
            return this._clusterDropLevel;
        }

        public int getClusterNumHosts() {
            return this._clusterNumHosts;
        }

        public String toString() {
            return "(clusterCallCount:" + this._clusterCallCount + ", clusterAverageLatency:" + this._clusterAverageLatency + ", clusterErrorCount:" + this._clusterErrorCount + ", clusterDropLevel:" + this._clusterDropLevel + ", clusterNumHosts:" + this._clusterNumHosts + ")";
        }
    }
}

