/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.event;

import com.linkedin.d2.balancer.event.D2Monitor;
import com.linkedin.util.degrader.CallTracker;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class D2MonitorBuilder {
    private final String _serviceName;
    private final String _clusterName;
    private final D2MonitorClusterStatsBuilder _clusterStatsBuilder;
    private final Map<URI, D2MonitorUriInfoBuilder> _uriInfoBuilderMap;
    private final int _partitionId;

    public D2MonitorBuilder(String serviceName, String clusterName, int partitionId) {
        this._serviceName = serviceName;
        this._clusterName = clusterName;
        this._clusterStatsBuilder = new D2MonitorClusterStatsBuilder();
        this._uriInfoBuilderMap = new HashMap<URI, D2MonitorUriInfoBuilder>();
        this._partitionId = partitionId;
    }

    public D2MonitorClusterStatsBuilder getClusterStatsBuilder() {
        return this._clusterStatsBuilder;
    }

    public D2MonitorUriInfoBuilder getOrCreateUriInfoBuilder(URI uri) {
        return this._uriInfoBuilderMap.computeIfAbsent(uri, k -> new D2MonitorUriInfoBuilder((URI)k));
    }

    public D2MonitorUriInfoBuilder addUriInfoBuilder(URI uri, D2MonitorUriInfoBuilder uriInfoBuilder) {
        return this._uriInfoBuilderMap.putIfAbsent(uri, uriInfoBuilder);
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public Map<URI, D2MonitorUriInfoBuilder> getUriInfoBuilderMap() {
        return this._uriInfoBuilderMap;
    }

    public D2MonitorBuilder reset() {
        this._clusterStatsBuilder.reset();
        this._uriInfoBuilderMap.clear();
        return this;
    }

    public final D2Monitor build(long intervalMs) {
        return new D2Monitor(this._serviceName, this._clusterName, this._clusterStatsBuilder.build(), this._uriInfoBuilderMap.values().stream().map(D2MonitorUriInfoBuilder::build).collect(Collectors.toList()), this._partitionId, intervalMs);
    }

    public void removeUri(Set<URI> uris) {
        this._uriInfoBuilderMap.entrySet().removeIf(e -> !uris.contains(e.getKey()));
    }

    public static class D2MonitorUriInfoBuilder {
        private final URI _uri;
        private long _currentCallCount;
        private long _totalCallCount;
        private long _outstandingCount;
        private double _currentLatency;
        private int _currentErrorCount;
        private long _50PctLatency;
        private long _90PctLatency;
        private long _95PctLatency;
        private long _99PctLatency;
        private long _quarantineDuration;
        private double _computedDropRate;
        private int _transmissionPoints;

        public D2MonitorUriInfoBuilder(URI uri) {
            this._uri = uri;
            this.reset();
        }

        public void reset() {
            this._currentCallCount = 0L;
            this._totalCallCount = 0L;
            this._outstandingCount = 0L;
            this._currentLatency = 0.0;
            this._currentErrorCount = 0;
            this._50PctLatency = 0L;
            this._90PctLatency = 0L;
            this._95PctLatency = 0L;
            this._99PctLatency = 0L;
            this._quarantineDuration = 0L;
            this._computedDropRate = 0.0;
            this._transmissionPoints = 0;
        }

        public URI getUri() {
            return this._uri;
        }

        public D2MonitorUriInfoBuilder setCurrentCallCount(long currentCallCount) {
            this._currentCallCount = currentCallCount;
            return this;
        }

        public D2MonitorUriInfoBuilder setCurrentLatency(double currentLatency) {
            this._currentLatency = currentLatency;
            return this;
        }

        public D2MonitorUriInfoBuilder setCurrentErrorCount(int currentErrorCount) {
            this._currentErrorCount = currentErrorCount;
            return this;
        }

        public D2MonitorUriInfoBuilder setTotalCallCount(long totalCallCount) {
            this._totalCallCount = totalCallCount;
            return this;
        }

        public D2MonitorUriInfoBuilder setOutstandingCount(long outstandingCount) {
            this._outstandingCount = outstandingCount;
            return this;
        }

        public D2MonitorUriInfoBuilder set50PctLatency(long a50PctLatency) {
            this._50PctLatency = a50PctLatency;
            return this;
        }

        public D2MonitorUriInfoBuilder set90PctLatency(long a90PctLatency) {
            this._90PctLatency = a90PctLatency;
            return this;
        }

        public D2MonitorUriInfoBuilder set95PctLatency(long a95PctLatency) {
            this._95PctLatency = a95PctLatency;
            return this;
        }

        public D2MonitorUriInfoBuilder setQuarantineDuration(long quarantineDuration) {
            this._quarantineDuration = quarantineDuration;
            return this;
        }

        public D2MonitorUriInfoBuilder set99PctLatency(long a99PctLatency) {
            this._99PctLatency = a99PctLatency;
            return this;
        }

        public D2MonitorUriInfoBuilder setComputedDropRate(double computedDropRate) {
            this._computedDropRate = computedDropRate;
            return this;
        }

        public D2MonitorUriInfoBuilder setTransmissionPoints(int transmissionPoints) {
            this._transmissionPoints = transmissionPoints;
            return this;
        }

        public D2Monitor.UriInfo build() {
            return new D2Monitor.UriInfo(this._uri.getHost(), this._uri.getPort(), this._currentCallCount, this._totalCallCount, this._outstandingCount, this._currentLatency, this._currentErrorCount, this._50PctLatency, this._90PctLatency, this._95PctLatency, this._99PctLatency, this._quarantineDuration, this._computedDropRate, this._transmissionPoints);
        }

        public void copyStats(CallTracker.CallStats callStats) {
            int callCount = callStats.getCallCount();
            this.setCurrentCallCount(callCount).setCurrentLatency(callStats.getCallTimeStats().getAverage()).setTotalCallCount(callStats.getCallCountTotal()).setCurrentErrorCount((int)(callStats.getErrorRate() * (double)callCount)).setOutstandingCount(callStats.getOutstandingCount()).set50PctLatency(callStats.getCallTimeStats().get50Pct()).set90PctLatency(callStats.getCallTimeStats().get90Pct()).set95PctLatency(callStats.getCallTimeStats().get95Pct()).set99PctLatency(callStats.getCallTimeStats().get99Pct());
        }
    }

    public static class D2MonitorClusterStatsBuilder {
        private long _clusterCurrentCallCount;
        private double _clusterCurrentAverageLatencyMs;
        private long _clusterCurrentDroppedCalls;
        private long _clusterCurrentErrorCount;
        private long _clusterCurrentFailedToRouteCalls;
        private double _clusterDropLevel;
        private int _clusterNumHosts;

        public D2MonitorClusterStatsBuilder setClusterCurrentCallCount(long clusterCurrentCallCount) {
            this._clusterCurrentCallCount = clusterCurrentCallCount;
            return this;
        }

        public D2MonitorClusterStatsBuilder setClusterCurrentAverageLatencyMs(double clusterCurrentAverageLatencyMs) {
            this._clusterCurrentAverageLatencyMs = clusterCurrentAverageLatencyMs;
            return this;
        }

        public D2MonitorClusterStatsBuilder setClusterCurrentDroppedCalls(long clusterCurrentDroppedCalls) {
            this._clusterCurrentDroppedCalls = clusterCurrentDroppedCalls;
            return this;
        }

        public D2MonitorClusterStatsBuilder setClusterCurrentErrorCount(long clusterCurrentErrorCount) {
            this._clusterCurrentErrorCount = clusterCurrentErrorCount;
            return this;
        }

        public D2MonitorClusterStatsBuilder setClusterDropLevel(double clusterDropLevel) {
            this._clusterDropLevel = clusterDropLevel;
            return this;
        }

        public D2MonitorClusterStatsBuilder setClusterCurrentFailedToRouteCalls(long clusterCurrentFailedToRouteCalls) {
            this._clusterCurrentFailedToRouteCalls = clusterCurrentFailedToRouteCalls;
            return this;
        }

        public D2MonitorClusterStatsBuilder setClusterNumHosts(int clusterNumHosts) {
            this._clusterNumHosts = clusterNumHosts;
            return this;
        }

        public void reset() {
            this._clusterCurrentAverageLatencyMs = 0.0;
            this._clusterCurrentCallCount = 0L;
            this._clusterCurrentDroppedCalls = 0L;
            this._clusterCurrentErrorCount = 0L;
            this._clusterCurrentFailedToRouteCalls = 0L;
            this._clusterDropLevel = 0.0;
            this._clusterNumHosts = 0;
        }

        public D2Monitor.ClusterStats build() {
            return new D2Monitor.ClusterStats(this._clusterCurrentCallCount, this._clusterCurrentAverageLatencyMs, this._clusterCurrentDroppedCalls, this._clusterCurrentErrorCount, this._clusterCurrentFailedToRouteCalls, this._clusterDropLevel, this._clusterNumHosts);
        }
    }
}

