/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.event;

import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.event.D2MonitorBuilder;
import com.linkedin.d2.balancer.event.EventEmitter;
import com.linkedin.d2.balancer.strategies.LoadBalancerQuarantine;
import com.linkedin.util.clock.Clock;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class D2MonitorEventEmitter {
    public static final int MAX_HEALTHY_HOSTS_TO_EMIT = 2;
    private final int _partitionId;
    private final String _clusterName;
    private final String _serviceName;
    private final Clock _clock;
    private final EventEmitter _eventEmitter;
    private final long _emittingInterval;
    private final int _pointsPerWeight;
    private long _lastEmittingTimeStamp;

    public D2MonitorEventEmitter(String clusterName, String serviceName, int partitionId, Clock clock, EventEmitter eventEmitter, long emittingInterval, int pointsPerWeight) {
        this._partitionId = partitionId;
        this._lastEmittingTimeStamp = clock.currentTimeMillis();
        this._clusterName = clusterName;
        this._serviceName = serviceName;
        this._clock = clock;
        this._eventEmitter = eventEmitter;
        this._emittingInterval = emittingInterval;
        this._pointsPerWeight = pointsPerWeight;
    }

    public void emitEvent(ClusterStatsProvider clusterStatsProvider) {
        D2MonitorBuilder builder = new D2MonitorBuilder(this._serviceName, this._clusterName, this._partitionId);
        D2MonitorBuilder.D2MonitorClusterStatsBuilder clusterStatsBuilder = builder.getClusterStatsBuilder();
        clusterStatsBuilder.setClusterNumHosts(clusterStatsProvider._trackerClients.size()).setClusterCurrentCallCount(clusterStatsProvider._clusterCallCount).setClusterCurrentAverageLatencyMs(clusterStatsProvider._averageLatencyMs).setClusterCurrentDroppedCalls(clusterStatsProvider._droppedCalls).setClusterCurrentErrorCount(clusterStatsProvider._errorCount).setClusterDropLevel(clusterStatsProvider._dropLevel);
        long currentTime = this._clock.currentTimeMillis();
        long intervalMs = currentTime - this._lastEmittingTimeStamp;
        if (this.allowedToEmit(intervalMs)) {
            this.createD2MonitorEvent(clusterStatsProvider._trackerClients, builder, clusterStatsProvider._pointsMap, clusterStatsProvider._quarantineMap);
            this._eventEmitter.emitEvent(builder.build(intervalMs));
            this._lastEmittingTimeStamp = currentTime;
        }
    }

    private boolean allowedToEmit(long intervalMs) {
        return intervalMs >= this._emittingInterval;
    }

    private boolean isClientHealthy(TrackerClient trackerClient, Map<URI, Integer> pointsMap) {
        int perfectHealth = (int)(trackerClient.getPartitionWeight(this._partitionId) * trackerClient.getSubsetWeight(this._partitionId) * (double)this._pointsPerWeight);
        return pointsMap.get(trackerClient.getUri()) >= perfectHealth;
    }

    private void createD2MonitorEvent(Set<TrackerClient> trackerClients, D2MonitorBuilder d2MonitorBuilder, Map<URI, Integer> pointsMap, Map<TrackerClient, LoadBalancerQuarantine> quarantineMap) {
        ArrayList<TrackerClient> healthyClients = new ArrayList<TrackerClient>();
        for (TrackerClient client : trackerClients) {
            if (!pointsMap.containsKey(client.getUri())) continue;
            if (this.isClientHealthy(client, pointsMap)) {
                healthyClients.add(client);
                continue;
            }
            d2MonitorBuilder.addUriInfoBuilder(client.getUri(), this.createUriInfoBuilder(client, pointsMap, quarantineMap));
        }
        if (!healthyClients.isEmpty()) {
            this.addRandomClientsToUriInfo(healthyClients, d2MonitorBuilder, pointsMap, quarantineMap);
        }
    }

    private void addRandomClientsToUriInfo(List<TrackerClient> healthyClients, D2MonitorBuilder builder, Map<URI, Integer> pointsMap, Map<TrackerClient, LoadBalancerQuarantine> quarantineMap) {
        Random random = new Random();
        for (int i = 0; i < Math.min(2, healthyClients.size()); ++i) {
            Collections.swap(healthyClients, i, random.nextInt(healthyClients.size() - i) + i);
            TrackerClient nextClient = healthyClients.get(i);
            builder.addUriInfoBuilder(nextClient.getUri(), this.createUriInfoBuilder(nextClient, pointsMap, quarantineMap));
        }
    }

    private D2MonitorBuilder.D2MonitorUriInfoBuilder createUriInfoBuilder(TrackerClient client, Map<URI, Integer> pointsMap, Map<TrackerClient, LoadBalancerQuarantine> quarantineMap) {
        D2MonitorBuilder.D2MonitorUriInfoBuilder uriInfoBuilder = new D2MonitorBuilder.D2MonitorUriInfoBuilder(client.getUri());
        uriInfoBuilder.copyStats(client.getLatestCallStats());
        uriInfoBuilder.setTransmissionPoints(pointsMap.get(client.getUri()));
        LoadBalancerQuarantine quarantine = quarantineMap.get(client);
        if (quarantine != null) {
            uriInfoBuilder.setQuarantineDuration(quarantine.getTimeTilNextCheck());
        }
        return uriInfoBuilder;
    }

    public static class ClusterStatsProvider {
        private final Map<URI, Integer> _pointsMap;
        private final Map<TrackerClient, LoadBalancerQuarantine> _quarantineMap;
        private final Set<TrackerClient> _trackerClients;
        private final long _clusterCallCount;
        private final double _averageLatencyMs;
        private final long _droppedCalls;
        private final long _errorCount;
        private final double _dropLevel;

        public ClusterStatsProvider(Map<URI, Integer> pointsMap, Map<TrackerClient, LoadBalancerQuarantine> quarantineMap, Set<TrackerClient> trackerClients, long clusterCallCount, double averageLatencyMs, long droppedCalls, long errorCount, double dropLevel) {
            this._pointsMap = pointsMap;
            this._quarantineMap = quarantineMap;
            this._trackerClients = trackerClients;
            this._clusterCallCount = clusterCallCount;
            this._averageLatencyMs = averageLatencyMs;
            this._droppedCalls = droppedCalls;
            this._errorCount = errorCount;
            this._dropLevel = dropLevel;
        }
    }
}

