/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import java.util.HashSet;
import java.util.Set;

public enum AllowedClientPropertyKeys {
    HTTP_QUERY_POST_THRESHOLD("http.queryPostThreshold"),
    HTTP_POOL_SIZE("http.poolSize"),
    HTTP_REQUEST_TIMEOUT("http.requestTimeout"),
    HTTP_IDLE_TIMEOUT("http.idleTimeout"),
    HTTP_SSL_IDLE_TIMEOUT("http.sslIdleTimeout"),
    HTTP_MAX_RESPONSE_SIZE("http.maxResponseSize"),
    HTTP_SHUTDOWN_TIMEOUT("http.shutdownTimeout"),
    HTTP_RESPONSE_COMPRESSION_OPERATIONS("http.responseCompressionOperations"),
    HTTP_USE_RESPONSE_COMPRESSION("http.useResponseCompression"),
    HTTP_POOL_WAITER_SIZE("http.poolWaiterSize"),
    HTTP_POOL_MIN_SIZE("http.poolMinSize"),
    HTTP_POOL_STATS_NAME_PREFIX("http.poolStatsNamePrefix"),
    HTTP_REQUEST_CONTENT_ENCODINGS("http.requestContentEncodings"),
    HTTP_PROTOCOL_VERSION("http.protocolVersion"),
    HTTP_STREAMING_TIMEOUT("http.streamingTimeout");

    private static final Set<String> _allowedKeys;
    private final String _keyName;

    private AllowedClientPropertyKeys(String keyName) {
        this._keyName = keyName;
    }

    public String getKeyName() {
        return this._keyName;
    }

    public static boolean isAllowedConfigKey(String key) {
        return _allowedKeys.contains(key);
    }

    static {
        _allowedKeys = new HashSet<String>();
        for (AllowedClientPropertyKeys propertyKey : AllowedClientPropertyKeys.values()) {
            _allowedKeys.add(propertyKey._keyName);
        }
    }
}

