/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServiceConfigValidator {
    private static final Logger _log = LoggerFactory.getLogger(ClientServiceConfigValidator.class);

    public static boolean isValidValue(Map<String, Object> serviceSuppliedConfig, Map<String, Object> clientSuppliedServiceConfig, String propertyName) {
        if (propertyName.equals("http.requestTimeout")) {
            String clientSuppliedTimeout = (String)clientSuppliedServiceConfig.get(propertyName);
            String serviceSuppliedTimeout = (String)serviceSuppliedConfig.get(propertyName);
            try {
                return Integer.parseInt(clientSuppliedTimeout) >= Integer.parseInt(serviceSuppliedTimeout);
            }
            catch (NumberFormatException e) {
                _log.error("Failed to convert HTTP Request Timeout to an int. clientSuppliedTimeout is " + clientSuppliedTimeout + ". serviceSuppliedTimeout is " + serviceSuppliedTimeout, (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

