/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.DarkClusterConfigMap;
import com.linkedin.d2.balancer.config.DarkClustersConverter;
import com.linkedin.d2.balancer.properties.NullPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterProperties {
    public static final float DARK_CLUSTER_DEFAULT_MULTIPLIER = 0.0f;
    public static final float DARK_CLUSTER_DEFAULT_TARGET_RATE = 0.0f;
    public static final int DARK_CLUSTER_DEFAULT_MAX_REQUESTS_TO_BUFFER = 1;
    public static final int DARK_CLUSTER_DEFAULT_BUFFERED_REQUEST_EXPIRY_IN_SECONDS = 1;
    private final String _clusterName;
    private final Map<String, String> _properties;
    private final PartitionProperties _partitionProperties;
    private final List<String> _sslSessionValidationStrings;
    private final Set<URI> _bannedUris;
    @Deprecated
    private final List<String> _prioritizedSchemes;
    private final Map<String, Object> _darkClusters;
    private final boolean _delegated;

    public ClusterProperties(String clusterName) {
        this(clusterName, Collections.emptyList());
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes) {
        this(clusterName, prioritizedSchemes, Collections.emptyMap());
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties) {
        this(clusterName, prioritizedSchemes, properties, new HashSet<URI>());
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris) {
        this(clusterName, prioritizedSchemes, properties, bannedUris, NullPartitionProperties.getInstance());
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties) {
        this(clusterName, prioritizedSchemes, properties, bannedUris, partitionProperties, Collections.emptyList());
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties, List<String> sslSessionValidationStrings) {
        this(clusterName, prioritizedSchemes, properties, bannedUris, partitionProperties, sslSessionValidationStrings, (Map<String, Object>)null, false);
    }

    @Deprecated
    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties, List<String> sslSessionValidationStrings, DarkClusterConfigMap darkClusters) {
        this(clusterName, prioritizedSchemes, properties, bannedUris, partitionProperties, sslSessionValidationStrings, (Map<String, Object>)null, false);
    }

    @Deprecated
    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties, List<String> sslSessionValidationStrings, DarkClusterConfigMap darkClusters, boolean delegated) {
        this(clusterName, prioritizedSchemes, properties, bannedUris, partitionProperties, sslSessionValidationStrings, (Map<String, Object>)null, false);
    }

    public ClusterProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties, List<String> sslSessionValidationStrings, Map<String, Object> darkClusters, boolean delegated) {
        this._clusterName = clusterName;
        this._prioritizedSchemes = prioritizedSchemes != null ? Collections.unmodifiableList(prioritizedSchemes) : Collections.emptyList();
        this._properties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
        this._bannedUris = bannedUris != null ? Collections.unmodifiableSet(bannedUris) : Collections.emptySet();
        this._partitionProperties = partitionProperties;
        this._sslSessionValidationStrings = sslSessionValidationStrings == null ? Collections.emptyList() : Collections.unmodifiableList(sslSessionValidationStrings);
        this._darkClusters = darkClusters == null ? new HashMap() : darkClusters;
        this._delegated = delegated;
    }

    public ClusterProperties(ClusterProperties other) {
        this(other._clusterName, other._prioritizedSchemes, other._properties, other._bannedUris, other._partitionProperties, other._sslSessionValidationStrings, other._darkClusters, other._delegated);
    }

    public boolean isBanned(URI uri) {
        return this._bannedUris.contains(uri);
    }

    public Set<URI> getBannedUris() {
        return this._bannedUris;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public List<String> getPrioritizedSchemes() {
        return this._prioritizedSchemes;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public PartitionProperties getPartitionProperties() {
        return this._partitionProperties;
    }

    public List<String> getSslSessionValidationStrings() {
        return this._sslSessionValidationStrings;
    }

    public Map<String, Object> getDarkClusters() {
        return this._darkClusters;
    }

    public DarkClusterConfigMap accessDarkClusters() {
        return DarkClustersConverter.toConfig(this._darkClusters);
    }

    public boolean isDelegated() {
        return this._delegated;
    }

    public String toString() {
        return "ClusterProperties [_clusterName=" + this._clusterName + ", _prioritizedSchemes=" + this._prioritizedSchemes + ", _properties=" + this._properties + ", _bannedUris=" + this._bannedUris + ", _partitionProperties=" + this._partitionProperties + ", _sslSessionValidationStrings=" + this._sslSessionValidationStrings + ", _darkClusterConfigMap=" + this._darkClusters + ", _delegated=" + this._delegated + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._bannedUris == null ? 0 : this._bannedUris.hashCode());
        result = 31 * result + (this._clusterName == null ? 0 : this._clusterName.hashCode());
        result = 31 * result + (this._prioritizedSchemes == null ? 0 : this._prioritizedSchemes.hashCode());
        result = 31 * result + (this._properties == null ? 0 : this._properties.hashCode());
        result = 31 * result + (this._partitionProperties == null ? 0 : this._partitionProperties.hashCode());
        result = 31 * result + (this._sslSessionValidationStrings == null ? 0 : this._sslSessionValidationStrings.hashCode());
        result = 31 * result + (this._darkClusters == null ? 0 : this._darkClusters.hashCode());
        result = 31 * result + (this._delegated ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterProperties other = (ClusterProperties)obj;
        if (!this._bannedUris.equals(other._bannedUris)) {
            return false;
        }
        if (!this._clusterName.equals(other._clusterName)) {
            return false;
        }
        if (!this._prioritizedSchemes.equals(other._prioritizedSchemes)) {
            return false;
        }
        if (!this._properties.equals(other._properties)) {
            return false;
        }
        if (!this._partitionProperties.equals(other._partitionProperties)) {
            return false;
        }
        if (!this._darkClusters.equals(other._darkClusters)) {
            return false;
        }
        if (this._delegated != other._delegated) {
            return false;
        }
        return this._sslSessionValidationStrings.equals(other._sslSessionValidationStrings);
    }
}

