/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.CanaryDistributionStrategy;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.ClusterStoreProperties;
import com.linkedin.d2.balancer.properties.CustomizedPartitionProperties;
import com.linkedin.d2.balancer.properties.FailoutProperties;
import com.linkedin.d2.balancer.properties.HashBasedPartitionProperties;
import com.linkedin.d2.balancer.properties.NullPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.d2.balancer.properties.RangeBasedPartitionProperties;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.d2.balancer.util.JacksonUtil;
import com.linkedin.d2.discovery.PropertyBuilder;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterPropertiesJsonSerializer
implements PropertySerializer<ClusterProperties>,
PropertyBuilder<ClusterProperties> {
    private static final Logger _log = LoggerFactory.getLogger(ClusterPropertiesJsonSerializer.class);

    @Override
    public byte[] toBytes(ClusterProperties property) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsString((Object)property).getBytes("UTF-8");
        }
        catch (Exception e) {
            _log.error("Failed to write property to bytes: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public ClusterProperties fromBytes(byte[] bytes) throws PropertySerializationException {
        try {
            Map untyped = (Map)JacksonUtil.getObjectMapper().readValue(new String(bytes, "UTF-8"), HashMap.class);
            return this.fromMap(untyped);
        }
        catch (Exception e) {
            throw new PropertySerializationException(e);
        }
    }

    private static <T> T mapGetOrDefault(Map<String, Object> map, String key, T defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    @Override
    public ClusterProperties fromMap(Map<String, Object> map) {
        ClusterProperties stableConfigs = this.buildClusterPropertiesFromMap(map);
        ClusterProperties canaryConfigs = null;
        CanaryDistributionStrategy distributionStrategy = null;
        FailoutProperties failoutProperties = null;
        Map canaryConfigsMap = (Map)PropertyUtil.mapGet(map, "canaryConfigs");
        Map distributionStrategyMap = (Map)PropertyUtil.mapGet(map, "canaryDistributionStrategy");
        Map clusterFailoutMap = (Map)PropertyUtil.mapGet(map, "failoutProperties");
        if (canaryConfigsMap != null && !canaryConfigsMap.isEmpty() && distributionStrategyMap != null && !distributionStrategyMap.isEmpty()) {
            canaryConfigs = this.buildClusterPropertiesFromMap(canaryConfigsMap);
            distributionStrategy = new CanaryDistributionStrategy(ClusterPropertiesJsonSerializer.mapGetOrDefault(distributionStrategyMap, "strategy", "disabled"), ClusterPropertiesJsonSerializer.mapGetOrDefault(distributionStrategyMap, "percentageStrategyProperties", Collections.emptyMap()), ClusterPropertiesJsonSerializer.mapGetOrDefault(distributionStrategyMap, "targetHostsStrategyProperties", Collections.emptyMap()), ClusterPropertiesJsonSerializer.mapGetOrDefault(distributionStrategyMap, "targetApplicationsStrategyProperties", Collections.emptyMap()));
        }
        if (clusterFailoutMap != null && !clusterFailoutMap.isEmpty()) {
            failoutProperties = new FailoutProperties(ClusterPropertiesJsonSerializer.mapGetOrDefault(clusterFailoutMap, "failoutRedirectConfigs", Collections.emptyList()), ClusterPropertiesJsonSerializer.mapGetOrDefault(clusterFailoutMap, "failoutBucketConfigs", Collections.emptyList()));
        }
        return new ClusterStoreProperties(stableConfigs, canaryConfigs, distributionStrategy, failoutProperties);
    }

    private ClusterProperties buildClusterPropertiesFromMap(Map<String, Object> map) {
        PartitionProperties partitionProperties;
        List bannedList = (List)PropertyUtil.mapGet(map, "bannedUris");
        Set<URI> banned = bannedList == null ? Collections.emptySet() : bannedList.stream().map(URI::create).collect(Collectors.toSet());
        String clusterName = PropertyUtil.checkAndGetValue(map, "clusterName", String.class, "ClusterProperties");
        List prioritizedSchemes = (List)PropertyUtil.mapGet(map, "prioritizedSchemes");
        Map properties = (Map)PropertyUtil.mapGet(map, "properties");
        Map partitionPropertiesMap = (Map)PropertyUtil.mapGet(map, "partitionProperties");
        String scope = "cluster: " + clusterName;
        List validationList = (List)PropertyUtil.mapGet(map, "sslSessionValidationStrings");
        if (partitionPropertiesMap != null) {
            PartitionProperties.PartitionType partitionType = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionType", PartitionProperties.PartitionType.class, scope);
            switch (partitionType) {
                case RANGE: {
                    long keyRangeStart = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "keyRangeStart", Number.class, scope).longValue();
                    long partitionSize = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionSize", Number.class, scope).longValue();
                    int partitionCount = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionCount", Number.class, scope).intValue();
                    String partitionKeyRegex = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionKeyRegex", String.class, scope);
                    partitionProperties = new RangeBasedPartitionProperties(partitionKeyRegex, keyRangeStart, partitionSize, partitionCount);
                    break;
                }
                case HASH: {
                    int partitionCount = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionCount", Number.class, scope).intValue();
                    String partitionKeyRegex = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionKeyRegex", String.class, scope);
                    HashBasedPartitionProperties.HashAlgorithm algorithm = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "hashAlgorithm", HashBasedPartitionProperties.HashAlgorithm.class, scope);
                    partitionProperties = new HashBasedPartitionProperties(partitionKeyRegex, partitionCount, algorithm);
                    break;
                }
                case CUSTOM: {
                    int partitionCount = partitionPropertiesMap.containsKey("partitionCount") ? PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionCount", Number.class, scope).intValue() : 0;
                    List partitionAccessorList = partitionPropertiesMap.containsKey("partitionAccessorList") ? PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionAccessorList", List.class, scope) : Collections.emptyList();
                    partitionProperties = new CustomizedPartitionProperties(partitionCount, partitionAccessorList);
                    break;
                }
                case NONE: {
                    partitionProperties = NullPartitionProperties.getInstance();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("In " + scope + ": Unsupported partitionType: " + (Object)((Object)partitionType));
                }
            }
        } else {
            partitionProperties = NullPartitionProperties.getInstance();
        }
        Map darkClusterProperty = (Map)map.get("darkClusters");
        boolean delegated = false;
        if (map.containsKey("delegated")) {
            delegated = (Boolean)PropertyUtil.mapGet(map, "delegated");
        }
        return new ClusterProperties(clusterName, (List<String>)prioritizedSchemes, (Map<String, String>)properties, banned, partitionProperties, (List<String>)validationList, darkClusterProperty, delegated);
    }
}

