/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.CanaryDistributionStrategy;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.FailoutProperties;
import com.linkedin.d2.balancer.properties.NullPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.d2.balancer.util.canary.CanaryDistributionProvider;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterStoreProperties
extends ClusterProperties {
    protected final ClusterProperties _canaryConfigs;
    protected final CanaryDistributionStrategy _canaryDistributionStrategy;
    protected final FailoutProperties _failoutProperties;

    public ClusterStoreProperties(String clusterName) {
        this(clusterName, Collections.emptyList());
    }

    public ClusterStoreProperties(String clusterName, List<String> prioritizedSchemes) {
        this(clusterName, prioritizedSchemes, Collections.emptyMap());
    }

    public ClusterStoreProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties) {
        this(clusterName, prioritizedSchemes, properties, new HashSet<URI>());
    }

    public ClusterStoreProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris) {
        this(clusterName, prioritizedSchemes, properties, bannedUris, NullPartitionProperties.getInstance());
    }

    public ClusterStoreProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties) {
        this(clusterName, prioritizedSchemes, properties, bannedUris, partitionProperties, Collections.emptyList());
    }

    public ClusterStoreProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties, List<String> sslSessionValidationStrings) {
        this(clusterName, prioritizedSchemes, properties, bannedUris, partitionProperties, sslSessionValidationStrings, (Map<String, Object>)null, false);
    }

    public ClusterStoreProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties, List<String> sslSessionValidationStrings, Map<String, Object> darkClusters, boolean delegated) {
        this(clusterName, prioritizedSchemes, properties, bannedUris, partitionProperties, sslSessionValidationStrings, darkClusters, delegated, null, null, null);
    }

    public ClusterStoreProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties, List<String> sslSessionValidationStrings, Map<String, Object> darkClusters, boolean delegated, ClusterProperties canaryConfigs, CanaryDistributionStrategy distributionStrategy) {
        super(clusterName, prioritizedSchemes, properties, bannedUris, partitionProperties, sslSessionValidationStrings, darkClusters, delegated);
        this._canaryConfigs = canaryConfigs;
        this._canaryDistributionStrategy = distributionStrategy;
        this._failoutProperties = null;
    }

    public ClusterStoreProperties(ClusterProperties stableConfigs, ClusterProperties canaryConfigs, CanaryDistributionStrategy distributionStrategy, FailoutProperties failoutProperties) {
        super(stableConfigs.getClusterName(), stableConfigs.getPrioritizedSchemes(), stableConfigs.getProperties(), stableConfigs.getBannedUris(), stableConfigs.getPartitionProperties(), stableConfigs.getSslSessionValidationStrings(), stableConfigs.getDarkClusters(), stableConfigs.isDelegated());
        this._canaryConfigs = canaryConfigs;
        this._canaryDistributionStrategy = distributionStrategy;
        this._failoutProperties = failoutProperties;
    }

    public ClusterStoreProperties(String clusterName, List<String> prioritizedSchemes, Map<String, String> properties, Set<URI> bannedUris, PartitionProperties partitionProperties, List<String> sslSessionValidationStrings, Map<String, Object> darkClusters, boolean delegated, ClusterProperties canaryConfigs, CanaryDistributionStrategy distributionStrategy, FailoutProperties failoutProperties) {
        super(clusterName, prioritizedSchemes, properties, bannedUris, partitionProperties, sslSessionValidationStrings, darkClusters, delegated);
        this._canaryConfigs = canaryConfigs;
        this._canaryDistributionStrategy = distributionStrategy;
        this._failoutProperties = failoutProperties;
    }

    public ClusterStoreProperties(ClusterProperties stableConfigs, ClusterProperties canaryConfigs, CanaryDistributionStrategy distributionStrategy) {
        super(stableConfigs.getClusterName(), stableConfigs.getPrioritizedSchemes(), stableConfigs.getProperties(), stableConfigs.getBannedUris(), stableConfigs.getPartitionProperties(), stableConfigs.getSslSessionValidationStrings(), stableConfigs.getDarkClusters(), stableConfigs.isDelegated());
        this._canaryConfigs = canaryConfigs;
        this._canaryDistributionStrategy = distributionStrategy;
        this._failoutProperties = null;
    }

    public ClusterProperties getCanaryConfigs() {
        return this._canaryConfigs;
    }

    public CanaryDistributionStrategy getCanaryDistributionStrategy() {
        return this._canaryDistributionStrategy;
    }

    public FailoutProperties getFailoutProperties() {
        return this._failoutProperties;
    }

    public boolean hasCanary() {
        return this._canaryConfigs != null && this._canaryDistributionStrategy != null;
    }

    public ClusterProperties getDistributedClusterProperties(CanaryDistributionProvider.Distribution distribution) {
        if (distribution.equals((Object)CanaryDistributionProvider.Distribution.CANARY) && this.hasCanary()) {
            return this._canaryConfigs;
        }
        return new ClusterProperties(this);
    }

    @Override
    public String toString() {
        return "ClusterStoreProperties [_stableClusterProperties=" + super.toString() + ", _canaryConfigs=" + this._canaryConfigs + ", _canaryDistributionStrategy=" + this._canaryDistributionStrategy + ", _failoutProperties=" + this._failoutProperties + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this._canaryConfigs == null ? 0 : this._canaryConfigs.hashCode());
        result = prime * result + (this._canaryDistributionStrategy == null ? 0 : this._canaryDistributionStrategy.hashCode());
        result = prime * result + (this._failoutProperties == null ? 0 : this._failoutProperties.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof ClusterStoreProperties && this.canaryEquals((ClusterStoreProperties)obj) && this.failoutEquals((ClusterStoreProperties)obj);
    }

    private boolean failoutEquals(ClusterStoreProperties other) {
        if (this._failoutProperties == null && other.getFailoutProperties() != null) {
            return false;
        }
        return this._failoutProperties == null || this._failoutProperties.equals(other.getFailoutProperties());
    }

    private boolean canaryEquals(ClusterStoreProperties other) {
        if (this.hasCanary() != other.hasCanary()) {
            return false;
        }
        return !this.hasCanary() || this._canaryConfigs.equals(other.getCanaryConfigs()) && this._canaryDistributionStrategy.equals(other.getCanaryDistributionStrategy());
    }
}

