/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.util.ArgumentUtil;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceProperties {
    private final String _serviceName;
    private final String _clusterName;
    private final String _path;
    private final List<String> _prioritizedStrategyList;
    private final Map<String, Object> _loadBalancerStrategyProperties;
    private final Map<String, Object> _transportClientProperties;
    private final Map<String, Object> _relativeStrategyProperties;
    private final List<Map<String, Object>> _backupRequests;
    private final Map<String, String> _degraderProperties;
    private final List<String> _prioritizedSchemes;
    private final Set<URI> _banned;
    private final Map<String, Object> _serviceMetadataProperties;
    private final boolean _enableClusterSubsetting;
    private final int _minClusterSubsetSize;

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList) {
        this(serviceName, clusterName, path, prioritizedStrategyList, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptySet());
    }

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptySet());
    }

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, Collections.emptyMap());
    }

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, serviceMetadataProperties, Collections.emptyList());
    }

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties, List<Map<String, Object>> backupRequests) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, serviceMetadataProperties, backupRequests, null);
    }

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties, List<Map<String, Object>> backupRequests, Map<String, Object> relativeStrategyProperties) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, serviceMetadataProperties, backupRequests, relativeStrategyProperties, false, -1);
    }

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties, List<Map<String, Object>> backupRequests, Map<String, Object> relativeStrategyProperties, boolean enableClusterSubsetting, int minClusterSubsetSize) {
        ArgumentUtil.notNull((Object)serviceName, (String)"serviceName");
        ArgumentUtil.notNull((Object)clusterName, (String)"clusterName");
        ArgumentUtil.notNull((Object)path, (String)"path");
        if (prioritizedStrategyList == null || prioritizedStrategyList.isEmpty()) {
            throw new NullPointerException("loadBalancerStrategyList is null or empty");
        }
        this._backupRequests = Collections.unmodifiableList(backupRequests == null ? Collections.emptyList() : backupRequests);
        this._serviceName = serviceName;
        this._clusterName = clusterName;
        this._path = path;
        this._prioritizedStrategyList = Collections.unmodifiableList(prioritizedStrategyList);
        this._loadBalancerStrategyProperties = loadBalancerStrategyProperties != null ? Collections.unmodifiableMap(loadBalancerStrategyProperties) : Collections.emptyMap();
        this._transportClientProperties = transportClientProperties != null ? Collections.unmodifiableMap(transportClientProperties) : Collections.emptyMap();
        this._degraderProperties = degraderProperties != null ? Collections.unmodifiableMap(degraderProperties) : Collections.emptyMap();
        this._prioritizedSchemes = prioritizedSchemes != null ? Collections.unmodifiableList(prioritizedSchemes) : Collections.emptyList();
        this._banned = banned != null ? Collections.unmodifiableSet(banned) : Collections.emptySet();
        this._serviceMetadataProperties = serviceMetadataProperties != null ? Collections.unmodifiableMap(serviceMetadataProperties) : Collections.emptyMap();
        this._relativeStrategyProperties = relativeStrategyProperties != null ? relativeStrategyProperties : Collections.emptyMap();
        this._enableClusterSubsetting = enableClusterSubsetting;
        this._minClusterSubsetSize = minClusterSubsetSize;
    }

    public ServiceProperties(ServiceProperties other) {
        this(other._serviceName, other._clusterName, other._path, other._prioritizedStrategyList, other._loadBalancerStrategyProperties, other._transportClientProperties, other._degraderProperties, other._prioritizedSchemes, other._banned, other._serviceMetadataProperties, other._backupRequests, other._relativeStrategyProperties, other._enableClusterSubsetting, other._minClusterSubsetSize);
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public List<String> getLoadBalancerStrategyList() {
        return this._prioritizedStrategyList;
    }

    public String getPath() {
        return this._path;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public Map<String, Object> getLoadBalancerStrategyProperties() {
        return this._loadBalancerStrategyProperties;
    }

    public Map<String, String> getDegraderProperties() {
        return this._degraderProperties;
    }

    public Map<String, Object> getRelativeStrategyProperties() {
        return this._relativeStrategyProperties;
    }

    public Map<String, Object> getTransportClientProperties() {
        return this._transportClientProperties;
    }

    public List<Map<String, Object>> getBackupRequests() {
        return this._backupRequests;
    }

    public List<String> getPrioritizedSchemes() {
        return this._prioritizedSchemes;
    }

    public Set<URI> getBanned() {
        return this._banned;
    }

    public boolean isBanned(URI uri) {
        return this._banned.contains(uri);
    }

    public Map<String, Object> getServiceMetadataProperties() {
        return this._serviceMetadataProperties;
    }

    public boolean isEnableClusterSubsetting() {
        return this._enableClusterSubsetting;
    }

    public int getMinClusterSubsetSize() {
        return this._minClusterSubsetSize;
    }

    public String toString() {
        return "ServiceProperties [_clusterName=" + this._clusterName + ", _path=" + this._path + ", _serviceName=" + this._serviceName + ", _loadBalancerStrategyList=" + this._prioritizedStrategyList + ", _loadBalancerStrategyProperties=" + this._loadBalancerStrategyProperties + ", _transportClientProperties=" + this._transportClientProperties + ", _relativeStrategyProperties=" + this._relativeStrategyProperties + ", _degraderProperties=" + this._degraderProperties + ", prioritizedSchemes=" + this._prioritizedSchemes + ", bannedUris=" + this._banned + ", serviceMetadata=" + this._serviceMetadataProperties + ", backupRequests=" + this._backupRequests + ", enableClusterSubsetting=" + this._enableClusterSubsetting + ", minimumClusterSubsetSize=" + this._minClusterSubsetSize + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._clusterName.hashCode();
        result = 31 * result + this._prioritizedStrategyList.hashCode();
        result = 31 * result + this._path.hashCode();
        result = 31 * result + this._serviceName.hashCode();
        result = 31 * result + this._loadBalancerStrategyProperties.hashCode();
        result = 31 * result + this._degraderProperties.hashCode();
        result = 31 * result + this._transportClientProperties.hashCode();
        result = 31 * result + this._backupRequests.hashCode();
        result = 31 * result + this._prioritizedSchemes.hashCode();
        result = 31 * result + this._banned.hashCode();
        result = 31 * result + this._serviceMetadataProperties.hashCode();
        result = 31 * result + this._relativeStrategyProperties.hashCode();
        result = 31 * result + Boolean.hashCode(this._enableClusterSubsetting);
        result = 31 * result + Integer.hashCode(this._minClusterSubsetSize);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceProperties other = (ServiceProperties)obj;
        if (!this._clusterName.equals(other._clusterName)) {
            return false;
        }
        if (!this._prioritizedStrategyList.equals(other._prioritizedStrategyList)) {
            return false;
        }
        if (!this._path.equals(other._path)) {
            return false;
        }
        if (!this._serviceName.equals(other._serviceName)) {
            return false;
        }
        if (!this._loadBalancerStrategyProperties.equals(other._loadBalancerStrategyProperties)) {
            return false;
        }
        if (!this._transportClientProperties.equals(other._transportClientProperties)) {
            return false;
        }
        if (!this._backupRequests.equals(other._backupRequests)) {
            return false;
        }
        if (!this._degraderProperties.equals(other._degraderProperties)) {
            return false;
        }
        if (!this._prioritizedSchemes.equals(other._prioritizedSchemes)) {
            return false;
        }
        if (!this._banned.equals(other._banned)) {
            return false;
        }
        if (!this._serviceMetadataProperties.equals(other._serviceMetadataProperties)) {
            return false;
        }
        if (!this._relativeStrategyProperties.equals(other._relativeStrategyProperties)) {
            return false;
        }
        if (this._enableClusterSubsetting != other._enableClusterSubsetting) {
            return false;
        }
        return this._minClusterSubsetSize == other._minClusterSubsetSize;
    }
}

