/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.AllowedClientPropertyKeys;
import com.linkedin.d2.balancer.properties.CanaryDistributionStrategy;
import com.linkedin.d2.balancer.properties.ClientServiceConfigValidator;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.ServiceStoreProperties;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.d2.balancer.util.JacksonUtil;
import com.linkedin.d2.discovery.PropertyBuilder;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.r2.util.ConfigValueExtractor;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePropertiesJsonSerializer
implements PropertySerializer<ServiceProperties>,
PropertyBuilder<ServiceProperties> {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePropertiesJsonSerializer.class);
    private static final String LIST_SEPARATOR = ",";
    private final Map<String, Map<String, Object>> _clientServicesConfig;

    public ServicePropertiesJsonSerializer() {
        this(Collections.emptyMap());
    }

    public ServicePropertiesJsonSerializer(Map<String, Map<String, Object>> clientServicesConfig) {
        this._clientServicesConfig = this.validateClientServicesConfig(clientServicesConfig);
    }

    private Map<String, Map<String, Object>> validateClientServicesConfig(Map<String, Map<String, Object>> clientServicesConfig) {
        HashMap<String, Map<String, Object>> validatedClientServicesConfig = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : clientServicesConfig.entrySet()) {
            String serviceName = entry.getKey();
            Map<String, Object> clientConfigForSingleService = entry.getValue();
            HashMap<String, Object> validatedClientConfigForSingleService = new HashMap<String, Object>();
            for (Map.Entry<String, Object> innerMapEntry : clientConfigForSingleService.entrySet()) {
                String clientSuppliedConfigKey = innerMapEntry.getKey();
                Object clientSuppliedConfigValue = innerMapEntry.getValue();
                if (!AllowedClientPropertyKeys.isAllowedConfigKey(clientSuppliedConfigKey)) continue;
                validatedClientConfigForSingleService.put(clientSuppliedConfigKey, clientSuppliedConfigValue);
                LOG.info("Client supplied config key {} for service {}", new Object[]{clientSuppliedConfigKey, serviceName});
            }
            if (validatedClientConfigForSingleService.isEmpty()) continue;
            validatedClientServicesConfig.put(serviceName, validatedClientConfigForSingleService);
        }
        return validatedClientServicesConfig;
    }

    private Map<String, Object> getTransportClientPropertiesWithClientOverrides(String serviceName, Map<String, Object> transportClientProperties) {
        Object allowedClientOverrideKeysObj = transportClientProperties.get("allowedClientOverrideKeys");
        HashSet allowedClientOverrideKeys = new HashSet(ConfigValueExtractor.buildList((Object)allowedClientOverrideKeysObj, (String)LIST_SEPARATOR));
        Map<String, Object> clientSuppliedServiceProperties = this._clientServicesConfig.get(serviceName);
        if (clientSuppliedServiceProperties != null) {
            LOG.debug("Client supplied configs for service {}", new Object[]{serviceName});
            for (String clientSuppliedKey : clientSuppliedServiceProperties.keySet()) {
                if (allowedClientOverrideKeys.contains(clientSuppliedKey)) {
                    if (ClientServiceConfigValidator.isValidValue(transportClientProperties, clientSuppliedServiceProperties, clientSuppliedKey)) {
                        transportClientProperties.put(clientSuppliedKey, clientSuppliedServiceProperties.get(clientSuppliedKey));
                        LOG.info("Client overrode config property {} for service {}. This is being used to instantiate the Transport Client", new Object[]{clientSuppliedKey, serviceName});
                        continue;
                    }
                    LOG.warn("Client supplied config property {} with an invalid value {} for service {}", new Object[]{clientSuppliedKey, clientSuppliedServiceProperties.get(clientSuppliedKey), serviceName});
                    continue;
                }
                LOG.warn("Client failed to override config property {} that is disallowed by service {}. Continuing without override.", (Object)clientSuppliedKey, (Object)serviceName);
            }
        }
        return transportClientProperties;
    }

    public static void main(String[] args) throws UnsupportedEncodingException, URISyntaxException, PropertySerializationException {
        String serviceName = "testService";
        String clusterName = "testCluster";
        String path = "/foo/bar";
        List<String> loadBalancerStrategyList = Arrays.asList("degrader");
        ServiceProperties property = new ServiceProperties(serviceName, clusterName, path, loadBalancerStrategyList);
        ServicePropertiesJsonSerializer serializer = new ServicePropertiesJsonSerializer();
        System.err.println(new String(serializer.toBytes(property), "UTF-8"));
        System.err.println(serializer.fromBytes(serializer.toBytes(property)));
    }

    @Override
    public byte[] toBytes(ServiceProperties property) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsString((Object)property).getBytes("UTF-8");
        }
        catch (Exception e) {
            LOG.error("Failed to serialize ServiceProperties: " + property, (Throwable)e);
            return null;
        }
    }

    @Override
    public ServiceProperties fromBytes(byte[] bytes) throws PropertySerializationException {
        try {
            Map untyped = (Map)JacksonUtil.getObjectMapper().readValue(new String(bytes, "UTF-8"), Map.class);
            return this.fromMap(untyped);
        }
        catch (Exception e) {
            throw new PropertySerializationException(e);
        }
    }

    @Override
    public ServiceProperties fromMap(Map<String, Object> map) {
        ServiceProperties stableConfigs = this.buildServicePropertiesFromMap(map);
        ServiceProperties canaryConfigs = null;
        CanaryDistributionStrategy distributionStrategy = null;
        Map canaryConfigsMap = (Map)PropertyUtil.mapGet(map, "canaryConfigs");
        Map distributionStrategyMap = (Map)PropertyUtil.mapGet(map, "canaryDistributionStrategy");
        if (canaryConfigsMap != null && !canaryConfigsMap.isEmpty() && distributionStrategyMap != null && !distributionStrategyMap.isEmpty()) {
            canaryConfigs = this.buildServicePropertiesFromMap(canaryConfigsMap);
            distributionStrategy = new CanaryDistributionStrategy(PropertyUtil.mapGetOrDefault(distributionStrategyMap, "strategy", "disabled"), PropertyUtil.mapGetOrDefault(distributionStrategyMap, "percentageStrategyProperties", Collections.emptyMap()), PropertyUtil.mapGetOrDefault(distributionStrategyMap, "targetHostsStrategyProperties", Collections.emptyMap()), PropertyUtil.mapGetOrDefault(distributionStrategyMap, "targetApplicationsStrategyProperties", Collections.emptyMap()));
        }
        return new ServiceStoreProperties(stableConfigs, canaryConfigs, distributionStrategy);
    }

    private ServiceProperties buildServicePropertiesFromMap(Map<String, Object> map) {
        Map publishedMetadataProperties;
        String defaultRoutingToMaster;
        Map<String, Object> loadBalancerStrategyProperties = PropertyUtil.mapGetOrDefault(map, "loadBalancerStrategyProperties", Collections.emptyMap());
        List<String> loadBalancerStrategyList = PropertyUtil.mapGetOrDefault(map, "loadBalancerStrategyList", Collections.emptyList());
        Map<String, Object> transportClientProperties = PropertyUtil.mapGetOrDefault(map, "transportClientProperties", Collections.emptyMap());
        Map<String, String> degraderProperties = PropertyUtil.mapGetOrDefault(map, "degraderProperties", Collections.emptyMap());
        Map<String, Object> relativeStrategyProperties = PropertyUtil.mapGetOrDefault(map, "relativeStrategyProperties", Collections.emptyMap());
        boolean enableClusterSubsetting = map.containsKey("enableClusterSubsetting") ? PropertyUtil.coerce(map.get("enableClusterSubsetting"), Boolean.class) : false;
        int minClusterSubsetSize = map.containsKey("minClusterSubsetSize") ? PropertyUtil.coerce(map.get("minClusterSubsetSize"), Integer.class) : -1;
        List bannedList = PropertyUtil.mapGetOrDefault(map, "bannedUris", Collections.emptyList());
        HashSet<URI> banned = new HashSet<URI>(bannedList);
        List<String> prioritizedSchemes = PropertyUtil.mapGetOrDefault(map, "prioritizedSchemes", Collections.emptyList());
        HashMap<String, Object> metadataProperties = new HashMap<String, Object>();
        String isDefaultService = PropertyUtil.mapGetOrDefault(map, "isDefaultService", null);
        if ("true".equalsIgnoreCase(isDefaultService)) {
            metadataProperties.put("isDefaultService", isDefaultService);
        }
        if (Boolean.parseBoolean(defaultRoutingToMaster = (String)PropertyUtil.mapGetOrDefault(map, "defaultRoutingToMaster", null))) {
            metadataProperties.put("defaultRoutingToMaster", defaultRoutingToMaster);
        }
        if ((publishedMetadataProperties = (Map)PropertyUtil.mapGetOrDefault(map, "serviceMetadataProperties", null)) != null) {
            metadataProperties.putAll(publishedMetadataProperties);
        }
        List<Map<String, Object>> backupRequests = PropertyUtil.mapGetOrDefault(map, "backupRequests", Collections.emptyList());
        return new ServiceProperties((String)map.get("serviceName"), (String)map.get("clusterName"), (String)map.get("path"), loadBalancerStrategyList, loadBalancerStrategyProperties, this.getTransportClientPropertiesWithClientOverrides((String)map.get("serviceName"), transportClientProperties), degraderProperties, prioritizedSchemes, banned, metadataProperties, backupRequests, relativeStrategyProperties, enableClusterSubsetting, minClusterSubsetSize);
    }
}

