/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.CanaryDistributionStrategy;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.util.canary.CanaryDistributionProvider;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceStoreProperties
extends ServiceProperties {
    protected final ServiceProperties _canaryConfigs;
    protected final CanaryDistributionStrategy _canaryDistributionStrategy;

    public ServiceStoreProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList) {
        this(serviceName, clusterName, path, prioritizedStrategyList, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptySet());
    }

    public ServiceStoreProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, ServiceProperties canaryConfigs, CanaryDistributionStrategy distributionStrategy) {
        super(serviceName, clusterName, path, prioritizedStrategyList, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptySet());
        this._canaryConfigs = canaryConfigs;
        this._canaryDistributionStrategy = distributionStrategy;
    }

    public ServiceStoreProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptySet());
    }

    public ServiceStoreProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, Collections.emptyMap());
    }

    public ServiceStoreProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, serviceMetadataProperties, Collections.emptyList());
    }

    public ServiceStoreProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties, List<Map<String, Object>> backupRequests) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, serviceMetadataProperties, backupRequests, null);
    }

    public ServiceStoreProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties, List<Map<String, Object>> backupRequests, Map<String, Object> relativeStrategyProperties) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, serviceMetadataProperties, backupRequests, relativeStrategyProperties, false, -1);
    }

    public ServiceStoreProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties, List<Map<String, Object>> backupRequests, Map<String, Object> relativeStrategyProperties, boolean enableClusterSubsetting, int minClusterSubsetSize) {
        this(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, serviceMetadataProperties, backupRequests, relativeStrategyProperties, enableClusterSubsetting, minClusterSubsetSize, null, null);
    }

    public ServiceStoreProperties(String serviceName, String clusterName, String path, List<String> prioritizedStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties, List<Map<String, Object>> backupRequests, Map<String, Object> relativeStrategyProperties, boolean enableClusterSubsetting, int minClusterSubsetSize, ServiceProperties canaryConfigs, CanaryDistributionStrategy distributionStrategy) {
        super(serviceName, clusterName, path, prioritizedStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, serviceMetadataProperties, backupRequests, relativeStrategyProperties, enableClusterSubsetting, minClusterSubsetSize);
        this._canaryConfigs = canaryConfigs;
        this._canaryDistributionStrategy = distributionStrategy;
    }

    public ServiceStoreProperties(ServiceProperties stableConfigs, ServiceProperties canaryConfigs, CanaryDistributionStrategy distributionStrategy) {
        super(stableConfigs.getServiceName(), stableConfigs.getClusterName(), stableConfigs.getPath(), stableConfigs.getLoadBalancerStrategyList(), stableConfigs.getLoadBalancerStrategyProperties(), stableConfigs.getTransportClientProperties(), stableConfigs.getDegraderProperties(), stableConfigs.getPrioritizedSchemes(), stableConfigs.getBanned(), stableConfigs.getServiceMetadataProperties(), stableConfigs.getBackupRequests(), stableConfigs.getRelativeStrategyProperties(), stableConfigs.isEnableClusterSubsetting(), stableConfigs.getMinClusterSubsetSize());
        this._canaryConfigs = canaryConfigs;
        this._canaryDistributionStrategy = distributionStrategy;
    }

    public ServiceProperties getCanaryConfigs() {
        return this._canaryConfigs;
    }

    public CanaryDistributionStrategy getCanaryDistributionStrategy() {
        return this._canaryDistributionStrategy;
    }

    public boolean hasCanary() {
        return this._canaryConfigs != null && this._canaryDistributionStrategy != null;
    }

    public ServiceProperties getDistributedServiceProperties(CanaryDistributionProvider.Distribution distribution) {
        if (distribution.equals((Object)CanaryDistributionProvider.Distribution.CANARY) && this.hasCanary()) {
            return this._canaryConfigs;
        }
        return new ServiceProperties(this);
    }

    @Override
    public String toString() {
        return "ServiceStoreProperties [_stableServiceProperties=" + super.toString() + ", _canaryConfigs=" + this._canaryConfigs + ", _canaryDistributionStrategy=" + this._canaryDistributionStrategy + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this._canaryConfigs == null ? 0 : this._canaryConfigs.hashCode());
        result = prime * result + (this._canaryDistributionStrategy == null ? 0 : this._canaryDistributionStrategy.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof ServiceStoreProperties && this.canaryEquals((ServiceStoreProperties)obj);
    }

    private boolean canaryEquals(ServiceStoreProperties other) {
        if (this.hasCanary() != other.hasCanary()) {
            return false;
        }
        return !this.hasCanary() || this._canaryConfigs.equals(other.getCanaryConfigs()) && this._canaryDistributionStrategy.equals(other.getCanaryDistributionStrategy());
    }
}

