/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.PartitionData;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UriProperties {
    private final String _clusterName;
    private final Map<String, Map<Integer, Set<URI>>> _urisBySchemeAndPartition;
    private final Map<URI, Map<Integer, PartitionData>> _partitionDesc;
    private final Map<URI, Map<String, Object>> _uriSpecificProperties;

    public UriProperties(String clusterName, Map<URI, Map<Integer, PartitionData>> partitionDescriptions) {
        this(clusterName, partitionDescriptions, Collections.emptyMap());
    }

    public UriProperties(String clusterName, Map<URI, Map<Integer, PartitionData>> partitionDescriptions, Map<URI, Map<String, Object>> uriSpecificProperties) {
        this._clusterName = clusterName;
        HashMap<URI, Map<Integer, PartitionData>> partitionDescriptionsMap = new HashMap<URI, Map<Integer, PartitionData>>(partitionDescriptions.size() * 2);
        for (Map.Entry<URI, Map<Integer, PartitionData>> entry : partitionDescriptions.entrySet()) {
            partitionDescriptionsMap.put(entry.getKey(), Collections.unmodifiableMap(new HashMap<Integer, PartitionData>(entry.getValue())));
        }
        this._partitionDesc = Collections.unmodifiableMap(partitionDescriptionsMap);
        HashMap<String, Map<Object, Object>> urisBySchemeAndPartition = new HashMap<String, Map<Object, Object>>();
        for (Map.Entry<URI, Map<Integer, PartitionData>> entry : this._partitionDesc.entrySet()) {
            URI uri = entry.getKey();
            HashMap<Integer, HashSet<URI>> map = (HashMap<Integer, HashSet<URI>>)urisBySchemeAndPartition.get(uri.getScheme());
            if (map == null) {
                map = new HashMap<Integer, HashSet<URI>>();
                urisBySchemeAndPartition.put(uri.getScheme(), map);
            }
            Map<Integer, PartitionData> partitions = entry.getValue();
            for (Integer partitionId : partitions.keySet()) {
                HashSet<URI> uriSet = (HashSet<URI>)map.get(partitionId);
                if (uriSet == null) {
                    uriSet = new HashSet<URI>();
                    map.put(partitionId, uriSet);
                }
                uriSet.add(uri);
            }
        }
        for (Map.Entry<URI, Map<Integer, PartitionData>> entry : urisBySchemeAndPartition.entrySet()) {
            String scheme = (String)((Object)entry.getKey());
            Map<Integer, PartitionData> partitionUris = entry.getValue();
            for (Map.Entry<Integer, PartitionData> partitionUriEntry : partitionUris.entrySet()) {
                partitionUris.put(partitionUriEntry.getKey(), (PartitionData)((Object)Collections.unmodifiableSet((Set)((Object)partitionUriEntry.getValue()))));
            }
            urisBySchemeAndPartition.put(scheme, Collections.unmodifiableMap(partitionUris));
        }
        this._urisBySchemeAndPartition = Collections.unmodifiableMap(urisBySchemeAndPartition);
        this._uriSpecificProperties = uriSpecificProperties == null ? Collections.emptyMap() : Collections.unmodifiableMap(uriSpecificProperties);
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public Set<URI> Uris() {
        return this._partitionDesc.keySet();
    }

    public Map<Integer, PartitionData> getPartitionDataMap(URI uri) {
        return this._partitionDesc.get(uri);
    }

    public Map<URI, Map<Integer, PartitionData>> getPartitionDesc() {
        return this._partitionDesc;
    }

    public Map<URI, Map<String, Object>> getUriSpecificProperties() {
        return this._uriSpecificProperties;
    }

    public Set<URI> getUriBySchemeAndPartition(String scheme, int partitionId) {
        Map<Integer, Set<URI>> schemeUris = this._urisBySchemeAndPartition.get(scheme);
        if (schemeUris == null) {
            return null;
        }
        return schemeUris.get(partitionId);
    }

    public String toString() {
        return "UriProperties [_clusterName=" + this._clusterName + ", _urisBySchemeAndPartition=" + this._urisBySchemeAndPartition + ", _partitions=" + this._partitionDesc + ", _uriSpecificProperties=" + this._uriSpecificProperties + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._clusterName == null ? 0 : this._clusterName.hashCode());
        result = 31 * result + (this._partitionDesc == null ? 0 : this._partitionDesc.hashCode());
        result = 31 * result + (this._urisBySchemeAndPartition == null ? 0 : this._urisBySchemeAndPartition.hashCode());
        result = 31 * result + (this._uriSpecificProperties == null ? 0 : this._uriSpecificProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriProperties other = (UriProperties)obj;
        if (this._clusterName == null ? other._clusterName != null : !this._clusterName.equals(other._clusterName)) {
            return false;
        }
        if (this._partitionDesc == null ? other._partitionDesc != null : !this._partitionDesc.equals(other._partitionDesc)) {
            return false;
        }
        if (this._urisBySchemeAndPartition == null ? other._urisBySchemeAndPartition != null : !this._urisBySchemeAndPartition.equals(other._urisBySchemeAndPartition)) {
            return false;
        }
        return !(this._uriSpecificProperties == null ? other._uriSpecificProperties != null : !this._uriSpecificProperties.equals(other._uriSpecificProperties));
    }
}

