/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPropertyMerger;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UriPropertiesMerger
implements ZooKeeperPropertyMerger<UriProperties> {
    @Override
    public UriProperties merge(String propertyName, Collection<UriProperties> propertiesToMerge) {
        HashMap<URI, Map<Integer, PartitionData>> partitionData = new HashMap<URI, Map<Integer, PartitionData>>();
        HashMap<URI, Map<String, Object>> uriSpecificProperties = new HashMap<URI, Map<String, Object>>();
        String clusterName = propertyName;
        for (UriProperties property : propertiesToMerge) {
            for (Map.Entry<URI, Map<Integer, PartitionData>> entry : property.getPartitionDesc().entrySet()) {
                partitionData.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<URI, Map<Object, Object>> entry : property.getUriSpecificProperties().entrySet()) {
                uriSpecificProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return new UriProperties(clusterName, partitionData, uriSpecificProperties);
    }

    @Override
    public String unmerge(String propertyName, UriProperties toDelete, Map<String, UriProperties> propertiesToMerge) {
        Set<URI> uris;
        if (toDelete.Uris().size() > 1) {
            // empty if block
        }
        if ((uris = toDelete.Uris()).size() == 0) {
            throw new IllegalArgumentException("The Uri to delete is not specified.");
        }
        URI uri = uris.iterator().next();
        for (Map.Entry<String, UriProperties> property : propertiesToMerge.entrySet()) {
            if (!property.getValue().Uris().contains(uri)) continue;
            return property.getKey();
        }
        return null;
    }
}

