/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties.util;

import com.linkedin.util.ArgumentUtil;
import java.util.Map;

public class PropertyUtil {
    public static <T> T checkAndGetValue(Map<String, Object> map, String key, Class<T> clazz, String scope) {
        Object obj = map.get(key);
        try {
            ArgumentUtil.notNull((Object)obj, (String)key);
            if (clazz.isEnum()) {
                T result = Enum.valueOf(clazz, ((String)obj).toUpperCase());
                return result;
            }
            return clazz.cast(obj);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("In " + scope + ": illegal argument " + key + " is missing or null", e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("In " + scope + ": illegal argument " + key + ": " + obj + " can not be casted to " + clazz, e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("In " + scope + ": illegal argument " + key + ": " + obj, e);
        }
    }

    public static <T> T mapGet(Map<String, Object> map, String key) {
        return (T)map.get(key);
    }

    public static <T> T mapGetOrDefault(Map<String, Object> map, String key, T defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public static Integer parseInt(String key, String intStr) {
        try {
            return Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(key + "is not an Integer", e);
        }
    }

    public static Long parseLong(String key, String intStr) {
        try {
            return Long.parseLong(intStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(key + "is not an long Integer", e);
        }
    }

    public static Double parseDouble(String key, String doubleStr) {
        try {
            return Double.parseDouble(doubleStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(key + "is not a double", e);
        }
    }

    public static <T> T coerce(Object value, Class<T> clazz) {
        if (clazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (clazz.equals(Double.class)) {
                return (T)Double.valueOf(Double.parseDouble(str));
            }
            if (clazz.equals(Float.class)) {
                return (T)Float.valueOf(Float.parseFloat(str));
            }
            if (clazz.equals(Long.class)) {
                return (T)Long.valueOf(Long.parseLong(str));
            }
            if (clazz.equals(Integer.class)) {
                return (T)Integer.valueOf(Integer.parseInt(str));
            }
            if (clazz.equals(Boolean.class)) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(str));
            }
        } else {
            throw new IllegalArgumentException("Cannot convert value of " + value.getClass() + " to class = " + clazz.getName());
        }
        return (T)value;
    }
}

